/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.*;
import de.uni_paderborn.fujaba.uml.update.*;
import de.uni_paderborn.fujaba.uml.update.UMLAbstractUpdater;
import de.uni_paderborn.fujaba.uml.update.UMLShowComponents;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: burmi $
 * @version   $Revision: 1.43.2.1 $
 */
public class UMMethod extends AbstractUnparseModule
{
   /**
    * Constructor for class UMMethod
    */
   public UMMethod()
   {
      super ("methodMainPanel");
   }


   /**
    * Get the childProperties attribute of the UMMethod object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      super.getChildProperties (props);
      props.add ("param");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      FSACollapsable container = (FSACollapsable) parent;
      FSAUnderlinedObject mainPanel = null;
      if (parent != null)
      {
         parent.setBackground (ColorsPreferences.get().CLASS_BACKGROUND);
         UMLMethod method = (UMLMethod) incr;

         if ( (method.getDisplayLevel() > FDeclaration.CODE_DISPLAY_LEVEL) &&
             ( (container.getPropertyName().equals ("signalPanel") && method.isSignal()) ||
             (container.getPropertyName().equals ("methodPanel") && !method.isSignal())))
         {
            mainPanel = new FSAUnderlinedObject (incr, getMainFsaName(), parent.getJComponent());

            mainPanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));
            mainPanel.setBackground (ColorsPreferences.get().CLASS_BACKGROUND);

            FSAComboBoxLabel iconLabel = new FSAComboBoxLabel (incr,
               "visibility",
               mainPanel.getJComponent(),
               new UMLMethodVisibilityJComboBoxLabel());
            iconLabel.addToUpdater (iconLabel.createDefaultUpdater());
            iconLabel.setBackground (FSAObject.COLOR_BACKGROUND);
            iconLabel.setForeground (FSAObject.COLOR_FOREGROUND);

            FSATextFieldLabel nameField = new FSATextFieldLabel (incr, "name", mainPanel.getJComponent());
            nameField.addToUpdater (nameField.createDefaultUpdater());
            nameField.setBold (false);

            // FSALabel would not be needed, JLabel would be enough
            FSALabel openBracket = new FSALabel (incr, "openBracket", mainPanel.getJComponent());
            openBracket.setText (" (");

            FSAPanel paramPanel = new FSAPanel (incr, "paramPanel", mainPanel.getJComponent());
            paramPanel.setOpaque (false);
            ColumnRowLayout layout = new ColumnRowLayout (0, ColumnRowLayout.ROW);
            layout.setDelimiter (", ");
            paramPanel.setLayout (layout);

            FSALabel closeBracket = new FSALabel (incr, "closeBracket", mainPanel.getJComponent());
            closeBracket.setText (")");

            FSALabel colonLabel = new FSALabel (incr, "colon", mainPanel.getJComponent());
            colonLabel.setText (" : ");

            FSAComboBoxLabel typeLabel = new FSAComboBoxLabel (incr, "resultType", mainPanel.getJComponent());
            typeLabel.setModel (UMLTypeListComboBoxModel.get());
            typeLabel.setBold (false);

            // establish visibility updater between the swing representatives, only
            // It is necessary for inner graphic listeners that such
            // listeners are addes before the updater between the
            // logical increment and the fsa object because otherwise
            // no initial value changed event is fired.
            typeLabel.getJComponent().addPropertyChangeListener ("value", new LabelUpdaterForResultType (openBracket.getJComponent(), closeBracket.getJComponent(), colonLabel.getJComponent(), typeLabel.getJComponent()));

            // updater for changes to the resultType
            typeLabel.addToUpdater (typeLabel.createDefaultUpdater());
            // additional listener, needed if only the name of the type changes
            typeLabel.addToUpdater (new TypeUpdater (incr, "resultType", typeLabel.getDefaultAttrName()));

            FSALabel stereotypeLabel = new StereotypeLabel (method, mainPanel.getJComponent());
            stereotypeLabel.addToUpdater (new VisibilityUpdater (incr, "stereotypes"));

            iconLabel.setOpaque (true);

            // create and add updater
            new UMLAbstractUpdater (mainPanel, incr);
            new UMLStaticUpdater (mainPanel, incr);
            new UMLShowComponents (mainPanel, incr);
            mainPanel.setOpaque (false);
         }
      }
      return mainPanel;
   }


   /**
    * Get the containerForProperty attribute of the UMMethod object
    *
    * @param property  No description provided
    * @return          The containerForProperty value
    */
   public String getContainerForProperty (String property)
   {
      if ("param".equals (property))
      {
         return "paramPanel";
      }
      else
      {
         return super.getContainerForProperty (property);
      }
   }

}


/*
 *  package
 */
/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: burmi $
 * @version   $Revision: 1.43.2.1 $
 */
class LabelUpdaterForResultType implements PropertyChangeListener
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JLabel label1 = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JLabel label2 = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JLabel label3 = null;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   DefaultJComboBoxLabel comboBox = null;


   /**
    * Constructor for class LabelUpdaterForResultType
    *
    * @param label1    No description provided
    * @param label2    No description provided
    * @param label3    No description provided
    * @param comboBox  No description provided
    */
   public LabelUpdaterForResultType (JComponent label1, JComponent label2, JComponent label3, JComponent comboBox)
   {
      this.label1 = (JLabel) label1;
      this.label2 = (JLabel) label2;
      this.label3 = (JLabel) label3;
      this.comboBox = (DefaultJComboBoxLabel) comboBox;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param evt  No description provided
    */
   public void propertyChange (PropertyChangeEvent evt)
   {
      Object value = evt.getNewValue();
      if (value instanceof UMLBaseTypes)
      {
         String name =  ((UMLBaseTypes) value).getName();
         if (name.equals (UMLBaseTypes.INITIALIZER))
         {
            label1.setVisible (false);
            label2.setVisible (false);
            label3.setVisible (false);
            comboBox.setVisible (true);
         }
         else
            if (name.equals (UMLBaseTypes.CONSTRUCTOR))
         {
            label1.setVisible (true);
            label2.setVisible (true);
            label3.setVisible (false);
            comboBox.setVisible (false);
         }
         else
         {
            label1.setVisible (true);
            label2.setVisible (true);
            label3.setVisible (true);
            comboBox.setVisible (true);
         }
      }
   }
}

/*
 * $Log: UMMethod.java,v $
 * Revision 1.43.2.1  2006/01/21 20:23:17  burmi
 * added check for parent not to be null
 *
 */
