/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.util.Set;

import de.uni_paderborn.fujaba.fsa.FSALayeredPane;
import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.JDiagramPane;
import de.uni_paderborn.fujaba.fsa.swing.NoLayout;
import de.uni_paderborn.fujaba.fsa.unparse.*;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.20 $
 */
public abstract class UMDiagram extends AbstractUnparseModule
{
   /**
    * Get the childProperties attribute of the UMDiagram object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      super.getChildProperties (props);
      // the properties which trigger unparsing of child items
      // in the logic (aka uml) hierarchy
      // in diagrams this is usually the items-association
      props.add ("items");
      props.add ("constraints");
   }


   /**
    * create the base structure for an UMLActivityDiagram. parent is usually null.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      // special layering for diagrams (lines in background, bends before them,
      // everything else up front) is handled by JDiagramPane
      JDiagramPane pane = new JDiagramPane();
      pane.setBackground (ColorsPreferences.get().DIAGRAM_BACKGROUND);
      pane.setForeground (FSAObject.COLOR_FOREGROUND);
      pane.setOpaque (true);
      pane.setDoubleBuffered (true);

      AscendDescendMouseHandler.addMouseListener (pane, PopupListener.get());
      AscendDescendMouseHandler.addMouseListener (pane, HideEditorsMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (pane, RectangularSelectionListener.get());
      AscendDescendMouseHandler.addMouseInputListener (pane, AscendDescendMouseHandler.getDescendConsumer());

      // second parameter of the Constructor is the name
      // by which this component can be found
      // (along with the parent id) again in the UMLIncr
      //
      // The name of the main component for an ASGElement should always
      // match the name returned by getMainFsaName()
      // (which can be set in the UnparseModule-Constructor by super(name))
      FSALayeredPane layeredPane = new FSALayeredPane (incr, getMainFsaName(), FSAInterface.getJComponent (parent), pane);

      //layout should only set all Components' size to their preferred size
      layeredPane.setLayout (new NoLayout());

      return layeredPane;
   }
}

/*
 * $Log: UMDiagram.java,v $
 * Revision 1.20  2004/11/03 11:47:59  lowende
 * Javadoc warnings removed.
 *
 */
