/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.FSAPolyLine;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.JLine;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14 $
 */
public class UMConnection extends AbstractUnparseModule
{
   /**
    * Constructor for class UMConnection
    *
    * @param name  No description provided
    */
   public UMConnection (String name)
   {
      super (name);
   }


   /**
    * Constructor for class UMConnection
    */
   public UMConnection()
   {
      this ("line");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      //create line
      FSAPolyLine line = new FSAPolyLine (incr, getMainFsaName(), parent.getJComponent());
      line.setTransientProperties (false);
      JLine jLine = (JLine) line.getJComponent();

      SelectionListenerHelper.addSelectionListener (jLine, SelectionPropagationListener.get (SelectionPropagationListener.CHILDREN));
      SelectionListenerHelper.addSelectionListener (jLine, ForegroundHighlighter.get());
      SelectionListenerHelper.addSelectionListener (jLine, LineBendHighlighter.get());
      AscendDescendMouseHandler.addMouseInputListener (jLine, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jLine, DoubleClickMouseListener.get());

      return line;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param target  No description provided
    * @param incr    No description provided
    */
   public void remove (FSAObject target, LogicUnparseInterface incr)
   {
       ((FSAPolyLine) target).removeYouWithBends (true);
      super.remove (target, incr);
   }
}

/*
 * $Log: UMConnection.java,v $
 * Revision 1.14  2005/03/18 16:33:28  lowende
 * Bug in creating activity diagram fixed.
 *
 */
