/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.util.Set;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.ColumnRowLayout;
import de.uni_paderborn.fujaba.fsa.swing.border.StateBorder;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.VisibilityUpdater;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.20.2.2 $
 */
public class UMComplexState extends AbstractUnparseModule
{
   /**
    * Get the childProperties attribute of the UMClass object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      super.getChildProperties (props);
      props.add ("story");
      props.add ("contains");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      // main panel
      FSAPanel statePanel = new FSAPanel (incr, getMainFsaName(), parent.getJComponent(), false);
//      statePanel.setTransientProperties (false);
      statePanel.setLayout (new ColumnRowLayout (5, ColumnRowLayout.COLUMN));
      statePanel.setBorder (new StateBorder());

      // mouse listeners
      JPanel jPanel = (JPanel) statePanel.getJComponent();
      AscendDescendMouseHandler.addMouseInputListener (jPanel, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DragMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, ComponentCursorListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, ComponentBorderListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DoubleClickMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, AscendDescendMouseHandler.getDescendConsumer());
      SelectionListenerHelper.addSelectionListener (jPanel, BorderHighlighter.get());

      // state name
      FSATextFieldLabel stateNameTextField = new FSATextFieldLabel (incr, "name", jPanel);
      stateNameTextField.setHorizontalAlignment (SwingConstants.CENTER);
      stateNameTextField.addToUpdater (stateNameTextField.createDefaultUpdater());

      // separator
      new FSASeparator (incr, "nameSeparator", jPanel);

      // entry event
      FSAPanel entryPanel = new FSAPanel (incr, "entryPanel", jPanel);
      entryPanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));
      entryPanel.addToUpdater (new VisibilityUpdater (incr, "entryAction"));

      FSALabel entryLabel = new FSALabel (incr, "entryLabel", entryPanel.getJComponent());
      entryLabel.setText ("entry / ");

      FSATextFieldLabel entryAction = new FSATextFieldLabel (incr, "entryAction", entryPanel.getJComponent());
      entryAction.addToUpdater (entryAction.createDefaultUpdater());

      // do event
      FSAPanel doPanel = new FSAPanel (incr, "doPanel", jPanel);
      doPanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));
      doPanel.addToUpdater (new VisibilityUpdater (incr, "doAction"));

      FSALabel doLabel = new FSALabel (incr, "doLabel", doPanel.getJComponent());
      doLabel.setText ("do / ");

      FSATextFieldLabel doAction = new FSATextFieldLabel (incr, "doAction", doPanel.getJComponent());
      doAction.addToUpdater (doAction.createDefaultUpdater());

      // exit event
      FSAPanel exitPanel = new FSAPanel (incr, "exitPanel", jPanel);
      exitPanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));
      exitPanel.addToUpdater (new VisibilityUpdater (incr, "exitAction"));

      FSALabel exitLabel = new FSALabel (incr, "exitLabel", exitPanel.getJComponent());
      exitLabel.setText ("exit / ");

      FSATextFieldLabel exitAction = new FSATextFieldLabel (incr, "exitAction", exitPanel.getJComponent());
      exitAction.addToUpdater (exitAction.createDefaultUpdater());

      // separator
      new FSASeparator (incr, "compositeSeparator", jPanel);

      // composite state
      FSAPanel compositePanel = new FSAPanel (incr, "compositePanel", jPanel);
      compositePanel.setLayout (new ColumnRowLayout (5, ColumnRowLayout.ROW));

      // separator
      new FSASeparator (incr, "storySeparator", jPanel);

      // story pattern
      FSAPanel storyPanel = new FSAPanel (incr, "storyPanel", jPanel);
      storyPanel.setLayout (new ColumnRowLayout (5, ColumnRowLayout.COLUMN));

      return statePanel;
   }


   /**
    * Get the containerForProperty attribute of the UMComplexState object
    *
    * @param property  No description provided
    * @return          The containerForProperty value
    */
   public String getContainerForProperty (String property)
   {
      if ("contains".equals (property))
      {
         return "compositePanel";
      }
      else if ("story".equals (property))
      {
         return "storyPanel";
      }

      return super.getContainerForProperty (property);
   }

}

/*
 * $Log: UMComplexState.java,v $
 * Revision 1.20.2.2  2005/08/23 08:24:53  lowende
 * Removed compile warnings.
 *
 */
