/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.Set;

import javax.swing.JComponent;
import javax.swing.SwingConstants;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.swing.border.LineBorder;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.layout.options.LayoutPreferences;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.UMLClass;
import de.uni_paderborn.fujaba.uml.update.ClassCompartmentVisibilityUpdater;
import de.uni_paderborn.fujaba.uml.update.UMLAbstractUpdater;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.60.2.3 $
 */
public class UMClass extends AbstractUnparseModule
{
   /**
    * Get the childProperties attribute of the UMClass object
    *
    * @param props  No description provided
    */
   public void getChildProperties (Set props)
   {
      super.getChildProperties (props);
      props.add ("attrs");
      props.add ("methods");
      props.add ("stereotypes");
      props.add ("signals");
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLClass clazz = (UMLClass) incr;

      Color classBackground = ColorsPreferences.get().CLASS_BACKGROUND;

      // the main component for the class
      FSASeparatedPanel panel = new FSASeparatedPanel (incr, getMainFsaName(), parent.getJComponent(), false);
      //panel.setTransientProperties (false);
      panel.setBorder (new LineBorder (Color.black));
      panel.setBackground (classBackground);

      JComponent jPanel = panel.getJComponent();
      jPanel.addKeyListener (ArrowMoveListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, ComponentCursorListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, ComponentBorderListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, SelectionMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DragMouseListener.get());
      AscendDescendMouseHandler.addMouseInputListener (jPanel, DoubleClickMouseListener.get());
      SelectionListenerHelper.addSelectionListener (jPanel, BorderHighlighter.get());
      SelectionListenerHelper.addSelectionListener (jPanel, ArrowMoveListener.get());

      // -------------------------
      // the defaulticon
      // -------------------------
      FSAPanel tmpPanel = new FSAPanel (incr, "iconPanel", panel.getJComponent());
      tmpPanel.setOpaque (false);
      tmpPanel.setLayout (new BorderLayout());
      FSALabel iconLabel = new FSALabel (incr, "icon", null);
      tmpPanel.getJComponent().add (iconLabel.getJComponent(), BorderLayout.EAST);

      AbstractUpdater updater = new LogicToFsaUpdater();
      Translator trans = StringToIconTranslator.get();
      updater.setTranslator (trans);
      updater.setLogicAttrName ("defaultIcon");
      updater.setFsaAttrName ("icon");
      updater.setLogicObject (clazz);

      iconLabel.addToUpdater (updater);

      updater = new VisibilityUpdater (clazz, "defaultIcon");
      tmpPanel.addToUpdater (updater);

      // -------------------------
      // the panel for stereotypes
      // -------------------------
      tmpPanel = new FSAPanel (incr, "stereotypePanel", panel.getJComponent());
      tmpPanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.COLUMN));
      tmpPanel.setBackground (classBackground);

      // compartment observer for the class.
      updater = new ClassCompartmentVisibilityUpdater (incr, "stereotypes");
      tmpPanel.addToUpdater (updater);

      // -------------------------
      // the name field.
      // -------------------------
      FSAUnderlinedObject namePanel = new FSAUnderlinedObject (incr, "classNamePanel", panel.getJComponent());
      namePanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.COLUMN));
      namePanel.setBackground (classBackground);

      FSATextFieldLabel classNameTextField = new FSATextFieldLabel (incr, "name", namePanel.getJComponent());
      classNameTextField.setBackground (classBackground);

      // default updater handles text changes
      updater = classNameTextField.createDefaultUpdater();
      classNameTextField.addToUpdater (updater);

      // observer for the abstract flag of the class
      // and centering the text.
      updater = new UMLAbstractUpdater (classNameTextField, clazz);
      classNameTextField.setHorizontalAlignment (SwingConstants.CENTER);

      panel.addSeparator();

      // The attribute panel.
      // add the panel to the collapsable components.
      FSACollapsable tmpCollapsable;
      tmpCollapsable = new FSACollapsable (incr, "attributePanel", panel.getJComponent());
      tmpCollapsable.setTransientProperties (false);
      tmpCollapsable.setOpaque (false);
      tmpCollapsable.setLayoutComparator (IncrementComparator.get());
      updater = new ClassCompartmentVisibilityUpdater (incr, "attrs");
      tmpCollapsable.addToUpdater (updater);

      panel.addSeparator();
      tmpCollapsable = new FSACollapsable (incr, "methodPanel", panel.getJComponent());
      tmpCollapsable.setTransientProperties (false);
      tmpCollapsable.setLayoutComparator (MethodComparator.get());
      updater = new ClassCompartmentVisibilityUpdater (incr, "methods");
      tmpCollapsable.addToUpdater (updater);

      panel.addSeparator();
      JExtendedSeparator separator = panel.getLastSeparator();
      separator.setShowWithSecond (true);

      tmpCollapsable = new FSACollapsable (incr, "signalPanel", panel.getJComponent());
      tmpCollapsable.setCollapsed (LayoutPreferences.get().isCollapseClasses());
      tmpCollapsable.setTransientProperties (false);
      tmpCollapsable.setLayoutComparator (IncrementComparator.get());
      updater = new ClassCompartmentVisibilityUpdater (incr, "signals");
      tmpCollapsable.addToUpdater (updater);

      FSALabel signalLabel = new FSALabel (incr, "signalLabel", tmpCollapsable.getJComponent());
      signalLabel.setText ("\u00absignals\u00bb");
      signalLabel.setCentered (true);

      return panel;
   }


   /**
    * Get the containerForProperty attribute of the UMClass object
    *
    * @param property  No description provided
    * @return          The containerForProperty value
    */
   public String getContainerForProperty (String property)
   {
      // get unparse target for elements of a property

      // all UMLMethods that are added to the UMLClass fire a "methods"-propertyChange.
      // The target where they should be unparsed is determined by that name
      // so "methodPanel" is the correct result
      if ("methods".equals (property))
      {
         return "methodPanel";
      }
      else if ("stereotypes".equals (property))
      {
         return "stereotypePanel";
      }
      else if ("attrs".equals (property))
      {
         return "attributePanel";
      }
      else if ("signals".equals (property))
      {
         return "signalPanel";
      }

      return super.getContainerForProperty (property);
   }
}

/*
 * $Log: UMClass.java,v $
 * Revision 1.60.2.3  2005/11/14 21:55:18  lowende
 * The collapsed property of classes is now loaded correctly again
 * and(!) the preferences options for collapsing classes works for new (especially parsed) classes now.
 *
 */
