/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.AbstractUnparseModule;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.preferences.ColorsPreferences;
import de.uni_paderborn.fujaba.uml.UMLAttr;
import de.uni_paderborn.fujaba.uml.update.UMLShowComponents;
import de.uni_paderborn.fujaba.uml.update.UMLStaticUpdater;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.40 $
 */
public class UMAttr extends AbstractUnparseModule
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLAttr attr = (UMLAttr) incr;
      FSAUnderlinedObject mainPanel = null;

      if (attr.getDisplayLevel() > FDeclaration.CODE_DISPLAY_LEVEL)
      {
         mainPanel = new FSAUnderlinedObject (incr, getMainFsaName(), parent.getJComponent());

         mainPanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));

         FSAComboBoxLabel iconLabel = new FSAComboBoxLabel (incr, "umlVisibility", mainPanel.getJComponent(),
            new UMLAttrVisibilityJComboBoxLabel());

         iconLabel.addToUpdater (iconLabel.createDefaultUpdater());
         iconLabel.setForeground (FSAObject.COLOR_FOREGROUND);
         iconLabel.setBackground (ColorsPreferences.get().CLASS_BACKGROUND);

         FSATextFieldLabel nameField = new FSATextFieldLabel (incr, "nameUpdate", mainPanel.getJComponent());
         nameField.addToUpdater (nameField.createDefaultUpdater());
         nameField.setOpaque (false);
         // nameField.setBackground(Color.green);

         FSALabel colonLabel = new FSALabel (incr, "colon", mainPanel.getJComponent());
         colonLabel.setText (" : ");

         FSAComboBoxLabel typeLabel = new FSAComboBoxLabel (attr, "attrType", mainPanel.getJComponent());
         typeLabel.setModel (UMLTypeListComboBoxModel.get());
         typeLabel.setOpaque (false);

         // TODO: use a specific updater that calls handleAccessMethods afterwards, here.
         typeLabel.addToUpdater (typeLabel.createDefaultUpdater());

         AbstractUpdater updater = new TypeUpdater (attr, "attrType", typeLabel.getDefaultAttrName());
         typeLabel.addToUpdater (updater);

         FSAPanel initialValuePanel = new FSAPanel (incr, "initialValuePanel", mainPanel.getJComponent());
         initialValuePanel.setLayout (new ColumnRowLayout (0, ColumnRowLayout.ROW));
         initialValuePanel.setOpaque (false);

         FSALabel label = new FSALabel (incr, "equal", initialValuePanel.getJComponent());
         label.setText (" = ");

         FSATextFieldLabel initialValue = new FSATextFieldLabel (incr, "initialValue", initialValuePanel.getJComponent());
         initialValue.addToUpdater (initialValue.createDefaultUpdater());
         initialValue.setOpaque (false);

         updater = new VisibilityUpdater (incr, "initialValue");
         initialValuePanel.addToUpdater (updater);

         FSALabel stereotypeLabel = new StereotypeLabel (attr, mainPanel.getJComponent());
         stereotypeLabel.addToUpdater (new VisibilityUpdater (incr, "stereotypes"));

         mainPanel.setBold (false);
         iconLabel.setOpaque (true);

         new UMLStaticUpdater (mainPanel, incr);
         new UMLShowComponents (mainPanel, incr);
         // mainPanel.setOpaque (false);
         mainPanel.setBackground (ColorsPreferences.get().CLASS_BACKGROUND);

      }

      return mainPanel;
   }
}

/*
 * $Log: UMAttr.java,v $
 * Revision 1.40  2005/01/19 09:48:13  lowende
 * Bug in unparsing qualifier roles fixed.
 * Some updater for uml unparsing moved to uml.update
 *
 */
