/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.unparse;

import java.awt.*;
import java.util.Iterator;

import javax.swing.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.basic.FontContainer;
import de.uni_paderborn.fujaba.fsa.*;
import de.uni_paderborn.fujaba.fsa.listener.ForegroundHighlighter;
import de.uni_paderborn.fujaba.fsa.listener.SelectionListenerHelper;
import de.uni_paderborn.fujaba.fsa.swing.*;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.fsa.update.*;
import de.uni_paderborn.fujaba.uml.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.41.2.1 $
 */
public class UMAssoc extends UMConnection
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMAssoc.class);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param parent  No description provided
    * @param incr    No description provided
    * @return        No description provided
    */
   public FSAObject create (FSAObject parent, LogicUnparseInterface incr)
   {
      UMLAssoc assoc = (UMLAssoc) incr;

      if (parent.getLogic() instanceof UMLDiagram)
      {
         if (assoc.getLeftRole() != null && assoc.getRightRole() != null)
         {
            UMLClass leftClass = assoc.getLeftRole().getTarget();
            UMLClass rightClass = assoc.getRightRole().getTarget();
            UMLDiagram diag = (UMLDiagram) parent.getLogic();
            if (!diag.hasInElements (leftClass) || !diag.hasInElements (rightClass))
            {
               return null; // cancel unparsing when one class is not located in the same diagram
            }
         }
         else
         {
            log.error ("found defect assoc: " + assoc);
            return null;
         }
      }

      //create line
      FSAPolyLine line = (FSAPolyLine) super.create (parent, incr);
      line.setTransientProperties (false);
      JLine jLine = (JLine) line.getJComponent();

      // manage changes to leftRole
      Translator translator = new LogicFsaTranslator (line, 1);
      AbstractUpdater updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("leftRole");
      updater.setFsaAttrName ("startBend");
      updater.setLogicObject (assoc);

      line.addToUpdater (updater);

      // manage changes to rightRole
      updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("rightRole");
      updater.setFsaAttrName ("endBend");
      updater.setLogicObject (assoc);

      line.addToUpdater (updater);

      //	manage text panel to keep direction icon next to the link name
      FSAPanel textPanel = new FSAPanel (incr, "textPanel", jLine);
      textPanel.setLayout (new FlowLayout (FlowLayout.LEFT, 0, 0));
      JComponent jTextPanel = textPanel.getJComponent();

      // create arrow showing direction of assoc
      FSADirectionIndicator arrow = new FSADirectionIndicator (assoc, "arrow", jTextPanel);

      // add separator between icon and label
      textPanel.addToComponents (new JLabel (" "));

      // updater for target of arrow
      UMLRole target = assoc.getRightRole();
      updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("target");
      updater.setFsaAttrName ("target");
      updater.setLogicObject (target);
      arrow.addToUpdater (updater);

      // updater for source of arrow
      UMLRole source = assoc.getLeftRole();
      updater = new LogicToFsaUpdater();
      updater.setTranslator (translator);
      updater.setLogicAttrName ("target");
      updater.setFsaAttrName ("source");
      updater.setLogicObject (source);
      arrow.addToUpdater (updater);

      //manage assoc name
      FSATextFieldLabel label = new FSATextFieldLabel (assoc, "name", jTextPanel);
      updater = label.createDefaultUpdater();
      label.addToUpdater (updater);
      updater = new VisibilityUpdater (assoc, "name");
      label.addToUpdater (updater);

      //manage assoc stereotype
      FSALabel stereotypePanel = new FSALabel (assoc, "stereotype", jLine);
      String stereotypesText = "";
      {
         for (Iterator it = assoc.iteratorOfStereotypes(); it.hasNext(); )
         {
            UMLStereotype stereotype = (UMLStereotype) it.next();
            if (!"None".equals (stereotype.getText()))
            {
               stereotypesText += "<<" + stereotype.getText() + ">> ";
            }
         }
      }
      stereotypePanel.setText (stereotypesText);
      stereotypePanel.setOpaque (true);

      FSALabel constraintsO = new FSALabel (assoc, "constraintsO", jTextPanel);
      constraintsO.setText (" {ordered}");
      updater = new VisibilityUpdater (assoc, "constraints");
      updater.setTranslator (new CompareTranslator ("ordered"));
      constraintsO.addToUpdater (updater);

      FSALabel constraintsS = new FSALabel (assoc, "constraintsS", jTextPanel);
      constraintsS.setText (" {sorted}");
      updater = new VisibilityUpdater (assoc, "constraints");
      updater.setTranslator (new CompareTranslator ("sorted"));
      constraintsS.addToUpdater (updater);

      Iterator iter = assoc.iteratorOfConstraints();
      while (iter.hasNext())
      {
         UMLConstraint constr = (UMLConstraint) iter.next();
         if ("ordered".equals (constr.getText()))
         {
            constraintsO.setVisible (true);
         }
         else if ("sorted".equals (constr.getText()))
         {
            constraintsS.setVisible (true);
         }
      }

      JTextFieldLabel field = (JTextFieldLabel) label.getJComponent();
      field.setOpaque (false);
      field.setFont (FontContainer.getFont (FontContainer.DEFAULT_FONT, 0));
      SelectionListenerHelper.addSelectionListener (field, ForegroundHighlighter.get());

      if (jLine.getLayout() instanceof LayoutManager2)
      {
          ((LayoutManager2) jLine.getLayout()).
            addLayoutComponent (jTextPanel, new LineDecoratorConstraints (jLine, 0.5, 4, LineDecoratorConstraints.BORDER_ALIGN, LineDecoratorConstraints.TOP));

          ((LayoutManager2) jLine.getLayout()).
            addLayoutComponent (stereotypePanel.getJComponent(), new LineDecoratorConstraints (jLine, 0.2, 4, LineDecoratorConstraints.BORDER_ALIGN, LineDecoratorConstraints.TOP));
      }

      return line;
   }
}


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.41.2.1 $ $Date: 2005/09/30 18:56:53 $
 */
class CompareTranslator implements Translator
{


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Object compareTo = null;


   /**
    * Constructor for class CompareTranslator
    *
    * @param compareTo  No description provided
    */
   public CompareTranslator (Object compareTo)
   {
      this.compareTo = compareTo;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public Object translateFsaToLogic (Object value)
   {
      return null;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public Object translateLogicToFsa (Object value)
   {
      if (! (value instanceof UMLConstraint))
      {
         return Boolean.FALSE;
      }
      String text =  ((UMLConstraint) value).getText();
      return new Boolean (compareTo.equals (text));
   }
}

/*
 * $Log: UMAssoc.java,v $
 * Revision 1.41.2.1  2005/09/30 18:56:53  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
