/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.app.messages.WarningMessages;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.uml.UMLClassDiagram;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * Creates a new class diagram.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.18 $
 */
public class NewClassDiagramAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      UMLProject project = UMLProject.get();
      ASGDiagram diagram;
      boolean done = false;
      boolean found;

      FrameMain frameMain = FrameMain.get();

      try
      {
         while (!done)
         {
//            JOptionPane.showInputDialog (frameMain, "Please enter the name of the class diagram:")
            String prefix = "ClassDiagram";
            String name = prefix + "1";

            for (int i = 1; project.getFromDiags (prefix + i) != null; ++i)
            {
               name = prefix +  (i + 1);
            }

            if (name != null)
            {
               Iterator iter = project.iteratorOfDiags();

               found = false;
               if ( (name.trim().equals ("")))
               {
                  WarningMessages.warnUnnamedDiagram (frameMain, "class");
                  found = true;
               }

               while (!found && iter.hasNext())
               {
                  diagram = (ASGDiagram) iter.next();
                  if ( (diagram instanceof UMLClassDiagram) &&
                      (diagram.getName().equals (name)))
                  {
                     WarningMessages.warnDoubleIdentifiedDiagram (frameMain, "class", name);
                     found = true;
                  }
               }
               if (!found)
               {
                  UMLClassDiagram newDiag = new UMLClassDiagram (name, null);
                  project.addToDiags (newDiag);
                  frameMain.createNewTreeItems();
                  frameMain.selectTreeItem (newDiag);
                  Component selectedComponent = frameMain.getTabbedPaneProxy().getTabbedPane().getSelectedComponent();
                  if (selectedComponent instanceof JScrollPane)
                  {
                     selectedComponent =  ((JScrollPane) selectedComponent).getViewport().getView();
                  }

                  if (selectedComponent instanceof JTree)
                  {
                     JTree tree = (JTree) selectedComponent;
                     if (tree.isEditable())
                     {
                        tree.startEditingAtPath (tree.getSelectionPath());
                     }
                  }
                  done = true;
               }
            }
            else
            {
               done = true;
            }
         }
      }
      finally
      {
      }
   } // actionPerformed

}

/*
 * $Log: NewClassDiagramAction.java,v $
 * Revision 1.18  2004/11/03 11:47:58  lowende
 * Javadoc warnings removed.
 *
 */
