/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.EditActivityDialog;
import de.uni_paderborn.fujaba.uml.*;


/**
 * Creates a new activity.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.17 $
 */
public class NewActivityAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      Object source = e.getSource();
      if (source instanceof Iterator)
      {
         Iterator iter = (Iterator) source;
         if (iter.hasNext())
         {
            source = iter.next();
         }
         else
         {
            source = UMLProject.get().getCurrentDiagram();
         }
      }

      createActivity (source);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param source  No description provided
    */
   public void createActivity (Object source)
   {
      ASGElement asgElement = null;
      FrameMain frameMain = FrameMain.get();

      if (source instanceof ASGElement)
      {
         asgElement = (ASGElement) source;
      }

      UMLDiagram diagram = null;
      UMLTransition transition = null;

      if (asgElement instanceof UMLComplexState)
      {
         // try to find corresponding activity diagram
         diagram =  ((UMLComplexState) asgElement).getFirstFromContains();
      }
      else if (asgElement instanceof UMLTransition)
      {
         transition =  ((UMLTransition) asgElement);
         diagram = transition.getFirstFromDiagrams();
      }
      else
      {
         diagram = (UMLDiagram) asgElement;
      }

      if (diagram instanceof UMLActivityDiagram)
      {
         try
         {
            EditActivityDialog editActivityDialog = new EditActivityDialog (frameMain.getFrame(), diagram);
            editActivityDialog.show();
            final ASGElement newElement = editActivityDialog.getAsgElement();
            if (transition != null && newElement instanceof UMLActivity)
            {
               final UMLActivity revEntry = transition.getRevEntry();
               transition.setRevEntry ((UMLActivity) newElement);
               new UMLTransition ((UMLActivity) newElement, revEntry, new UMLTransitionGuard()).addToDiagrams (diagram);
            }

            UMLProject.get().refreshDisplay();
         }
         finally
         {
         }
      }
   }
}

/*
 * $Log: NewActivityAction.java,v $
 * Revision 1.17  2005/01/27 15:44:48  cschneid
 * bugfixes, new libraries, SDMObjectDialog improved, add activity in transition
 *
 */
