/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.gui.EditPathExprDialog;
import de.uni_paderborn.fujaba.uml.*;


/**
 * This action class creates a new path expression.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.8.2.1 $
 */
public class EditPathExprAction extends AbstractAction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (EditPathExprAction.class);


   /**
    * creates a path expression dialog
    *
    * @param e  the action event
    * @see      java.awt.event.ActionListener#actionPerformed(ActionEvent)
    */
   public void actionPerformed (ActionEvent e)
   {
      UMLProject proj = UMLProject.get();

      Object source = e.getSource();
      if (source instanceof Iterator)
      {
         Iterator iter = (Iterator) source;
         if (iter.hasNext())
         {
            source = iter.next();
         }
         else
         {
            source = proj.getCurrentDiagram();
         }
      }

      ASGElement asgElem = (ASGElement) source;

      if (asgElem instanceof UMLObject || asgElem instanceof UMLPath)
      {
         try
         {
            EditPathExprDialog dialog = new EditPathExprDialog (FrameMain.get().getFrame(), asgElem);
            dialog.show();
         }
         catch (Exception ex)
         {
            if (log.isInfoEnabled())
            {
               log.info ("Exception by opening EditPathExprDialog");
            }
            ex.printStackTrace();
         }
      }
      else
      {
         JOptionPane.showMessageDialog (null, "Please select an UML Object", "alert", JOptionPane.ERROR_MESSAGE);
      } // end of else

   }
}

/*
 * $Log: EditPathExprAction.java,v $
 * Revision 1.8.2.1  2005/09/30 18:56:52  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
