/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.gui.EditCollabStatDialog;
import de.uni_paderborn.fujaba.uml.*;


/**
 * Edit a collaboration statement.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.19 $
 */
public class EditCollabStatAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      FrameMain frameMain = FrameMain.get();
      UMLCollabStat myCollabStat = null;
      UMLObject callTarget = null;

      Object source = e.getSource();

      if (source instanceof Iterator)
      {
         Iterator iter = (Iterator) source;
         if (iter.hasNext())
         {
            source = iter.next();
         }
      }

      if (source instanceof UMLObject)
      {
         callTarget = (UMLObject) source;
         source = callTarget.getFirstFromDiagrams();
      }
      if (source instanceof UMLCollabStat)
      {
         myCollabStat = (UMLCollabStat) source;
         source = myCollabStat.findStoryPattern();
      }
      if (source instanceof UMLStoryPattern)
      {
         source =  ((UMLStoryPattern) source).getRevStoryPattern();
      }
      if (source instanceof UMLStoryActivity)
      {
         try
         {
            EditCollabStatDialog umlCollabStatEditor =
               new EditCollabStatDialog (frameMain.getFrame());

            if (myCollabStat != null)
            {
               umlCollabStatEditor.setIncrement (myCollabStat);
            }
            else
            {
               umlCollabStatEditor.setIncrement ((UMLStoryActivity) source);
            }

            if (callTarget != null)
            {
               umlCollabStatEditor.getTargetComboBox().setSelectedItem (callTarget);
            }

            umlCollabStatEditor.showCentered();
            UMLProject.get().refreshDisplay();
         }
         catch (Exception e2)
         {
            e2.printStackTrace();
         }
         finally
         {
         }
      }
   } // executeAction

}

/*
 * $Log: EditCollabStatAction.java,v $
 * Revision 1.19  2004/11/03 11:47:57  lowende
 * Javadoc warnings removed.
 *
 */
