/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.uml.*;


/**
 * This action class deletes a path expression from the diagram.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.9 $
 */
public class DeletePathExprAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      ASGElement asgElement = null;
      Object source = e.getSource();

      if (source instanceof Iterator)
      {
         Iterator iter = (Iterator) source;
         if (iter.hasNext())
         {
            source = iter.next();
         } // if
      } // if

      if (source instanceof ASGElement)
      {
         asgElement = (ASGElement) source;
      } // if

      if ( (asgElement != null) &&  (asgElement instanceof UMLPath))
      {
         try
         {
            UMLPath path = (UMLPath) asgElement;
            UMLObject target = path.getTarget();

            // look for the diagram increment
            Iterator diags = path.iteratorOfDiagrams();
            UMLDiagram diagram = null;
            if (diags != null)
            {
               while ( (diags.hasNext()) &&  (diagram == null))
               {
                  UMLDiagram diag = (UMLDiagram) diags.next();
                  if (diag.hasInElements (path))
                  {
                     diagram = diag;
                  }
               }
            }

            asgElement.removeYou();
            target.removeYou();
            UMLProject.get().refreshDisplay();
         } // try
         finally
         {
         }
      } // if
   } // actionPerformed

}

/*
 * $Log: DeletePathExprAction.java,v $
 * Revision 1.9  2004/10/20 17:50:16  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
