/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.uml.*;


/**
 * Delete the assoc.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.22.2.1 $
 */
public class DeleteAssocAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static Logger log = Logger.getLogger (DeleteAssocAction.class);


   /**
    * Sets the <code>Value</code> associated with the specified key.
    *
    * @param key       the <code>String</code> that identifies the stored object
    * @param newValue  the <code>Object</code> to store using this key
    * @see             javax.swing.Action#putValue
    */
   public void putValue (String key, Object newValue)
   {
      super.putValue (key, newValue);
   }


   /**
    * Gets the <code>Object</code> associated with the specified key.
    *
    * @param key  a string containing the specified <code>key</code>
    * @return     the binding <code>Object</code> stored with this key; if there are no keys,
    *      it will return <code>null</code>
    * @see        javax.swing.Action#getValue
    */
   public Object getValue (String key)
   {
      return super.getValue (key);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      UMLAssoc umlAssoc = null;
      Object source = event.getSource();
      if (source instanceof Iterator)
      {
         Iterator iter = (Iterator) source;
         while (iter.hasNext())
         {
            source = iter.next();

            if ( (source instanceof UMLAssoc) &&  (umlAssoc == null))
            {
               // delete the first assoc in the selection
               umlAssoc = (UMLAssoc) source;
            }
            else if ( (source instanceof UMLRole) &&  (umlAssoc == null))
            {
               umlAssoc =  ((UMLRole) source).getAssoc();
            }
         }
      }

      if (umlAssoc != null)
      {
         umlAssoc.removeYou();
         UMLProject.get().refreshDisplay();
      }
   } // executeAction

}

/*
 * $Log: DeleteAssocAction.java,v $
 * Revision 1.22.2.1  2006/06/07 09:13:31  creckord
 * - UMLTransitionGuard can be null instead of UMLTransitionGuard.NONE
 * - old "repair assoc" code removed (access methods are not kept, so repairing them is no longer needed)
 * - loop bends for assocs are removed when loop is removed
 *
 */
