/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.*;

import javax.swing.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.metamodel.FRole;
import de.uni_paderborn.fujaba.uml.*;


/**
 * AddButtonToMethodAction
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.8.2.1 $
 */
public class CreateTemplateForClassDiagramAction extends AbstractAction
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (CreateTemplateForClassDiagramAction.class);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      UMLProject proj = UMLProject.get();

      Object source = e.getSource();
      if (source instanceof Iterator)
      {
         Iterator iter = (Iterator) source;
         if (iter.hasNext())
         {
            source = iter.next();
         }
         else
         {
            source = proj.getCurrentDiagram();
         }
      }

      ASGElement incr = (ASGElement) source;

      if (incr instanceof UMLClassDiagram)
      {
         UMLClassDiagram diag = (UMLClassDiagram) incr;
         Iterator iter = diag.iteratorOfElements();

         List assocs = new LinkedList();
         String pack = "";
         while (iter.hasNext())
         {
            ASGElement tmpElement = (ASGElement) iter.next();
            if (tmpElement instanceof UMLClass)
            {
               UMLClass clazz = (UMLClass) tmpElement;
               String tmpPack = clazz.getDeclaredInPackage().getFullPackageName();
               if (!pack.equals (tmpPack))
               {
                  pack = tmpPack;
                  if (log.isInfoEnabled())
                  {
                     log.info ("package," + pack);
                  }
               }
               if (log.isInfoEnabled())
               {
                  log.info ("class," + clazz + "," + clazz.getSuperClass() + ","
                     + clazz.hasKeyInStereotypes (UMLStereotypeManager.INTERFACE));
               }
               Iterator attrs = clazz.iteratorOfAttrs();
               while (attrs.hasNext())
               {
                  UMLAttr attr = (UMLAttr) attrs.next();
                  if (attr.getDisplayLevel() > FDeclaration.CODE_DISPLAY_LEVEL)
                  {
                     if (log.isInfoEnabled())
                     {
                        log.info ("attr," + attr.getName() + "," + attr.getUMLType() + "," + clazz);
                     }
                  }
               }
            }
            else if (tmpElement instanceof UMLAssoc)
            {
               UMLAssoc assoc = (UMLAssoc) tmpElement;
               UMLRole leftRole = assoc.getLeftRole();
               UMLRole rightRole = assoc.getRightRole();
               int type = 0;
               if (rightRole.getAdornment() == FRole.NONE)
               {
                  if (leftRole.getAdornment() == FRole.AGGREGATION)
                  {
                     type = 2;
                  }
                  else if (leftRole.getAdornment() == FRole.COMPOSITION)
                  {
                     type = 4;
                  }
                  else if (leftRole.getAdornment() == FRole.REFERENCE)
                  {
                     type = 6;
                  }
               }
               else if (leftRole.getAdornment() == FRole.NONE)
               {
                  if (rightRole.getAdornment() == FRole.AGGREGATION)
                  {
                     type = 1;
                  }
                  else if (rightRole.getAdornment() == FRole.COMPOSITION)
                  {
                     type = 3;
                  }
                  else if (rightRole.getAdornment() == FRole.REFERENCE)
                  {
                     type = 5;
                  }

               }

               assocs.add ("assoc," + assoc.getName() + "," + rightRole.getTarget() + ","
                  + leftRole.getTarget() + "," + rightRole.getAttrName() + ","
                  + rightRole.getCard().getCardString() + "," + leftRole.getAttrName() + ","
                  + leftRole.getCard().getCardString() + "," + type);
            }
         }

         iter = assocs.iterator();
         while (iter.hasNext())
         {
            if (log.isInfoEnabled())
            {
               log.info (iter.next());
            }
         }
      }
   }

}

/*
 * $Log: CreateTemplateForClassDiagramAction.java,v $
 * Revision 1.8.2.1  2005/09/30 18:56:52  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
