/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.uml.*;



/**
 * @author    $Author: creckord $
 * @version   $Revision: 1.23.2.1 $
 */
public abstract class CreateSuccessorAbstractAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   UMLActivity activity;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   UMLActivityDiagram diagram;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {

      Object source = event.getSource();
      if (source instanceof Iterator)
      {
         Iterator iter = (Iterator) source;
         if (iter.hasNext())
         {
            source = iter.next();
         }
         else
         {
            source = UMLProject.get().getCurrentDiagram();
         }
      }

      if (source instanceof UMLStatementActivity)
      {
         activity = (UMLActivity) source;
      }
      else if (source instanceof UMLStoryPattern)
      {
         activity =  ((UMLStoryPattern) source).getRevStoryPattern();
      }
      else if (source instanceof UMLStoryActivity)
      {
         activity = (UMLStoryActivity) source;
      }
      else if (source instanceof UMLObject)
      {
         activity =  ((UMLStoryPattern)  ((UMLObject) source).getFirstFromDiagrams()).getRevStoryPattern();
      }
      else if (source instanceof UMLStartActivity)
      {
         activity = (UMLStartActivity) source;
      }
      else if (source instanceof UMLStopActivity)
      {
         activity = (UMLStopActivity) source;
      }
      else if (source instanceof UMLNopActivity)
      {
         activity = (UMLNopActivity) source;
      }
      else if (source instanceof UMLComplexState)
      {
         activity = (UMLComplexState) source;
      }
      else
      {
         // @@@ FIXME: if you select the border of an object, there will be a null-Pointer exception
         return;
      }
      diagram = activity.getActivityDiagram();

      UMLActivity newActivity = createNewActivity();

      // set the locations attribute of the newActivity from the coordinates and size of the old one
      FSAObject fsaObject = activity.getFirstFromFSAObjects();
      if (fsaObject != null)
      {
         JComponent jcomp = fsaObject.getJComponent();
         if (jcomp != null)
         {
            // transfer locations
            Point pos = new Point (jcomp.getX(), jcomp.getY() + jcomp.getHeight() + 70);

            newActivity.addPointToUnparseInformation (diagram, "entry", pos);
         }
      }

      diagram.addToElements (newActivity);
      diagram.addToElements (new UMLTransition (activity, newActivity, new UMLTransitionGuard (UMLTransitionGuard.NONE, "", null)));

      UMLProject.get().refreshDisplay();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public abstract UMLActivity createNewActivity();

}

/*
 * $Log: CreateSuccessorAbstractAction.java,v $
 * Revision 1.23.2.1  2005/12/15 15:21:51  creckord
 * - FujabaApp can determine the Fujaba install location now
 * - Template dir and default plugin dir are determined based on install location instead of current dir
 *
 * - UMLCollabStat has an int number for its sequence number now instead of noText
 * - hopefully fixed UMLCollabStats losing/messing up their order and number between save & load
 * - threadId is honored by renumbering methods and GUI
 *
 * - FTreeEnumeration can enumerate elements nested in other elements of target type now
 * - iterator/elementsOfClasses in FProject returns inner classes now, too
 *
 * - UMLClass doesn't lose inner classes anymore (hopefully)
 *
 */
