/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml.actions;

import java.awt.event.ActionEvent;
import java.util.Iterator;

import javax.swing.*;

import de.uni_paderborn.fujaba.fsa.FSAObject;
import de.uni_paderborn.fujaba.fsa.SelectionManager;
import de.uni_paderborn.fujaba.uml.*;


/**
 * Delete an activity.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.9 $
 */
public class AddActivityCommentAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param e  No description provided
    */
   public void actionPerformed (ActionEvent e)
   {
      try
      {
         Object source = e.getSource();
         if (source instanceof Iterator)
         {
            Iterator iter = (Iterator) source;
            while (iter.hasNext())
            {
               source = iter.next();

               if (! (source instanceof UMLStoryActivity))
               {
                  FSAObject[] objects = SelectionManager.get().getLastSelections (null, 1);
                  if (objects.length == 1)
                  {
                     UMLIncrement incr = (UMLIncrement) objects[0].getLogic();
                     if (incr instanceof UMLStoryActivity)
                     {
                        source = incr;
                     }
                  }
               }
            }
         }

         if (source != null && source instanceof UMLStoryActivity)
         {
            // set the comment attribute to some placeholder text
            UMLStoryActivity storyActivity = (UMLStoryActivity) source;
            storyActivity.setTextComment ("// <add comment>");
         }
         UMLProject.get().refreshDisplay();
      }
      finally
      {
      }
   } // actionPerformed

}

/*
 * $Log: AddActivityCommentAction.java,v $
 * Revision 1.9  2004/11/03 11:47:56  lowende
 * Javadoc warnings removed.
 *
 */
