/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;

import de.uni_paderborn.fujaba.basic.UniqueIdentifier;
import de.uni_paderborn.fujaba.fsa.unparse.LogicUnparseInterface;
import de.uni_paderborn.fujaba.metamodel.*;
import de.upb.tools.pcs.PropertyChangeClient;


/**
 * <h2>All associations</h2>
 *
 * <pre>
 *             +------+ 1                 1
 * UMLTypeList | name +--------------------- UMLType
 *             +------+ revTypes      types
 * </pre>
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.47 $
 */
public interface UMLType extends LogicUnparseInterface, PropertyChangeClient, UniqueIdentifier, FType
{
   /**
    * Get the progLangType attribute of the UMLType object
    *
    * @return   The progLangType value
    */
   public String getProgLangType();


   /**
    * Sets the progLangType attribute of the UMLType object
    *
    * @param progLangType  The new progLangType value
    */
   public void setProgLangType (String progLangType);

   // ######################################################################

   /**
    * Get the name attribute of the UMLType object
    *
    * @return   The name value
    */
   public String getName();


   /**
    * Sets the name attribute of the UMLType object
    *
    * @param name  The new name value
    */
   public void setName (String name);

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    * @return      No description provided
    */
   public boolean hasInRevResultType (FMethod elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevResultType();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevResultType();


   /**
    * Access method for an one to n association.
    *
    * @param elem  The object added.
    * @return      No description provided
    */
   public boolean addToRevResultType (FMethod elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    * @return      No description provided
    */
   public boolean removeFromRevResultType (FMethod elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevResultType();

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    * @return      No description provided
    */
   public boolean hasInRevParamType (FParam elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevParamType();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevParamType();


   /**
    * Access method for an one to n association.
    *
    * @param elem  The object added.
    * @return      No description provided
    */
   public boolean addToRevParamType (FParam elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    * @return      No description provided
    */
   public boolean removeFromRevParamType (FParam elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevParamType();

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    * @return      No description provided
    */
   public boolean hasInRevAttrType (FAttr elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevAttrType();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevAttrType();


   /**
    * Access method for an one to n association.
    *
    * @param elem  The object added.
    * @return      No description provided
    */
   public boolean addToRevAttrType (FAttr elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param elem  No description provided
    * @return      No description provided
    */
   public boolean removeFromRevAttrType (FAttr elem);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevAttrType();

   // ######################################################################

   /**
    * <pre>
    *             +------+ 1                 1
    * UMLTypeList | name +--------------------- UMLType
    *             +------+ revTypes      types
    * </pre>
    *
    * @param revTypes  The new revTypes value
    * @return          No description provided
    */
   public boolean setRevTypes (FTypeList revTypes);


   /**
    * Get the revTypes attribute of the UMLType object
    *
    * @return   The revTypes value
    */
   public UMLTypeList getRevTypes();


   /**
    * Get the revArrayType attribute of the UMLType object
    *
    * @return   The revArrayType value
    */
   public UMLArray getRevArrayType();


   /**
    * Sets the revArrayType attribute of the UMLType object
    *
    * @param revArrayType  The new revArrayType value
    */
   public void setRevArrayType (FArray revArrayType);

   // ######################################################################

   /**
    * Use this function to get the real type of the associatet UMLType.
    *
    * @return   the real UMLType, if the current object is a array this function returns the
    *      real UMLType of this array
    */
   public UMLType getRealType();


   /**
    * This function returns the dimension of the current type.
    *
    * @return   UMLClass and UMLBaseType returns 0 otherwise the dimenson of the array
    */
   public int getDimension();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevType (FQualifier value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevType();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevType();


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevType (FQualifier value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevType (FQualifier value);


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevType();
}

/*
 * $Log: UMLType.java,v $
 * Revision 1.47  2004/11/03 11:47:55  lowende
 * Javadoc warnings removed.
 *
 */
