/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.FElement;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.35.2.2 $
 */
public class UMLTransitionGuard extends UMLDiagramItem
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int NONE = 0;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int SUCCESS = 1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int FAILURE = 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int EVERYTIMES = 3; // FIX ME: rename it to EACH_TIME

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int TERMINATION = 4;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int ELSE = 5;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int BOOL = 6;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int EXCEPTION = 7;


   public static int getGuardType (UMLTransition transition)
   {
      final UMLTransitionGuard guard = transition.getGuard();
      return  (guard == null ? NONE : guard.getType());
   }


   /**
    * Constructor for class UMLTransitionGuard
    */
   public UMLTransitionGuard()
   {
      super();
   }


   /**
    * @param coobraPersistent
    */
   public UMLTransitionGuard (boolean coobraPersistent)
   {
      super (coobraPersistent);
   }


   /**
    * Constructor for class UMLTransitionGuard
    *
    * @param type      No description provided
    * @param boolExpr  No description provided
    * @param revGuard  No description provided
    */
   public UMLTransitionGuard (int type, String boolExpr, UMLTransition revGuard)
   {
      super();
      setType (type);

      setBoolExpr (boolExpr);
      setRevGuard (revGuard);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int type = NONE;


   /**
    * Get the type attribute of the UMLTransitionGuard object
    *
    * @return   The type value
    */
   public int getType()
   {
      return type;
   }


   /**
    * Sets the type attribute of the UMLTransitionGuard object
    *
    * @param type  The new type value
    */
   public void setType (int type)
   {
      if ( (NONE <= type && type <= EXCEPTION) &&
          (this.type != type))
      {
         int oldValue = this.type;
         this.type = type;
         firePropertyChange ("type", oldValue, type);
         firePropertyChange ("boolExpr", getBoolExpr (oldValue), getBoolExpr());
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String boolExpr = null;


   /**
    * Get the boolExpr attribute of the UMLTransitionGuard object
    *
    * @param type  No description provided
    * @return      The boolExpr value
    */
   public String getBoolExpr (int type)
   {
      String expr;
      switch (type)
      {
         case NONE:
            expr = null;
            break;
         case SUCCESS:
            expr = "success";
            break;
         case FAILURE:
            expr = "failure";
            break;
         case EVERYTIMES:
            expr = "each time";
            break;
         case TERMINATION:
            expr = "end";
            break;
         case ELSE:
            expr = "else";
            break;
         default:
            expr = this.boolExpr;
            break;
      }
      return expr;
   }


   /**
    * Get the boolExpr attribute of the UMLTransitionGuard object
    *
    * @return   The boolExpr value
    */
   public String getBoolExpr()
   {
      return getBoolExpr (getType());
   }


   /**
    * Sets the boolExpr attribute of the UMLTransitionGuard object
    *
    * @param boolExpr  The new boolExpr value
    */
   public void setBoolExpr (String boolExpr)
   {
      if ( (this.boolExpr == null && boolExpr != null) ||
          (this.boolExpr != null && !this.boolExpr.equals (boolExpr)))
      {
         String oldValue = this.boolExpr;
         this.boolExpr = boolExpr;
         firePropertyChange ("boolExpr", oldValue, boolExpr);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLTransition revGuard = null; // reverse UMLTransiton guard


   /**
    * Get the revGuard attribute of the UMLTransitionGuard object
    *
    * @return   The revGuard value
    */
   public UMLTransition getRevGuard()
   {
      return revGuard;
   }


   /**
    * Sets the revGuard attribute of the UMLTransitionGuard object
    *
    * @param revGuard  The new revGuard value
    */
   public void setRevGuard (UMLTransition revGuard)
   {
      if ( (this.revGuard == null && revGuard != null) ||
          (this.revGuard != null && !this.revGuard.equals (revGuard)))
      { // new partner

         UMLTransition oldRevGuard = this.revGuard;
         if (this.revGuard != null)
         { // revInform old partner

            this.revGuard = null;
            oldRevGuard.setGuard (null);
         }
         this.revGuard = revGuard;
         if (revGuard != null)
         { // revInform new partner

            revGuard.setGuard (this);
         }
         firePropertyChange ("revGuard", oldRevGuard, revGuard);
      }
   }


   /**
    * Same functionality as equals() there are maybe problems with jgl sets work if this method
    * is called equals()
    *
    * @param curTransitionGuard  No description provided
    * @return                    No description provided
    */
   public boolean looksLike (UMLTransitionGuard curTransitionGuard)
   {
      // only type is compared, boolean expresions may differ
      return  (this.getType() == curTransitionGuard.getType());
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      setRevGuard (null);

      super.removeYou();
   }


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element;
    */
   public FElement getParentElement()
   {
      return getRevGuard();
   }

}

/*
 * $Log: UMLTransitionGuard.java,v $
 * Revision 1.35.2.2  2006/06/07 09:13:32  creckord
 * - UMLTransitionGuard can be null instead of UMLTransitionGuard.NONE
 * - old "repair assoc" code removed (access methods are not kept, so repairing them is no longer needed)
 * - loop bends for assocs are removed when loop is removed
 *
 */
