/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;
import java.util.TreeSet;

import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.FElement;
import de.upb.tools.fca.*;


/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.159 $
 */
public class UMLStoryPattern extends UMLDiagram
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int STORYPATTERN = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int STORYBOARD = 1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int SHOWSTORYPATTERN = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int SHOWSEQUENCEBAR = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int SHOWBOTH = 2;

   // the values of the constants are the same for UMLObject and UMLLink
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int NONE = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DELETE = NONE + 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int CREATE = DELETE + 1;


   /**
    * Constructor for class UMLStoryPattern
    */
   public UMLStoryPattern()
   {
      super();
   } // UMLStoryPattern


   /**
    * Constructor for class UMLStoryPattern
    *
    * @param name          No description provided
    * @param project       No description provided
    * @param type          No description provided
    * @param revStoryDiag  No description provided
    */
   public UMLStoryPattern (String name, UMLProject project,
                           int type, UMLStoryActivity revStoryDiag)
   {
      super (name, project);
      setType (type);
      setRevStoryPattern (revStoryDiag);
   } // UMLStoryPattern


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int type = 0;


   /**
    * Get the type attribute of the UMLStoryPattern object
    *
    * @return   The type value
    */
   public int getType()
   {
      return type;
   } // getType


   /**
    * Sets the type attribute of the UMLStoryPattern object
    *
    * @param type  The new type value
    */
   public void setType (int type)
   {
      if (STORYPATTERN <= type && type <= STORYBOARD)
      {
         int oldValue = this.type;
         this.type = type;
         firePropertyChange ("type", oldValue, type);
      }
   } // setType


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLStoryActivity revStoryPattern;


   /**
    * Get the revStoryPattern attribute of the UMLStoryPattern object
    *
    * @return   The revStoryPattern value
    */
   public UMLStoryActivity getRevStoryPattern()
   {
      return revStoryPattern;
   } // getRevStoryPattern


   /**
    * Sets the revStoryPattern attribute of the UMLStoryPattern object
    *
    * @param revStoryPattern  The new revStoryPattern value
    */
   public void setRevStoryPattern (UMLStoryActivity revStoryPattern)
   {
      if (this.revStoryPattern != revStoryPattern)
      {
         // new partner
         UMLStoryActivity oldRevStoryPattern = this.revStoryPattern;
         if (this.revStoryPattern != null)
         {
            // inform old partner
            this.revStoryPattern = null;
            oldRevStoryPattern.setStoryPattern (null);
         }
         this.revStoryPattern = revStoryPattern;
         if (revStoryPattern != null)
         {
            // inform new partner
            revStoryPattern.setStoryPattern (this);
         }

         firePropertyChange ("revStoryPattern", oldRevStoryPattern, revStoryPattern);
      }
   } // setRevStoryPattern


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfObjects()
   {
      TreeSet objects = new TreeSet();
      Iterator iter = iteratorOfElements();
      while (iter.hasNext())
      {
         ASGElement tmpElement = (ASGElement) iter.next();
         if (tmpElement instanceof UMLObject)
         {
            objects.add (tmpElement);
         }
      }

      return  ( (objects.size() == 0)
         ? FEmptyIterator.get()
         : objects.iterator());
   } // elementsOfObjects


   /**
    * Access method for an one to n association.
    *
    * @param object  The object added.
    */
   public void addToVariables (UMLObject object)
   {
      UMLActivityDiagram activityDiagram = getRevStoryPattern().getActivityDiagram();
      if (activityDiagram != null)
      {
         // this storyPattern is in a normal Activity Diagram
         // Won't be needed any more
      }
      else
      {
         // this storyPattern is in a stateChart
         getRevStoryPattern().getRevStory().addToDeclaredVariables (object);
      }
   }


   /**
    * Check if the may clauses include the objects passed as parameter
    *
    * @param nameO1  No description provided
    * @param nameO2  No description provided
    * @return        No description provided
    */
   private boolean mustGenerateIsomorphicBinding (String nameO1, String nameO2)
   {
      // just look if there are any maybe constraints
      if (mayBeConstraints == null)
      {
         return true;
      }

      String posibility1 = nameO1 + "==" + nameO2;
      String posibility2 = nameO2 + "==" + nameO1;

      return  (mayBeConstraints.indexOf (posibility1) == -1 &&
         mayBeConstraints.indexOf (posibility2) == -1);
   } // mustGenerateIsomorphicBinding


   /**
    * Check if there must be generated any isomorphic binding condition
    *
    * @param objectName  No description provided
    * @param container   No description provided
    * @return            No description provided
    */
   public FTreeSet filterIsomorphicBindings (String objectName, FTreeSet container)
   {
      FTreeSet bindings = new FTreeSet();

      // just look if there are any maybe constraints
      if (mayBeConstraints != null)
      {
         Iterator iter = container.iterator();
         UMLObject tmpObject;
         while (iter.hasNext())
         {
            tmpObject = (UMLObject) iter.next();

            if (mustGenerateIsomorphicBinding (objectName, tmpObject.getObjectName()))
            {
               bindings.add (tmpObject);
            }
         }
      }
      else
      {
         bindings = container;
      }

      return bindings;
   } // filterIsomorphicBindings


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient String mayBeConstraints = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int showType = SHOWSTORYPATTERN;


   /**
    * Sets the showType attribute of the UMLStoryPattern object
    *
    * @param showType  The new showType value
    */
   public void setShowType (int showType)
   {
      int oldValue = this.showType;
      this.showType = showType;
      firePropertyChange ("showType", oldValue, showType);
   }


   /**
    * Get the showType attribute of the UMLStoryPattern object
    *
    * @return   The showType value
    */
   public int getShowType()
   {
      return this.showType;
   }


   /**
    * Get the value of mayBeConstraints.
    *
    * @return   Value of mayBeConstraints.
    */
   public String getMayBeConstraints()
   {
      return this.mayBeConstraints;
   }


   /**
    * Set the value of mayBeConstraints.
    *
    * @param mayBeConstraints  Value to assign to mayBeConstraints.
    */
   public void setMayBeConstraints (String mayBeConstraints)
   {
      if (this.mayBeConstraints != mayBeConstraints)
      {
         this.mayBeConstraints = mayBeConstraints;
      }
   }


   /**
    * <pre>
    *            0..1     storyPattern     0..1
    * UMLAction -------------------------------- UMLStoryPattern
    *            uMLAction      uMLStoryPattern
    * </pre>
    */
   private UMLAction uMLAction;


   /**
    * UMLMethod: '+ setUMLAction (value: UMLAction): Boolean'.
    *
    * @param value  The new uMLAction value
    * @return       No description provided
    */
   public boolean setUMLAction (UMLAction value)
   {
      boolean changed = false;
      if (this.uMLAction != value)
      {
         if (this.uMLAction != null)
         {
            UMLAction oldValue = this.uMLAction;
            this.uMLAction = null;
            oldValue.setUMLStoryPattern (null);
         }
         this.uMLAction = value;
         if (value != null)
         {
            value.setUMLStoryPattern (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * UMLMethod: '+ getUMLAction (): UMLAction'.
    *
    * @return   The uMLAction value
    */
   public UMLAction getUMLAction()
   {
      return this.uMLAction;
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      TreeSet itemsContainer = new TreeSet();

      Iterator iter = iteratorOfElements();
      while (iter.hasNext())
      {
         ASGElement tmpElement = (ASGElement) iter.next();
         if (tmpElement instanceof UMLDiagramItem)
         {
            UMLDiagramItem tmpDiagramItem = (UMLDiagramItem) tmpElement;
            removeFromElementsWithSideEffects (tmpDiagramItem);
            itemsContainer.add (tmpDiagramItem);
         }
      }

      iter = itemsContainer.iterator();
      while (iter.hasNext())
      {
         ASGElement tmpElement = (ASGElement) iter.next();
         tmpElement.removeYou();
      }

      UMLIncrement incr = getRevStoryPattern();
      if (incr != null)
      {
         setRevStoryPattern (null);
         incr.removeYou();
      }

      UMLAction tmpUMLAction = getUMLAction();
      if (tmpUMLAction != null)
      {
         setUMLAction (null);
      } // if

      super.removeYou();
   } // removeYou


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element;
    */
   public FElement getParentElement()
   {
      return getRevStoryPattern();
   }


   /**
    * <pre>
    *                  1   masterCollabStat   1
    * UMLStoryPattern -------------------------- UMLCollabStat
    *                  + myPattern           +
    * </pre>
    */
   private transient UMLCollabStat revMasterCollabStat; // reverse attribute myPattern


   /**
    * Get the revMasterCollabStat attribute of the UMLStoryPattern object
    *
    * @return   The revMasterCollabStat value
    */
   public UMLCollabStat getRevMasterCollabStat()
   {
      return revMasterCollabStat;
   } // getRevMasterCollabStat


   /**
    * Sets the revMasterCollabStat attribute of the UMLStoryPattern object
    *
    * @param revMasterCollabStat  The new revMasterCollabStat value
    */
   public void setRevMasterCollabStat (UMLCollabStat revMasterCollabStat)
   {
      if (this.revMasterCollabStat != revMasterCollabStat)
      {
         // newPartner
         UMLCollabStat oldRevMasterCollabStat = this.revMasterCollabStat;
         if (this.revMasterCollabStat != null)
         {
            // inform old partner
            this.revMasterCollabStat = null;

            oldRevMasterCollabStat.setMyPattern (null);
         }
         this.revMasterCollabStat = revMasterCollabStat;
         if (revMasterCollabStat != null)
         {
            // inform new partner
            revMasterCollabStat.setMyPattern (this);
         }

         firePropertyChange ("revMasterCollabStat", oldRevMasterCollabStat, revMasterCollabStat);
      }
   } // setRevMasterCollabStat


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void renumberCollabStats()
   {
      UMLCollabStat masterCollabStat = this.getRevMasterCollabStat();

      if (masterCollabStat == null)
      {
         masterCollabStat = new UMLCollabStat();
         this.setRevMasterCollabStat (masterCollabStat);
      }

      masterCollabStat.renumberCollabStats();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      StringBuffer name = new StringBuffer ("StoryPattern");
      if (getName() != null)
      {
         name.append (" " + getName());
      }

      if (getRevStoryPattern() != null && getRevStoryPattern().getName() != null)
      {
         name.append (" in Activity " + getRevStoryPattern().getName());
      }

      return name.toString();
   }


   // recursive search, when found succesor connect it to the paramameter multiLink
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param multiLink  No description provided
    * @param queue      No description provided
    */
   private void searchNextMultiLink (UMLMultiLink multiLink, FQueue queue)
   {
      boolean found = false;
      UMLMultiLink nextMultiLink;

      for (int j = 0; j < queue.size() && !found; j++)
      {

         nextMultiLink = (UMLMultiLink) queue.get();

         if (multiLink.getTargetObject() == nextMultiLink.getSourceObject())
         {
            found = true;
            // connect the two MultiLinks
            multiLink.setNextMultiLink (nextMultiLink);
            nextMultiLink.setPreviousMultiLink (multiLink);
            this.searchNextMultiLink (nextMultiLink, queue);
         }
         else
         {
            queue.put (nextMultiLink);
         }
      }
   }


   // connect the Multilinks
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param queue  No description provided
    */
   public void connectMultiLinks (FQueue queue)
   {
      UMLMultiLink currentMultiLink;
      for (int j = 0; j < queue.size(); j++)
      {
         currentMultiLink = (UMLMultiLink) queue.get();
         this.searchNextMultiLink (currentMultiLink, queue);
         queue.put (currentMultiLink);
      }
   }

}

/*
 * $Log: UMLStoryPattern.java,v $
 * Revision 1.159  2005/02/14 14:28:21  cschneid
 * introduced message view, getParentElement() for FElement, code generation and compiler messages in message view
 *
 */
