/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.50.2.1 $
 */
public class UMLStopActivity extends UMLActivity
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (UMLStopActivity.class);


   /**
    * Constructor for class UMLStopActivity
    */
   public UMLStopActivity()
   {
      super();
   }


   /**
    * Constructor for class UMLStopActivity
    *
    * @param generateCode  No description provided
    */
   public UMLStopActivity (boolean generateCode)
   {
      super();
      setGenerateCode (generateCode);
   }


   /**
    * Constructor for class UMLStopActivity
    *
    * @param coobraPersistent  No description provided
    * @param generateCode      No description provided
    */
   public UMLStopActivity (boolean coobraPersistent, boolean generateCode)
   {
      super (coobraPersistent);
      setGenerateCode (generateCode);
   }


   /**
    * Constructor for class UMLStopActivity
    *
    * @param returnParam  No description provided
    */
   public UMLStopActivity (UMLObject returnParam)
   {
      super();
      setReturnParam (returnParam);
   }


   /**
    * Constructor for class UMLStopActivity
    *
    * @param generateCode  No description provided
    * @param value         No description provided
    */
   public UMLStopActivity (boolean generateCode, String value)
   {
      super();
      setGenerateCode (generateCode);
      setReturnValue (value);
   }


   /**
    * Sets the exit attribute of the UMLStopActivity object
    *
    * @param elem  The new exit value
    */
   public void setExit (UMLTransition elem)
   {
      throw new RuntimeExceptionWithContext ("A stop activity must not have any exit transitions", this);
   }


   /**
    * Get the name attribute of the UMLStopActivity object
    *
    * @return   The name value
    */
   public String getName()
   {
      return "stop";
   }


   /*
    *  flag if this activity should produce source code or not
    *  in some cases a stop activity is needed in the diagram, but not in the source code
    */
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean generateCode = false;


   /**
    * Get the generateCode attribute of the UMLStopActivity object
    *
    * @return   The generateCode value
    */
   public boolean isGenerateCode()
   {
      return generateCode;
   }


   /**
    * Sets the generateCode attribute of the UMLStopActivity object
    *
    * @param generateCode  The new generateCode value
    */
   public void setGenerateCode (boolean generateCode)
   {
      if (this.generateCode != generateCode)
      {
         boolean oldValue = this.generateCode;
         this.generateCode = generateCode;
         firePropertyChange ("generateCode", oldValue, generateCode);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String returnValue = null;


   /**
    * Get the returnValue attribute of the UMLStopActivity object
    *
    * @return   The returnValue value
    */
   public String getReturnValue()
   {
      return this.returnValue;
   }


   /**
    * Sets the returnValue attribute of the UMLStopActivity object
    *
    * @param value  The new returnValue value
    */
   public void setReturnValue (String value)
   {
      if ( (this.returnValue == null && value != null) ||
          (this.returnValue != null && !this.returnValue.equals (value)))
      {
         String oldValue = this.returnValue;
         this.returnValue = value;
         firePropertyChange ("returnValue", oldValue, value);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @deprecated   returnValue is used always now
    */
   private UMLObject returnParam; // reverse UMLStopActivity revReturnParam


   /**
    * Get the returnParam attribute of the UMLStopActivity object
    *
    * @return       The returnParam value
    * @deprecated   returnValue is used always now
    */
   public UMLObject getReturnParam()
   {
      return returnParam;
   }


   /**
    * Sets the returnParam attribute of the UMLStopActivity object
    *
    * @param returnParam  The new returnParam value
    * @deprecated         returnValue is used always now
    */
   public void setReturnParam (UMLObject returnParam)
   {
      if ( (this.returnParam == null && returnParam != null) ||
          (this.returnParam != null && !this.returnParam.equals (returnParam)))
      { // new partner

         UMLObject oldReturnParam = this.returnParam;
         if (this.returnParam != null)
         { // inform old partner

            this.returnParam = null;
            oldReturnParam.setRevReturnParam (null);
         }
         this.returnParam = returnParam;
         if (returnParam != null)
         { // inform new partner
            setReturnValue (returnParam.getText());
            returnParam.setRevReturnParam (this);
         }
         firePropertyChange ("returnParam", oldReturnParam, returnParam);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public boolean returnsVariable()
   {
      boolean returnsVariable = true;
      UMLDiagram diag = getFirstFromDiagrams();
      if (diag != null && diag instanceof UMLActivityDiagram)
      {
         UMLStartActivity startActivity =
             ((UMLActivityDiagram) diag).getStartActivity();
         if (startActivity != null)
         {
            UMLMethod methodDecl = startActivity.getSpec();
            if (methodDecl == null)
            { // maybe its start of statechart

               returnsVariable = false;
            }
            else
            {
               if ( (methodDecl.getResultType() != null) &&
                   ( (methodDecl.getResultType().getName().equals (UMLBaseTypes.VOID)) ||
                   (methodDecl.getResultType().getName().equals (UMLBaseTypes.CONSTRUCTOR))))
               {
                  returnsVariable = false;
               }
            }
         }
      }
      else
      {
         if (log.isInfoEnabled())
         {
            log.info ("Error in UMLStopActivity: getFirstFromDiagrams() does not return an UMLActivityDiagram");
         }
         returnsVariable = false;
      }
      return returnsVariable;
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      UMLIncrement incr;

      incr = getReturnParam();
      if (incr != null)
      {
         setReturnParam (null);
         incr.removeYou();
      }

      super.removeYou();
   }


   /**
    * Get the text attribute of the UMLStopActivity object
    *
    * @return   The text value
    */
   public String getText()
   {
      return "STOP";
   }

}

/*
 * $Log: UMLStopActivity.java,v $
 * Revision 1.50.2.1  2005/09/30 18:56:59  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
