/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.17 $
 */
public class UMLStatechart extends UMLActivityDiagram
{
   /**
    * Constructor for class UMLStatechart
    */
   public UMLStatechart()
   {
      super();
   }


   /**
    * Constructor for class UMLStatechart
    *
    * @param name     No description provided
    * @param project  No description provided
    */
   public UMLStatechart (String name, UMLProject project)
   {
      super (name, project);
   }


   /**
    * Get the statechart attribute of the UMLStatechart object
    *
    * @return   The statechart value
    */
   public final boolean isStatechart()
   {
      return true;
   }


   /**
    * Return the initial state of this statechart.
    *
    * @return   The initialState value
    */
   public UMLComplexState getInitialState()
   {
      UMLComplexState result = null;
      UMLStartActivity start = getStartActivity();
      if (start != null)
      {
         Iterator iter = start.iteratorOfExit();
         if (iter.hasNext())
         {
            result = (UMLComplexState) iter.next();
         }
      }
      return result;
   }


   /**
    * getter for field spawnOwnThread
    *
    * @return   current value of field spawnOwnThread
    */
   public boolean isSpawningOwnThread()
   {
      return this.spawningOwnThread;
   }


   /**
    * store the value for field spawnOwnThread
    */
   private boolean spawningOwnThread = true;


   /**
    * setter for field spawnOwnThread
    *
    * @param value  new value
    */
   public void setSpawningOwnThread (final boolean value)
   {
      final boolean oldValue = this.spawningOwnThread;
      if (oldValue != value)
      {
         this.spawningOwnThread = value;
         firePropertyChange ("spawningOwnThread", oldValue, value);
      }
   }
}

/*
 * $Log: UMLStatechart.java,v $
 * Revision 1.17  2005/01/27 15:44:49  cschneid
 * bugfixes, new libraries, SDMObjectDialog improved, add activity in transition
 *
 */
