/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FHashSet;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: l3_g5 $
 * @version   $Revision: 1.166.2.2 $
 */
public class UMLRole extends UMLIncrement implements FRole
{
   /**
    * @deprecated
    */
   public final static int ADD_METHOD = 0;
   /**
    * @deprecated
    */
   public final static int REMOVE_METHOD = 1;


   /**
    * Constructor for class UMLRole
    */
   public UMLRole()
   {
      super();
   }


   /**
    * Constructor for class UMLRole
    *
    * @param name        No description provided
    * @param target      No description provided
    * @param cardString  No description provided
    */
   public UMLRole (String name, UMLClass target, String cardString)
   {
      this (name, NONE, target, null,
         new UMLCardinality (cardString), FDeclaration.PUBLIC, null, null);
   }


   /**
    * Constructor for class UMLRole
    *
    * @param name          No description provided
    * @param adornment     No description provided
    * @param target        No description provided
    * @param qualifier     No description provided
    * @param card          No description provided
    * @param visibility    No description provided
    * @param revLeftRole   No description provided
    * @param revRightRole  No description provided
    */
   public UMLRole (String name, int adornment, UMLClass target,
                   UMLQualifier qualifier, UMLCardinality card, int visibility,
                   UMLAssoc revLeftRole, UMLAssoc revRightRole)
   {
      super();
      setName (name);
      setAdornment (adornment);
      setTarget (target);
      setQualifier (qualifier);
      setCard (card);
      setUmlVisibility (visibility);
      setRevLeftRole (revLeftRole);
      setRevRightRole (revRightRole);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected String createUnparseModuleName()
   {
      return UMLUnparseGetter.getUnparseModuleName (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name;


   /**
    * Get the name attribute of the UMLRole object
    *
    * @return   The name value
    */
   public String getName()
   {
      return name;
   }


   /**
    * Sets the name attribute of the UMLRole object
    *
    * @param name  The new name value
    */
   public void setName (String name)
   {
      String oldValue = this.name;
      this.name = name;
      firePropertyChange (NAME_PROPERTY, oldValue, name);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int umlVisibility = FDeclaration.PUBLIC;


   /**
    * Get the umlVisibility attribute of the UMLRole object
    *
    * @return   The umlVisibility value
    */
   public int getUmlVisibility()
   {
      return this.umlVisibility;
   } // getUmlVisibility


   /**
    * Sets the umlVisibility attribute of the UMLRole object
    *
    * @param newUmlVisibility  The new umlVisibility value
    */
   public void setUmlVisibility (int newUmlVisibility)
   {
      int oldValue = this.umlVisibility;
      this.umlVisibility = newUmlVisibility;

      firePropertyChange ("umlVisibility", oldValue, newUmlVisibility);
   } // setUmlVisibility


   /**
    * Value is one of {None, Aggregation, Composition, Reference, Qualified}
    *
    * @see   #NONE
    * @see   #AGGREGATION
    * @see   #COMPOSITION
    * @see   #REFERENCE
    * @see   #QUALIFIED
    */
   private int adornment;


   /**
    * Get the adornment attribute of the UMLRole object, one of {None, Aggregation, Composition,
    * Reference, Qualified}
    *
    * @return   The adornment value
    * @see      #NONE
    * @see      #AGGREGATION
    * @see      #COMPOSITION
    * @see      #REFERENCE
    * @see      #QUALIFIED
    */
   public int getAdornment()
   {
      return adornment;
   }


   /**
    * Sets the adornment attribute of the UMLRole object, one of {None, Aggregation, Composition,
    * Reference, Qualified}
    *
    * @param adornment  The new adornment value
    * @see              #NONE
    * @see              #AGGREGATION
    * @see              #COMPOSITION
    * @see              #REFERENCE
    * @see              #QUALIFIED
    */
   public void setAdornment (int adornment)
   {
      int oldValue = this.adornment;
      this.adornment = adornment;
      firePropertyChange (ADORNMENT_PROPERTY, oldValue, adornment);
   }


   /**
    * Indicates if the role was generated from parsed source code.
    * If it is true, there will be no code generated for the role,
    * since access methods already exist in the parsed code.
    */
   private boolean parsed = false;


   /**
    * Indicate that the role was generated from parsed source code.
    * If it is set to true, there will be no code generated for the role,
    * since access methods already exist in the parsed code.
    *
    * @param parsed  true, if the role was generated from parsed source code
    */
   public void setParsed (boolean parsed)
   {
      if (this.parsed != parsed)
      {
         this.parsed = parsed;
         firePropertyChange ("parsed", !parsed, parsed);
      }
   }


   /**
    * Indicates if the role was generated from parsed source code.
    * If it is true, there will be no code generated for the role,
    * since access methods already exist in the parsed code.
    *
    * @return   true, if the role was generated from parsed source code
    */
   public boolean isParsed()
   {
      return this.parsed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient UMLClass target;

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the target attribute of the UMLRole object
    *
    * @return   The target value
    */
   public UMLClass getTarget()
   {
      return target;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FRole#getFTarget()
    */
   /**
    * Get the fTarget attribute of the UMLRole object
    *
    * @return   The fTarget value
    */
   public FClass getFTarget()
   {
      return getTarget();
   }
   // TODO-END

   /**
    * Sets the target attribute of the UMLRole object
    *
    * @param target  The new target value
    */
   public void setTarget (FClass target)
   {
      if (this.target != target)
      { // new partner

         UMLClass oldTarget = this.target;
         if (this.target != null)
         { // inform old partner

            this.target = null;
            oldTarget.removeFromRoles (this);
         }
         this.target = (UMLClass) target;
         if (target != null)
         { // inform new partner

            target.addToRoles (this);
         }
         firePropertyChange (TARGET_PROPERTY, oldTarget, target);
      }
   }


   /**
    * Sets the revRoles attribute of the UMLRole object
    *
    * @param target  The new revRoles value
    */
   public void setRevRoles (FClass target)
   {
      setTarget (target);
   }

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the revRoles attribute of the UMLRole object
    *
    * @return   The revRoles value
    */
   public UMLClass getRevRoles()
   {
      return getTarget();
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FRole#getFRevRoles()
    */
   /**
    * Get the fRevRoles attribute of the UMLRole object
    *
    * @return   The fRevRoles value
    */
   public FClass getFRevRoles()
   {
      return getRevRoles();
   }
   // TODO-END

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final void removeTarget()
   {
      this.setTarget (null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLAssoc revLeftRole = null; // reverse UMLRole leftRole


   /**
    * Get the revLeftRole attribute of the UMLRole object
    *
    * @return   The revLeftRole value
    */
   public UMLAssoc getRevLeftRole()
   {
      return revLeftRole;
   }


   /**
    * Sets the revLeftRole attribute of the UMLRole object
    *
    * @param revLeftRole  The new revLeftRole value
    */
   public void setRevLeftRole (FAssoc revLeftRole)
   {
      if ( (this.revLeftRole == null && revLeftRole != null) ||
          (this.revLeftRole != null && !this.revLeftRole.equals (revLeftRole)))
      { // new partner

         UMLAssoc oldRevLeftRole = this.revLeftRole;
         if (this.revLeftRole != null)
         { // inform old partner

            this.revLeftRole = null;
            oldRevLeftRole.setLeftRole (null);
         }
         this.revLeftRole = (UMLAssoc) revLeftRole;
         if (this.revLeftRole != null)
         { // inform new partner

            this.revLeftRole.setLeftRole (this);
         }
         firePropertyChange ("revLeftRole", oldRevLeftRole, revLeftRole);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final void removeRevLeftRole()
   {
      UMLAssoc incr = this.revLeftRole;
      if (incr != null)
      {
         this.setRevLeftRole (null);
         incr.removeYou();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLAssoc revRightRole = null; // reverse UMLRole rightRole


   /**
    * Get the revRightRole attribute of the UMLRole object
    *
    * @return   The revRightRole value
    */
   public UMLAssoc getRevRightRole()
   {
      return revRightRole;
   }


   /**
    * Sets the revRightRole attribute of the UMLRole object
    *
    * @param revRightRole  The new revRightRole value
    */
   public void setRevRightRole (FAssoc revRightRole)
   {
      if ( (this.revRightRole == null && revRightRole != null) ||
          (this.revRightRole != null && !this.revRightRole.equals (revRightRole)))
      {
         // new partner
         UMLAssoc oldRevRightRole = this.revRightRole;
         if (this.revRightRole != null)
         {
            // inform old partner
            this.revRightRole = null;
            oldRevRightRole.setRightRole (null);
         }
         this.revRightRole = (UMLAssoc) revRightRole;
         if (this.revRightRole != null)
         {
            // inform new partner
            this.revRightRole.setRightRole (this);
         }
         firePropertyChange ("revRightRole", oldRevRightRole, revRightRole);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final void removeRevRightRole()
   {
      UMLAssoc incr = this.revRightRole;
      if (incr != null)
      {
         this.setRevRightRole (null);
         incr.removeYou();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLCardinality card = null; // reverse UMLRole revCard


   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the card attribute of the UMLRole object
    *
    * @return   The card value
    */
   public UMLCardinality getCard()
   {
      return card;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FRole#getFCard()
    */
   /**
    * Get the fCard attribute of the UMLRole object
    *
    * @return   The fCard value
    */
   public FCardinality getFCard()
   {
      return getCard();
   }
   // TODO-END

   /**
    * Sets the card attribute of the UMLRole object
    *
    * @param card  The new card value
    */
   public void setCard (FCardinality card)
   {
      if ( (this.card == null && card != null) ||
          (this.card != null && !this.card.equals (card)))
      { // new partner

         UMLCardinality oldCard = this.card;
         if (this.card != null)
         { // inform old partner

            this.card = null;
            oldCard.setRevCard (null);
         }
         this.card = (UMLCardinality) card;
         if (this.card != null)
         { // inform new partner

            this.card.setRevCard (this);
         }
         firePropertyChange (CARD_PROPERTY, oldCard, card);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final void removeCard()
   {
      UMLCardinality incr = getCard();
      if (incr != null)
      {
         this.setCard (null);
         incr.removeYou();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLQualifier qualifier = null; // reverse UMLRole revQualifier

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the qualifier attribute of the UMLRole object
    *
    * @return   The qualifier value
    */
   public UMLQualifier getQualifier()
   {
      return qualifier;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FRole#getFQualifier()
    */
   /**
    * Get the fQualifier attribute of the UMLRole object
    *
    * @return   The fQualifier value
    */
   public FQualifier getFQualifier()
   {
      return getQualifier();
   }
   // TODO-END

   /**
    * Sets the qualifier attribute of the UMLRole object
    *
    * @param qualifier  The new qualifier value
    */
   public void setQualifier (FQualifier qualifier)
   {
      if ( (this.qualifier == null && qualifier != null) ||
          (this.qualifier != null && !this.qualifier.equals (qualifier)))
      { // new partner

         UMLQualifier oldQualifier = this.qualifier;
         if (this.qualifier != null)
         { // inform old partner

            this.qualifier = null;
            oldQualifier.setRevQualifier (null);
         }
         this.qualifier = (UMLQualifier) qualifier;
         if (this.qualifier != null)
         { // inform new partner

            this.qualifier.setRevQualifier (this);
         }
         firePropertyChange (QUALIFIER_PROPERTY, oldQualifier, qualifier);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final void removeQualifier()
   {
      UMLQualifier incr = getQualifier();
      if (incr != null)
      {
         this.setQualifier (null);
         incr.removeYou();
      }
   }


   /**
    * <pre>
    *               n        qualifiedRole         0..1
    * UMLQualifier ------------------------------------- UMLRole
    *               revQualifiedRole      qualifiedRole
    * </pre>
    */
   private transient FHashSet revQualifiedRole;


   /**
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevQualifiedRole (FQualifier value)
   {
      return  ( (this.revQualifiedRole != null) &&
          (value != null) &&
         this.revQualifiedRole.contains (value));
   }


   /**
    * @return   No description provided
    */
   public Iterator iteratorOfRevQualifiedRole()
   {
      return  ( (this.revQualifiedRole == null)
         ? FEmptyIterator.get()
         : this.revQualifiedRole.iterator());
   }


   /**
    * @return   No description provided
    */
   public int sizeOfRevQualifiedRole()
   {
      return  ( (this.revQualifiedRole == null)
         ? 0
         : this.revQualifiedRole.size());
   }


   /**
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevQualifiedRole (FQualifier value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.revQualifiedRole == null)
         {
            this.revQualifiedRole = new FHashSet();

         }
         changed = this.revQualifiedRole.add (value);
         if (changed)
         {
             ((UMLQualifier) value).setQualifiedRole (this);
         }
      }
      return changed;
   }


   /**
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevQualifiedRole (FQualifier value)
   {
      boolean changed = false;
      if ( (this.revQualifiedRole != null) &&  (value != null))
      {
         changed = this.revQualifiedRole.remove (value);
         if (changed)
         {
             ((UMLQualifier) value).setQualifiedRole (null);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevQualifiedRole()
   {
      UMLQualifier tmpValue;
      Iterator iter = this.iteratorOfRevQualifiedRole();
      while (iter.hasNext())
      {
         tmpValue = (UMLQualifier) iter.next();
         this.removeFromRevQualifiedRole (tmpValue);
      }

   }

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the assoc attribute of the UMLRole object
    *
    * @return   The assoc value
    */
   public UMLAssoc getAssoc()
   {
      return  ( (revLeftRole != null)
         ? revLeftRole
         : revRightRole);
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FRole#getFAssoc()
    */
   /**
    * Get the fAssoc attribute of the UMLRole object
    *
    * @return   The fAssoc value
    */
   public FAssoc getFAssoc()
   {
      return getAssoc();
   }
   // TODO-END

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the partnerRole attribute of the UMLRole object
    *
    * @return   The partnerRole value
    */
   public UMLRole getPartnerRole()
   {
      UMLAssoc assoc = getAssoc();
      if (assoc != null)
      {
         return  ( (assoc.getLeftRole() != this)
            ? assoc.getLeftRole()
            : assoc.getRightRole());
      }
      else
      {
         return null;
      }
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FRole#getFPartnerRole()
    */
   /**
    * Get the fPartnerRole attribute of the UMLRole object
    *
    * @return   The fPartnerRole value
    */
   public FRole getFPartnerRole()
   {
      return getPartnerRole();
   }
   // TODO-END

   /**
    * Returns an attribute name which represents this role. If this role has already a name,
    * this name will be returned. If this role does not have a name but has a target class,
    * a default name will be created. If this role does not have a name and no target class,
    * the return value is null.
    *
    * @return   The attribute name as a string.
    */
   public String getAttrName()
   {
      String name = getName();
      if ( (name == null) &&  (this.getTarget() != null))
      {
         // Create a default role name.
         name = this.getTarget().getRealType().getName();

         //if ( (this.getCard() != null) &&  (this.getCard().getUpperBound() != 1))
         //{
         // It is a to many association.
         // name = name + "s";
         // allready done in the SourceCodeFactory
         //}

         name = ""; // coobra sometimes restores "" to null
         // String.valueOf (name.charAt (0)).toLowerCase() + name.substring (1, name.length());
         // Set the role name.
         //Why?! Bad things happened here!
         //  this.setName (name);
      }

      return name;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String sortedComparator;


   /**
    * Get the sortedComparator attribute of the UMLAssoc object
    *
    * @return   The sortedComparator value
    */
   public String getSortedComparator()
   {
      return sortedComparator;
   }


   /**
    * Sets the sortedComparator attribute of the UMLAssoc object
    *
    * @param comparator  The new sortedComparator value
    */
   public void setSortedComparator (String comparator)
   {
      if ( (this.sortedComparator == null) || !this.sortedComparator.equals (comparator))
      {
         String oldValue = this.sortedComparator;
         this.sortedComparator = comparator;
         firePropertyChange ("sortedComparator", oldValue, comparator);
      }
   }
   // ######################################################################

   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      this.removeTarget();
      this.removeRevLeftRole();
      this.removeRevRightRole();
      this.removeCard();
      this.removeQualifier();

      UMLAttr tmpAssociatedAttribute = getAssociatedAttribute();
      if (tmpAssociatedAttribute != null)
      {
         setAssociatedAttribute (null);
         tmpAssociatedAttribute.removeYou();
      } // if
      super.removeYou();
   }


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element, may not return null unless this is the top level node (project)
    */
   public FElement getParentElement()
   {
      if (getRevLeftRole() != null)
      {
         return getRevLeftRole();
      }
      else if (getRevRightRole() != null)
      {
         return getRevRightRole();
      }
      else
      {
         return null;
      }
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLRole[id=" + getID() + ",name=" + getName() + ",target=" + getTarget() + "]";
   }


   /**
    * <pre>
    *          0..1                                      0..1
    * UMLAttr ------------------------------------------------ UMLRole
    *          associatedAttribute      implementingAssocRole
    * </pre>
    */
   private UMLAttr associatedAttribute;


   /**
    * UMLMethod: '+ setAssociatedAttribute (value: UMLAttr): Boolean'.
    *
    * @param value  The new associatedAttribute value
    * @return       No description provided
    */
   public boolean setAssociatedAttribute (UMLAttr value)
   {
      boolean changed = false;

      if (this.associatedAttribute != value)
      {
         if (this.associatedAttribute != null)
         {
            UMLAttr oldValue = this.associatedAttribute;
            this.associatedAttribute = null;
            oldValue.setImplementingAssocRole (null);
         }

         this.associatedAttribute = value;

         if (value != null)
         {
            value.setImplementingAssocRole (this);
         }

         changed = true;
      }

      return changed;
   }

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * UMLMethod: '+ getAssociatedAttribute (): UMLAttr'.
    *
    * @return   The associatedAttribute value
    */
   public UMLAttr getAssociatedAttribute()
   {
      return this.associatedAttribute;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FRole#getFAssociatedAttribute()
    */
   /**
    * Get the fAssociatedAttribute attribute of the UMLRole object
    *
    * @return   The fAssociatedAttribute value
    */
   public FAttr getFAssociatedAttribute()
   {
      return getAssociatedAttribute();
   }
   // TODO-END

}

/*
 * $Log: UMLRole.java,v $
 * Revision 1.166.2.2  2005/06/07 18:19:52  l3_g5
 * bugfixes in codegen
 *
 */
