/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: joerg $
 * @version   $Revision: 1.54.2.2 $
 */
public class UMLQualifier extends UMLIncrement implements FQualifier
{

   /**
    * Constructor for class UMLQualifier
    */
   public UMLQualifier()
   {
      super();
   }


   /**
    * Constructor for class UMLQualifier
    *
    * @param name           No description provided
    * @param type           No description provided
    * @param revQualifier   No description provided
    * @param qualifiedAttr  No description provided
    */
   public UMLQualifier (String name, String type, UMLRole revQualifier, UMLAttr qualifiedAttr)
   {
      this (name, UMLProject.get().getFromBaseTypes (type),
         revQualifier, qualifiedAttr);
   }


   /**
    * Constructor for class UMLQualifier
    *
    * @param name           No description provided
    * @param type           No description provided
    * @param revQualifier   No description provided
    * @param qualifiedAttr  No description provided
    */
   public UMLQualifier (String name, UMLBaseTypes type, UMLRole revQualifier, UMLAttr qualifiedAttr)
   {
      super();
      setName (name);
      setRevQualifier (revQualifier);
      setType (type);
      setQualifiedAttr (qualifiedAttr);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected String createUnparseModuleName()
   {
      return UMLUnparseGetter.getUnparseModuleName (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name = null;


   /**
    * Get the name attribute of the UMLQualifier object
    *
    * @return   The name value
    */
   public String getName()
   {
      if (getFQualifiedAttr() != null)
      {
         return getFQualifiedAttr().getName();
      }
      if (getQualifiedRole() != null)
      {
         return getQualifiedRole().getAttrName();
      }
      if (name == null)
      {
         return " ";
      }
      else
      {
         return name;
      }

   }


   /**
    * Sets the name attribute of the UMLQualifier object
    *
    * @param name  The new name value
    */
   public void setName (String name)
   {
      if ( (this.name == null && name != null) ||
          (this.name != null && !this.name.equals (name)))
      {
         String oldValue = this.name;
         this.name = name;
         firePropertyChange (NAME_PROPERTY, oldValue, name);
      }
   }


   /**
    * Get the externalQualifier attribute of the UMLQualifier object
    *
    * @return   The externalQualifier value
    */
   public boolean isExternalQualifier()
   {
      return  (qualifiedAttr == null && qualifiedRole == null);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient UMLRole revQualifier; // reverse UMLQualifier qualifier

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the revQualifier attribute of the UMLQualifier object
    *
    * @return   The revQualifier value
    */
   public UMLRole getRevQualifier()
   {
      return revQualifier;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FQualifier#getFRevQualifier()
    */
   /**
    * Get the fRevQualifier attribute of the UMLQualifier object
    *
    * @return   The fRevQualifier value
    */
   public FRole getFRevQualifier()
   {
      return getRevQualifier();
   }
   // TODO-END

   /**
    * Sets the revQualifier attribute of the UMLQualifier object
    *
    * @param revQualifier  The new revQualifier value
    */
   public void setRevQualifier (FRole revQualifier)
   {
      if ( (this.revQualifier == null && revQualifier != null) ||
          (this.revQualifier != null && !this.revQualifier.equals (revQualifier)))
      { // new partner

         UMLRole oldRevQualifier = this.revQualifier;
         if (this.revQualifier != null)
         { // inform old partner
            this.revQualifier = null;
            oldRevQualifier.setQualifier (null);
         }
         this.revQualifier = (UMLRole) revQualifier;
         if (revQualifier != null)
         { // inform new partner
            revQualifier.setQualifier (this);
         }
         firePropertyChange (REV_QUALIFIER_PROPERTY, oldRevQualifier, revQualifier);
      }
   }


   /**
    * <pre>
    *          0..1        qualifiedAttr         n
    * UMLAttr ------------------------------------- UMLQualifier
    *          qualifiedAttr      revQualifiedAttr
    * </pre>
    */
   private UMLAttr qualifiedAttr;


   /**
    * UMLMethod: '+ setQualifiedAttr (value: UMLAttr): Boolean'
    *
    * @param value  The new qualifiedAttr value
    * @return       No description provided
    */
   public boolean setQualifiedAttr (FAttr value)
   {
      boolean changed = false;
      if (this.qualifiedAttr != value)
      {
         UMLAttr oldValue = this.qualifiedAttr;
         boolean oldExternalQualifier = isExternalQualifier();
         if (this.qualifiedAttr != null)
         {
            this.qualifiedAttr = null;
            oldValue.removeFromRevQualifiedAttr (this);
         }
         this.qualifiedAttr = (UMLAttr) value;
         firePropertyChange (QUALIFIED_ATTR_PROPERTY, oldValue, value);
         // firing name change for unparsing
         firePropertyChange (NAME_PROPERTY,  (oldValue == null ? null : oldValue.getName()),  (value == null ? null : value.getName()));
         firePropertyChange (EXTERNAL_QUALIFIER_PROPERTY, oldExternalQualifier, isExternalQualifier());
         if (value != null)
         {
            value.addToRevQualifiedAttr (this);
            setQualifiedRole (null);
         }
         changed = true;
      }
      return changed;
   }


   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * UMLMethod: '+ getQualifiedAttr (): UMLAttr'
    *
    * @return   The qualifiedAttr value
    */
   public UMLAttr getQualifiedAttr()
   {
      return this.qualifiedAttr;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FQualifier#getFQualifiedAttr()
    */
   /**
    * Get the fQualifiedAttr attribute of the UMLQualifier object
    *
    * @return   The fQualifiedAttr value
    */
   public FAttr getFQualifiedAttr()
   {
      return getQualifiedAttr();
   }
   // TODO-END


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLRole qualifiedRole;


   /**
    * UMLMethod: '+ setQualifiedAttr (value: UMLAttr): Boolean'
    *
    * @param value  The new qualifiedAttr value
    * @return       No description provided
    */
   public boolean setQualifiedRole (UMLRole value)
   {
      boolean changed = false;
      if (this.qualifiedRole != value)
      {
         UMLRole oldValue = this.qualifiedRole;
         boolean oldExternalQualifier = isExternalQualifier();
         if (this.qualifiedRole != null)
         {
            this.qualifiedRole = null;
            oldValue.removeFromRevQualifiedRole (this);
         }
         this.qualifiedRole = value;
         firePropertyChange ("qualifiedRole", oldValue, value);
         // firing name change for unparsing
         firePropertyChange (NAME_PROPERTY,  (oldValue == null ? null : oldValue.getName()),  (value == null ? null : value.getName()));
         firePropertyChange (EXTERNAL_QUALIFIER_PROPERTY, oldExternalQualifier, isExternalQualifier());
         if (value != null)
         {
            value.addToRevQualifiedRole (this);
            setQualifiedAttr (null);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * UMLMethod: '+ getQualifiedAttr (): UMLAttr'
    *
    * @return   The qualifiedAttr value
    */
   public UMLRole getQualifiedRole()
   {
      return this.qualifiedRole;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLType type = null; // reverse UMLQualifier revType

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the type attribute of the UMLQualifier object
    *
    * @return   The type value
    */
   public UMLType getType()
   {
      if (getFQualifiedAttr() != null)
      {
         return (UMLType) getFQualifiedAttr().getFAttrType();
      }
      else if (getQualifiedRole() != null)
      {
         return getQualifiedRole().getTarget();
      }
      return type;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FQualifier#getFType()
    */
   /**
    * Get the fType attribute of the UMLQualifier object
    *
    * @return   The fType value
    */
   public FType getFType()
   {
      return getType();
   }
   // TODO-END

   /**
    * Sets the type attribute of the UMLQualifier object
    *
    * @param type  The new type value
    */
   public void setType (FType type)
   {
      if ( (this.type == null && type != null) ||
          (this.type != null && !this.type.equals (type)))
      { // new partner
         UMLType oldType = this.type;
         boolean oldExternalQualifier = isExternalQualifier();
         if (this.type != null)
         { // inform old partner
            this.type = null;
            oldType.removeFromRevType (this);
         }
         this.type = (UMLType) type;
         if (type != null)
         { // inform new partner
             ((UMLType) type).addToRevType (this);
         }
         firePropertyChange (TYPE_PROPERTY, oldType, type);
         firePropertyChange (EXTERNAL_QUALIFIER_PROPERTY, oldExternalQualifier, isExternalQualifier());
      }
   }


   /**
    * Get the umlType attribute of the UMLQualifier object
    *
    * @return   The umlType value
    */
   public UMLType getUmlType()
   {
      if (qualifiedAttr != null)
      {
         return qualifiedAttr.getAttrType();
      }
      if (qualifiedRole != null)
      {
         return qualifiedRole.getTarget();
      }
      return type;
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      setType (null);
      setRevQualifier (null);
      setQualifiedAttr (null);
      setQualifiedRole (null);
      super.removeYou();
   }


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element, may not return null unless this is the top level node (project)
    */
   public FElement getParentElement()
   {
      return getFType();
   }

}

/*
 * $Log: UMLQualifier.java,v $
 * Revision 1.54.2.2  2006/05/09 15:25:59  joerg
 * used common constant
 *
 */
