/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.HashMap;

import de.uni_paderborn.fujaba.basic.RuntimeExceptionWithContext;



/**
 * This class represents path expressions
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.9 $
 */
public class UMLPath extends UMLLink
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int P_PATH = 70;


   /**
    * Constructor for class UMLPath
    */
   public UMLPath()
   {
      super();
   }


   /**
    * Constructor for class UMLPath
    *
    * @param source      No description provided
    * @param expression  No description provided
    * @param target      No description provided
    */
   public UMLPath (UMLObject source, String expression, UMLObject target)
   {
      setSource (source);
      setExpression (expression);
      setTarget (target);
   }


   /**
    * Get the reference attribute of the UMLPath object
    *
    * @return   The reference value
    */
   public boolean isReference()
   {
      return true;
   }


   /**
    * Get the navigable attribute of the UMLPath object
    *
    * @param source  No description provided
    * @return        The navigable value
    */
   public boolean isNavigable (UMLObject source)
   {
      return getSource() == source;
   }


   /**
    * The path expression.
    */
   private String expression;


   /**
    * Sets the expression attribute of the UMLPath object
    *
    * @param newExpression  The new expression value
    */
   public void setExpression (String newExpression)
   {
      if (this.expression != newExpression)
      {
         String oldExpression = this.expression;
         this.expression = newExpression;
         firePropertyChange ("expression", oldExpression, newExpression);
      }
   }


   /**
    * Get the expression attribute of the UMLPath object
    *
    * @return   The expression value
    */
   public String getExpression()
   {
      return this.expression;
   }


   /**
    * Get the correspondingRole attribute of the UMLPath object
    *
    * @param object  No description provided
    * @return        The correspondingRole value
    */
   public UMLRole getCorrespondingRole (UMLObject object)
   {
      throw new UnsupportedOperationException ("UMLPath.getCorrespondingRole (UMLObject) is not supported!");
   }


   /**
    * Get the sourceRole attribute of the UMLPath object
    *
    * @return   The sourceRole value
    */
   public UMLRole getSourceRole()
   {
      return null;
   }


   /**
    * Get the targetRole attribute of the UMLPath object
    *
    * @return   The targetRole value
    */
   public UMLRole getTargetRole()
   {
      return null;
   }


   /**
    * Get the priority attribute of the UMLPath object
    *
    * @param boundObjects        No description provided
    * @param isomorphicBindings  No description provided
    * @return                    The priority value
    */
   public int getPriority (HashMap boundObjects, HashMap isomorphicBindings)
   {
      UMLObject sourceObject = getSource();

      if (!boundObjects.containsKey (sourceObject.getID()))
      {
         throw new RuntimeExceptionWithContext ("The source object is not bound", this);
      }

      return P_PATH;
   }


   /**
    * String representation of UMLPath
    *
    * @return   short string representation of current path
    */
   public String toString()
   {
      return "UMLPath[name=" + getExpression() + "]";
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      super.removeYou();
   }
}

/*
 * $Log: UMLPath.java,v $
 * Revision 1.9  2005/02/17 12:49:22  cschneid
 * Exception and Error handling improved - execptions in actions displayed, context detection for codegen; new libraries
 *
 */
