/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.69.2.1 $
 */
public class UMLParam extends UMLDeclaration implements FParam
{
   /**
    * Constructor for class UMLParam
    */
   public UMLParam()
   {
      super();
   }


   /**
    * Constructor for class UMLParam
    *
    * @param coobraPersistent  No description provided
    */
   public UMLParam (boolean coobraPersistent)
   {
      super (coobraPersistent);
   }


   /**
    * Constructor for class UMLParam
    *
    * @param name       No description provided
    * @param paramType  No description provided
    */
   public UMLParam (String name, String paramType)
   {
      super();
      setName (name);
      setParamType (UMLProject.get().getTypeList().getFromTypes (paramType));
   }


   /**
    * Constructor for class UMLParam
    *
    * @param name       No description provided
    * @param paramType  No description provided
    */
   public UMLParam (String name, UMLType paramType)
   {
      super();
      setName (name);
      setParamType (paramType);
   }


   /**
    * Constructor for class UMLParam
    *
    * @param name       No description provided
    * @param paramType  No description provided
    * @param revParam   No description provided
    */
   public UMLParam (String name, UMLType paramType, UMLMethod revParam)
   {
      super();
      setName (name);
      setParamType (paramType);
      setRevParam (revParam);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected String createUnparseModuleName()
   {
      return UMLUnparseGetter.getUnparseModuleName (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name;


   /**
    * Get the name attribute of the UMLParam object
    *
    * @return   The name value
    */
   public String getName()
   {
      return  (name == null) ?  ("") : name;
   }


   /**
    * Sets the name attribute of the UMLParam object
    *
    * @param name  The new name value
    */
   public void setName (String name)
   {
      String oldValue = this.name;
      if (oldValue != name)
      {
         this.name = name;
         firePropertyChange (NAME_PROPERTY, oldValue, name);
      }
   }


   /**
    * gives back the name and type of the parameter as String.
    *
    * @return   the full qualified parameter as String.
    */
   public String getText()
   {
      String myName = "";

      myName = getName() + " : ";

      if (getFParamType() == null)
      {
         myName += "<unknown>";
      }
      else
      {
         myName +=  ((UMLIncrement) getFParamType()).getText();
      }

      return myName;
   }

   // ######################################################################
   // The following attribute should be transient.
   // The other side is a List and if the link is
   // restored from this side, the order may be corrupted.
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient UMLMethod revParam;

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the revParam attribute of the UMLParam object
    *
    * @return   The revParam value
    */
   public UMLMethod getRevParam()
   {
      return revParam;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FParam#getFRevParam()
    */
   /**
    * Get the fRevParam attribute of the UMLParam object
    *
    * @return   The fRevParam value
    */
   public FMethod getFRevParam()
   {
      return getRevParam();
   }
   // TODO-END

   /**
    * Sets the revParam attribute of the UMLParam object
    *
    * @param revParam  The new revParam value
    */
   public void setRevParam (FMethod revParam)
   {
      if (this.revParam != revParam)
      { // new partner

         UMLMethod oldRevParam = this.revParam;
         if (this.revParam != null)
         { // inform old partner

            this.revParam = null;
            oldRevParam.removeFromParam (this);
         }
         this.revParam = (UMLMethod) revParam;
         if (revParam != null)
         { // inform new partner

            revParam.addToParam (this);
         }
         firePropertyChange (REV_PARAM_PROPERTY, oldRevParam, revParam);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final void removeRevParam()
   {
      this.setRevParam (null);
   }


   /**
    * UMLAttribute : 'pointer : Boolean '
    */
   private boolean pointer = false;


   /**
    * Get the value of pointer.
    *
    * @return   Value of pointer.
    */
   public boolean isPointer()
   {
      return this.pointer;
   }


   /**
    * Set the value of pointer.
    *
    * @param pointer  Value to assign to pointer.
    */
   public void setPointer (boolean pointer)
   {
      if (this.pointer != pointer)
      {
         this.pointer = pointer;
      }
   }


   /**
    * UMLAttribute : 'callByReference : Boolean '
    */
   private boolean callByReference = false;


   /**
    * Get the value of callByReference.
    *
    * @return   Value of callByReference.
    */
   public boolean isCallByReference()
   {
      return this.callByReference;
   }


   /**
    * Set the value of callByReference.
    *
    * @param callByReference  Value to assign to callByReference.
    */
   public void setCallByReference (boolean callByReference)
   {
      if (this.callByReference != callByReference)
      {
         this.callByReference = callByReference;
      }
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLType paramType;

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the paramType attribute of the UMLParam object
    *
    * @return   The paramType value
    */
   public UMLType getParamType()
   {
      return paramType;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FParam#getFParamType()
    */
   /**
    * Get the fParamType attribute of the UMLParam object
    *
    * @return   The fParamType value
    */
   public FType getFParamType()
   {
      return getParamType();
   }
   // TODO-END

   /**
    * Get the uMLType attribute of the UMLParam object
    *
    * @return   The uMLType value
    */
   public UMLType getUMLType()
   {
      return getParamType();
   }


   /**
    * Sets the paramType attribute of the UMLParam object
    *
    * @param paramType  The new paramType value
    */
   public void setParamType (FType paramType)
   {
      if (this.paramType != paramType)
      {
         // new partner
         UMLType oldParamType = this.paramType;
         if (this.paramType != null)
         {
            // inform old partner
            this.paramType = null;
            oldParamType.removeFromRevParamType (this);
         }
         this.paramType = (UMLType) paramType;
         firePropertyChange (PARAM_TYPE_PROPERTY, oldParamType, paramType);
         if (paramType != null)
         {
            // inform new partner
             ((UMLType) paramType).addToRevParamType (this);
         }
         if (getRevParam() != null)
         {
            this.getRevParam().updateAssocOverFullMethodName();
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final void removeParamType()
   {
      this.setParamType (null);
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      this.removeRevParam();
      this.removeParamType();

      super.removeYou();
   }


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element;
    */
   public FElement getParentElement()
   {
      return getRevParam();
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append ("UMLParam[");
      result.append (getFParamType());
      result.append (",");
      result.append (getName());
      result.append (",");
      result.append (isPointer());
      result.append (",");
      result.append (isCallByReference());
      result.append ("]");

      return result.toString();
   }
}

/*
 * $Log: UMLParam.java,v $
 * Revision 1.69.2.1  2005/05/02 11:51:07  creckord
 * Fix for Multilinks
 * Small change in CoObRA change filtering
 *
 */
