/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.TreeMap;



/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.31 $
 */
public class UMLLinkSet extends UMLLink
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int FIRST = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int LAST = 1;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int NEIGHBOUR = 2;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int NEXT = 3;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int ORDERED = 0;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static transient int SORTED = 1;


   /**
    * Constructor for class UMLLinkSet
    */
   public UMLLinkSet()
   {
      super();
   }


   /**
    * Constructor for class UMLLinkSet
    *
    * @param name        No description provided
    * @param type        No description provided
    * @param modifier    No description provided
    * @param range       No description provided
    * @param source      No description provided
    * @param target      No description provided
    * @param instanceOf  No description provided
    * @param setType     No description provided
    */
   public UMLLinkSet (String name, int type, int modifier,
                      String range, UMLObject source, UMLObject target, UMLAssoc instanceOf,
                      int setType)
   {
      super (name, type, modifier, range, source, target, instanceOf);
      setSetType (setType);
   }


   /**
    * Sets the type attribute of the UMLLinkSet object
    *
    * @param type  The new type value
    */
   public void setType (int type)
   {
      if (FIRST <= type && type <= NEXT)
      {
         super.setType (type);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int setType = ORDERED;


   /**
    * Get the setType attribute of the UMLLinkSet object
    *
    * @return   The setType value
    */
   public int getSetType()
   {
      return setType;
   }


   /**
    * Sets the setType attribute of the UMLLinkSet object
    *
    * @param setType  The new setType value
    */
   public void setSetType (int setType)
   {
      int oldValue = this.setType;
      this.setType = setType;
      firePropertyChange ("setType", oldValue, setType);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLObject toSetObject; // reverse OrderedSet /*UMLLinkSet*/ revToSetObject


   /**
    * Get the toSetObject attribute of the UMLLinkSet object
    *
    * @return   The toSetObject value
    */
   public UMLObject getToSetObject()
   {
      return toSetObject;
   }


   /**
    * Sets the toSetObject attribute of the UMLLinkSet object
    *
    * @param toSetObject  The new toSetObject value
    */
   public void setToSetObject (UMLObject toSetObject)
   {
      if (this.toSetObject != toSetObject)
      { // new partner

         UMLObject oldToSetObject = this.toSetObject;
         if (this.toSetObject != null)
         { // inform old partner

            this.toSetObject = null;
            oldToSetObject.removeFromRevToSetObject (this);
         }
         this.toSetObject = toSetObject;
         if (toSetObject != null)
         { // inform new partner

            toSetObject.addToRevToSetObject (this);
         }
         firePropertyChange ("toSetObject", oldToSetObject, toSetObject);
      }
   }


   /**
    * Get the successorLinkSet attribute of the UMLLinkSet object
    *
    * @param objectsMap  No description provided
    * @return            The successorLinkSet value
    */
   public UMLLinkSet getSuccessorLinkSet (TreeMap objectsMap)
   {
      UMLLinkSet succLinkSet = null;
      UMLObject source = (UMLObject) objectsMap.get (getSource());
      UMLObject target = (UMLObject) objectsMap.get (getTarget());
      UMLObject toSet = (UMLObject) objectsMap.get (getToSetObject());

      if (source != null && target != null && getModifier() != DELETE)
      {
         succLinkSet = new UMLLinkSet (getName(), getType(), NONE, getRange(), source, target, getInstanceOf(), getSetType());
         succLinkSet.setToSetObject (toSet);
      }

      return succLinkSet;
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      setToSetObject (null);

      super.removeYou();
   }

}

/*
 * $Log: UMLLinkSet.java,v $
 * Revision 1.31  2004/11/03 11:47:54  lowende
 * Javadoc warnings removed.
 *
 */
