/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.69 $
 */
public class UMLGeneralization extends UMLConnection implements FGeneralization
{

   /**
    * Constructor for class UMLGeneralization
    */
   public UMLGeneralization()
   {
      super();
   }


   /**
    * @param coobraPersistent
    */
   public UMLGeneralization (boolean coobraPersistent)
   {
      super (coobraPersistent);
   }


   /**
    * Constructor for class UMLGeneralization
    *
    * @param subclass    No description provided
    * @param superclass  No description provided
    */
   public UMLGeneralization (UMLClass subclass, UMLClass superclass)
   {
      this (null, null, subclass, superclass);
   }


   /**
    * Constructor for class UMLGeneralization
    *
    * @param discriminator  No description provided
    * @param constraint     No description provided
    * @param subclass       No description provided
    * @param superclass     No description provided
    */
   public UMLGeneralization (String discriminator, UMLConstraint constraint, UMLClass subclass, UMLClass superclass)
   {
      super();
      setDiscriminator (discriminator);
      addToConstraints (constraint);
      setSubclass (subclass);
      setSuperclass (superclass);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String discriminator;


   /**
    * Get the discriminator attribute of the UMLGeneralization object
    *
    * @return   The discriminator value
    */
   public String getDiscriminator()
   {
      return discriminator;
   }


   /**
    * Sets the discriminator attribute of the UMLGeneralization object
    *
    * @param discriminator  The new discriminator value
    */
   public void setDiscriminator (String discriminator)
   {
      String oldValue = this.discriminator;
      this.discriminator = discriminator;
      firePropertyChange (DISCRIMINATOR_PROPERTY, oldValue, discriminator);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name;


   /**
    * Get the name attribute of the UMLGeneralization object
    *
    * @return   The name value
    */
   public String getName()
   {
      return name;
   }


   /**
    * Sets the name attribute of the UMLGeneralization object
    *
    * @param name  The new name value
    */
   public void setName (String name)
   {
      String oldValue = this.name;
      this.name = name;
      firePropertyChange (NAME_PROPERTY, oldValue, name);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLClass subclass;

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the subclass attribute of the UMLGeneralization object
    *
    * @return   The subclass value
    */
   public UMLClass getSubclass()
   {
      return this.subclass;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FGeneralization#getFSubclass()
    */
   /**
    * Get the fSubclass attribute of the UMLGeneralization object
    *
    * @return   The fSubclass value
    */
   public FClass getFSubclass()
   {
      return getSubclass();
   }
   // TODO-END

   /**
    * Sets the subclass attribute of the UMLGeneralization object
    *
    * @param subclass  The new subclass value
    * @return          No description provided
    */
   public boolean setSubclass (FClass subclass)
   {
      if (this.subclass != subclass)
      { // new partner

         UMLClass oldSubclass = this.subclass;
         if (this.subclass != null)
         { // inform old partner

            this.subclass = null;
            oldSubclass.removeFromRevSubclass (this);
         }
         this.subclass = (UMLClass) subclass;
         if (subclass != null)
         { // inform new partner

            subclass.addToRevSubclass (this);
         }
         firePropertyChange (SUBCLASS_PROPERTY, oldSubclass, subclass);
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final void removeSubclass()
   {
      this.setSubclass (null);
   }


   /**
    * Sets the targetConnector attribute of the UMLGeneralization object
    *
    * @param incr  The new targetConnector value
    * @return      No description provided
    */
   public boolean setTargetConnector (FDiagramItem incr)
   {
      if (! (incr instanceof UMLClass))
      {
         throw new IllegalArgumentException ("Argument is no UMLClass");
      }
      return setSubclass ((UMLClass) incr);
   }


   /**
    * Get the targetConnector attribute of the UMLGeneralization object
    *
    * @return   The targetConnector value
    */
   public UMLDiagramItem getTargetConnector()
   {
      return getSubclass();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLClass superclass;

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the superclass attribute of the UMLGeneralization object
    *
    * @return   The superclass value
    */
   public UMLClass getSuperclass()
   {
      return this.superclass;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FGeneralization#getFSuperclass()
    */
   /**
    * Get the fSuperclass attribute of the UMLGeneralization object
    *
    * @return   The fSuperclass value
    */
   public FClass getFSuperclass()
   {
      return getSuperclass();
   }
   // TODO-END

   /**
    * Sets the superclass attribute of the UMLGeneralization object
    *
    * @param superclass  The new superclass value
    * @return            No description provided
    */
   public boolean setSuperclass (FClass superclass)
   {
      if (this.superclass != superclass)
      { // new partner

         UMLClass oldSuperclass = this.superclass;
         if (this.superclass != null)
         { // inform old partner

            this.superclass = null;
            oldSuperclass.removeFromRevSuperclass (this);
         }
         this.superclass = (UMLClass) superclass;
         if (superclass != null)
         { // inform new partner

            superclass.addToRevSuperclass (this);
         }
         firePropertyChange (SUPERCLASS_PROPERTY, oldSuperclass, superclass);
         return true;
      }
      return false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final void removeSuperclass()
   {
      this.setSuperclass (null);
   }


   /**
    * Sets the sourceConnector attribute of the UMLGeneralization object
    *
    * @param incr  The new sourceConnector value
    * @return      No description provided
    */
   public boolean setSourceConnector (FDiagramItem incr)
   {
      if (! (incr instanceof UMLClass))
      {
         throw new IllegalArgumentException ("Argument is no UMLClass");
      }
      return setSuperclass ((UMLClass) incr);
   }


   /**
    * Get the sourceConnector attribute of the UMLGeneralization object
    *
    * @return   The sourceConnector value
    */
   public UMLDiagramItem getSourceConnector()
   {
      return getSuperclass();
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      this.removeSubclass();
      this.removeSuperclass();

      super.removeYou();
   }


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element;
    */
   public FElement getParentElement()
   {
      return getSubclass();
   }


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      return "UMLGeneralization[superclass=" + superclass + ",subclass=" + subclass + "]";
   }
}

/*
 * $Log: UMLGeneralization.java,v $
 * Revision 1.69  2005/03/04 14:43:29  cschneid
 * changed ASGProject.diags to FHashSet, NAC fix, new libs
 *
 */
