/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;
import de.uni_paderborn.fujaba.views.ViewDefinition;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: l3_g5 $
 * @version   $Revision: 1.114.2.1 $
 */
public abstract class UMLDiagramItem extends UMLIncrement implements FDiagramItem
{

   /**
    * Constructor for class UMLDiagramItem
    */
   public UMLDiagramItem()
   {
      super();
   } // UMLDiagramItem



   /**
    * @param coobraPersistent
    */
   protected UMLDiagramItem (boolean coobraPersistent)
   {
      super (coobraPersistent);
   }



   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected String createUnparseModuleName()
   {
      return UMLUnparseGetter.getUnparseModuleName (this);
   }


   // ---- special methods for the diagrams role ---

   /**
    * returns the first diagram in the set of diagrams.
    *
    * @return   The firstFromDiagrams value
    */
   public UMLDiagram getFirstFromDiagrams()
   {
      UMLDiagram diag = null;
      Iterator iter = iteratorOfDiagrams();

      if (iter.hasNext())
      {
         diag = (UMLDiagram) iter.next();
      }
      return diag;
   }


   /**
    * ensures that only UMLDiagrams can be added to the set of diagrams.
    *
    * @param diagram  The object added.
    */
   public void addToDiagrams (FDiagram diagram)
   {
      if ( (diagram instanceof UMLDiagram) && !hasInDiagrams (diagram))
      {
         super.addToDiagrams (diagram);
      }
   } // addToDiagrams

   // ---- end of diagrams role ---

   /**
    * Returns the current active diagram of the item and works as follows: - Iterate over all
    * display increments of this item. - Select the item, which method getCanvas().getPanel()
    * returns not null it indicates that the display item is actually shown on the screen.
    * (Visibility is not taken into account!!!!!!) - Climb up the parent link until a display
    * object corresponding to an UMLDiagram is found. - This diagram is returned.
    *
    * @return   The currentActiveDiagram value
    */
   public UMLDiagram getCurrentActiveDiagram()
   {
      UMLDiagram activeDiag = null;

      if ( (this instanceof UMLObject) ||  (this instanceof UMLLink))
      {
         activeDiag = getFirstFromDiagrams();
      }
      else
      {
         activeDiag = UMLProject.get().getCurrentUMLDiagram();
      }

      return activeDiag;
   }


   /**
    * <pre>
    *                 0..n                     0..n
    * UMLDiagramItem ------------------------------- ViewDefinition
    *                 startItems    viewDefinitions
    * </pre>
    */
   private FHashSet viewDefinitions;


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToViewDefinitions (ViewDefinition value)
   {
      boolean changed = false;

      if (value != null)
      {
         if (this.viewDefinitions == null)
         {
            this.viewDefinitions = new FPropHashSet (this, VIEW_DEFINITIONS_PROPERTY);
         }
         changed = this.viewDefinitions.add (value);
         if (changed)
         {
            value.addToStartItems (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInViewDefinitions (ViewDefinition value)
   {
      return  ( (this.viewDefinitions != null) &&
          (value != null) &&
         this.viewDefinitions.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfViewDefinitions()
   {
      return  ( (this.viewDefinitions == null)
         ? FEmptyIterator.get()
         : this.viewDefinitions.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfViewDefinitions()
   {
      return  ( (this.viewDefinitions == null)
         ? 0
         : this.viewDefinitions.size());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromViewDefinitions (ViewDefinition value)
   {
      boolean changed = false;

      if ( (this.viewDefinitions != null) &&  (value != null))
      {
         changed = this.viewDefinitions.remove (value);
         if (changed)
         {
            value.removeFromStartItems (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromViewDefinitions()
   {
      ViewDefinition tmpValue;
      Iterator iter = this.iteratorOfViewDefinitions();

      while (iter.hasNext())
      {
         tmpValue = (ViewDefinition) iter.next();
         this.removeFromViewDefinitions (tmpValue);
      }
   }


   /**
    * <pre>
    *          N                            N
    * UMLDiagramItem ----------------------------- ViewDefinition
    *          items     revItems
    * </pre>
    */
   private transient FHashSet revItems;


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevItems (ViewDefinition value)
   {
      boolean changed = false;

      if (value != null)
      {
         if (this.revItems == null)
         {
            this.revItems = new FPropHashSet (this, REV_ITEMS_PROPERTY);
         }
         changed = this.revItems.add (value);
         if (changed)
         {
            value.addToItems (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevItems (ViewDefinition value)
   {
      return  ( (this.revItems != null) &&
          (value != null) &&
         this.revItems.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevItems()
   {
      return  ( (this.revItems == null)
         ? FEmptyIterator.get()
         : this.revItems.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevItems()
   {
      return  ( (this.revItems == null)
         ? 0
         : this.revItems.size());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevItems (ViewDefinition value)
   {
      boolean changed = false;

      if ( (this.revItems != null) &&  (value != null))
      {
         changed = this.revItems.remove (value);
         if (changed)
         {
            value.removeFromItems (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevItems()
   {
      ViewDefinition tmpValue;
      Iterator iter = this.iteratorOfRevItems();

      while (iter.hasNext())
      {
         tmpValue = (ViewDefinition) iter.next();
         this.removeFromRevItems (tmpValue);
      }
   }


   /**
    * <pre>
    *                 0..n                              0..n
    * UMLDiagramItem ---------------------------------------- ViewDiagram
    *                 additionalItems     revAdditionalItems
    * </pre>
    */
   private FHashSet revAdditionalItems;


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevAdditionalItems (ViewDiagram value)
   {
      boolean changed = false;

      if (value != null)
      {
         if (this.revAdditionalItems == null)
         {
            this.revAdditionalItems = new FPropHashSet (this, REV_ADDITIONAL_ITEMS_PROPERTY);
         }
         changed = this.revAdditionalItems.add (value);
         if (changed)
         {
            value.addToAdditionalItems (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevAdditionalItems (ViewDiagram value)
   {
      return  ( (this.revAdditionalItems != null) &&
          (value != null) &&
         this.revAdditionalItems.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevAdditionalItems()
   {
      return  ( (this.revAdditionalItems == null)
         ? FEmptyIterator.get()
         : this.revAdditionalItems.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevAdditionalItems()
   {
      return  ( (this.revAdditionalItems == null)
         ? 0
         : this.revAdditionalItems.size());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevAdditionalItems (ViewDiagram value)
   {
      boolean changed = false;

      if ( (this.revAdditionalItems != null) &&  (value != null))
      {
         changed = this.revAdditionalItems.remove (value);
         if (changed)
         {
            value.removeFromAdditionalItems (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevAdditionalItems()
   {
      ViewDiagram tmpValue;
      Iterator iter = this.iteratorOfRevAdditionalItems();

      while (iter.hasNext())
      {
         tmpValue = (ViewDiagram) iter.next();
         this.removeFromRevAdditionalItems (tmpValue);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      return getName();
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      removeAllFromRevAdditionalItems();
      super.removeYou();
   } // removeYou


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    * This method allows to navigate in direction of the model root (project) from any element within a project.
    *
    * @return   the logical parent of this element, may not return null unless this is the top level node (project)
    *         or is not contained in any parent yet
    */
   public FElement getParentElement()
   {
      if (sizeOfDiagrams() == 1)
      {
         return getFFirstFromDiagrams();
      }
      else if (sizeOfDiagrams() == 0)
      {
         return null;
      }
      else
      {
         throw new UnsupportedOperationException (getClass() + " does not support to query the parent element if present in multiple/no diagrams!");
      }
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FDiagramItem#getFFirstFromDiagrams()
    */
   /**
    * Get the fFirstFromDiagrams attribute of the UMLDiagramItem object
    *
    * @return   The fFirstFromDiagrams value
    */
   public FDiagram getFFirstFromDiagrams()
   {
      return getFirstFromDiagrams();
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FDiagramItem#getFCurrentActiveDiagram()
    */
   /**
    * Get the fCurrentActiveDiagram attribute of the UMLDiagramItem object
    *
    * @return   The fCurrentActiveDiagram value
    */
   public FDiagram getFCurrentActiveDiagram()
   {
      return getCurrentActiveDiagram();
   }

}

/*
 * $Log: UMLDiagramItem.java,v $
 * Revision 1.114.2.1  2006/02/16 17:36:09  l3_g5
 * checkout cxr ant task added
 *
 */
