/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;
import java.util.Map;

import javax.swing.*;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.asg.ASGElement;
import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.packagediagrams.DiagramUsage;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.tools.fca.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: fklar $
 * @version   $Revision: 1.161.2.2 $
 */
public abstract class UMLDiagram extends ASGDiagram implements FModelDiagram
{
   /**
    * @deprecated   the virtual items attribute will be removed - use elements instead
    */
   public final static String ELEMENTKEY = "items";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @deprecated
    */
   public final static String PROPERTY_NAME = FElement.NAME_PROPERTY;


   /**
    * Constructor for class UMLDiagram
    */
   public UMLDiagram()
   {
      super();
   }


   /**
    * @param coobraPersistent
    */
   protected UMLDiagram (boolean coobraPersistent)
   {
      super (coobraPersistent);
   }


   /**
    * Constructor for class UMLDiagram
    *
    * @param name     No description provided
    * @param project  No description provided
    */
   public UMLDiagram (String name, UMLProject project)
   {
      super();
      setName (name);
      setProject (project);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected String createUnparseModuleName()
   {
      return UMLUnparseGetter.getUnparseModuleName (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name;


   /**
    * Get the name attribute of the UMLDiagram object
    *
    * @return   The name value
    */
   public String getName()
   {
      return name;
   }


   /**
    * Sets the name attribute of the UMLDiagram object
    *
    * @param name  The new name value
    */
   public void setName (String name)
   {
      if ( (this.name == null && name != null) ||
          (this.name != null && !this.name.equals (name)))
      {
         String oldValue = this.name;
         this.name = name;
         firePropertyChange (NAME_PROPERTY, oldValue, name);

         Iterator usages = this.iteratorOfUsages();

         while (usages.hasNext())
         {
            DiagramUsage currentUsage = (DiagramUsage) usages.next();

            if (currentUsage != null &&
               !currentUsage.getName().equals (this.name))
            {
               currentUsage.setName (this.name);
            }
         }
      }
   }


   /**
    * Get the sizeOfItems attribute of the UMLDiagram object
    *
    * @return       The sizeOfItems value
    * @deprecated   the virtual items attribute will be removed - use sizeOfElements instead
    */
   public int getSizeOfItems()
   {
      return sizeOfElements();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return       No description provided
    * @deprecated   the virtual items attribute will be removed - use sizeOfElements instead
    */
   public int sizeOfItems()
   {
      return sizeOfElements();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param item   No description provided
    * @return       No description provided
    * @deprecated   the virtual items attribute will be removed - use hasInElements instead
    */
   public boolean hasInItems (UMLDiagramItem item)
   {
      return hasInElements (item);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return       No description provided
    * @deprecated   the virtual items attribute will be removed - use iteratorOfElements instead
    */
   public Iterator iteratorOfItems()
   {
      return iteratorOfElements();
   }


   /**
    * This method is needed for the versioning mechanism as {@link ASGDiagram#addToElements(FElement)}
    * fires property changes with {@link #getElementKey}, for a UMLDiagram this returns "items".
    * FIXME: This method should be deleted if the elements of a UMLDiagram are <b>only</b>
    * UMLDiagramItems again.<br>
    * Do not use it as default accessor.
    *
    * @param item   what to remove from the elements.
    * @return       <code>removeFromElements ( item )</code>
    * @deprecated   the virtual items attribute will be removed - use removeFromElements instead
    */
   public boolean removeFromItems (ASGElement item)
   {
      return removeFromElements (item);
   }


   /**
    * Access method for an one to n association.
    *
    * @param element  The object added.
    * @return         No description provided
    */
   public boolean addToElements (ASGElement element)
   {
      boolean changed = super.addToElements (element);

      if (changed)
      {
         if (element instanceof UMLClass &&
             ((UMLType) element).getName() != null &&
             (getProject() instanceof UMLProject))
         {
            UMLProject project = (UMLProject) getProject();
            UMLTypeList list = project.getTypeList();
            if (list == null)
            {
               list = new UMLTypeList();
               project.setTypeList (list);
            }
            list.addToTypes ((UMLType) element);
         }

         Iterator iter = iteratorOfViews();
         while (iter.hasNext())
         {
            ViewDiagram viewDiag = (ViewDiagram) iter.next();
            if (!viewDiag.hasInElements (element))
            {
               viewDiag.update();
            }
         }
      }
      return changed;
   }


   /**
    * This method is needed for the versioning mechanism as {@link ASGDiagram#addToElements(de.uni_paderborn.fujaba.metamodel.FElement)}
    * fires property changes with {@link #getElementKey}, for a UMLDiagram this returns "items".
    * UMLDiagramItems again.<br>
    * Do not use it as default accessor.
    *
    * @param item   what to add to the elements.
    * @return       <code>addToElements ( item )</code>
    * @deprecated   the virtual items attribute will be removed - use addToElements instead
    */
   public boolean addToItems (ASGElement item)
   {
      boolean changed = addToElements (item);

      if (changed)
      {
         if (item instanceof UMLClass &&
             ((UMLType) item).getName() != null &&
             (getProject() instanceof UMLProject))
         {
            UMLProject project = (UMLProject) getProject();
            UMLTypeList list = project.getTypeList();
            if (list == null)
            {
               list = new UMLTypeList();
               project.setTypeList (list);
            }
            list.addToTypes ((UMLType) item);
         }

         Iterator iter = iteratorOfViews();
         while (iter.hasNext())
         {
            ViewDiagram viewDiag = (ViewDiagram) iter.next();
            if (!viewDiag.hasInElements (item))
            {
               viewDiag.update();
            }
         }
      }
      return changed;
   }


   /**
    * Access method for an one to n association.
    *
    * @param entry  The object added.
    */
   public void addToElements (Map.Entry entry)
   {
      ASGElement item = (ASGElement) entry.getValue();
      this.addToElements (item);
   }


   /**
    * @param entry  The object added.
    * @deprecated   the virtual items attribute will be removed - use elements instead
    */
   protected void addToItems (Map.Entry entry)
   {
      UMLDiagramItem item = (UMLDiagramItem) entry.getValue();
      this.addToElements (item);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param item   No description provided
    * @return       No description provided
    * @deprecated   the virtual items attribute will be removed - use removeFromElements instead
    */
   public boolean removeFromItems (UMLDiagramItem item)
   {
      boolean changed = removeFromItemsWithoutIncrementAge (item);
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @deprecated   the virtual items attribute will be removed - use removeAllFromElements
    *      instead
    */
   public void removeAllFromItems()
   {
      UMLDiagramItem item;
      Iterator iter = iteratorOfItems();

      while (iter.hasNext())
      {
         item = (UMLDiagramItem) iter.next();
         removeFromElements (item);
      }
   }


   /**
    * Get the elementKey attribute of the UMLDiagram object
    *
    * @return       The elementKey value
    * @deprecated   the virtual items attribute will be removed - use elements instead
    */
   public String getElementKey()
   {
      return ELEMENTKEY;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param asgElement  No description provided
    * @return            No description provided
    * @deprecated        the virtual items attribute will be removed - use removeFromElementsWithSideEffects
    *      instead
    */
   public boolean removeFromItemsWithoutIncrementAge (ASGElement asgElement)
   {
      boolean changed = super.removeFromElements (asgElement);

      if (changed)
      {
         removeFromItemsViewSideEffects (asgElement);
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param asgElement  No description provided
    * @return            No description provided
    */
   public boolean removeFromElementsWithSideEffects (ASGElement asgElement)
   {
      boolean changed = super.removeFromElements (asgElement);

      if (changed)
      {
         removeFromItemsViewSideEffects (asgElement);
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param asgElement  No description provided
    */
   private void removeFromItemsViewSideEffects (ASGElement asgElement)
   {
      Iterator viewIter = null;

      viewIter = iteratorOfViews();
      while (viewIter.hasNext())
      {
         ViewDiagram viewDiag = (ViewDiagram) viewIter.next();
         viewDiag.removeFromElements (asgElement);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FPropTreeSet constraints;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInConstraints (FConstraint value)
   {
      return  ( (this.constraints == null)
         ? false
         : this.constraints.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfConstraints()
   {
      return  ( (this.constraints == null)
         ? FEmptyIterator.get()
         : this.constraints.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfConstraint()
   {
      return  ( (this.constraints == null)
         ? 0
         : this.constraints.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToConstraints (FConstraint value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.constraints == null)
         {
            this.constraints = new FPropTreeSet (this, CONSTRAINTS_PROPERTY);
         }
         changed = this.constraints.add (value);
         if (changed)
         {
            value.addToRevConstraint (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromConstraints (FConstraint value)
   {
      boolean changed = false;
      if ( (this.constraints != null) &&  (value != null))
      {
         changed = this.constraints.remove (value);
         if (changed)
         {
            value.removeFromRevConstraint (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromConstraints()
   {
      UMLConstraint tmpValue;
      Iterator iter = this.iteratorOfConstraints();
      while (iter.hasNext())
      {
         tmpValue = (UMLConstraint) iter.next();
         this.removeFromConstraints (tmpValue);
      }
   }


   // ######################################################################


   /**
    * <pre>
    *                0..1   masterCollabStat   0..1
    * UMLCollabStat -------------------------------- UMLDiagram
    *                collabStat                diag
    * </pre>
    */
   private UMLCollabStat collabStat;


   /**
    * Sets the collabStat attribute of the UMLDiagram object
    *
    * @param value  The new collabStat value
    * @return       No description provided
    */
   public boolean setCollabStat (UMLCollabStat value)
   {
      boolean changed = false;
      if (this.collabStat != value)
      {
         if (this.collabStat != null)
         {
            UMLCollabStat oldValue = this.collabStat;
            this.collabStat = null;
            oldValue.setDiag (null);
         }
         this.collabStat = value;
         if (value != null)
         {
            value.setDiag (this);
         }
         changed = true;
      }
      return changed;
   }


   /**
    * Get the collabStat attribute of the UMLDiagram object
    *
    * @return   The collabStat value
    */
   public UMLCollabStat getCollabStat()
   {
      return this.collabStat;
   }


   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      setCollabStat (null);
      removeAllFromViews();
      removeAllFromUsages();
      super.removeYou();
   }


   /**
    * <pre>
    *             0..1               n
    * UMLDiagram ---------------------- ViewDiagram
    *             diagram        views
    * </pre>
    */
   private FHashSet views;


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToViews (ViewDiagram value)
   {
      boolean changed = false;

      if (value != null)
      {
         if (this.views == null)
         {
            this.views = new FHashSet();
         }
         changed = this.views.add (value);
         if (changed)
         {
            value.setDiagram (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInViews (ViewDiagram value)
   {
      return  ( (this.views != null) &&
          (value != null) &&
         this.views.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfViews()
   {
      return  ( (this.views == null)
         ? FEmptyIterator.get()
         : this.views.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfViews()
   {
      return  ( (this.views == null)
         ? 0
         : this.views.size());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromViews (ViewDiagram value)
   {
      boolean changed = false;

      if ( (this.views != null) &&  (value != null))
      {
         changed = this.views.remove (value);
         if (changed)
         {
            //Note: If someone should change this someday to
            //something like value.setDiagram(null) you should
            //better see that value.setDiagram(...) removes all
            //startItems from its ViewDefinitions. Otherwise
            //these items cannot be isolated for the Garbage Collector
            //by item.removeYou()!!!!
            value.removeYou();
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromViews()
   {
      ViewDiagram tmpValue;
      Iterator iter = this.iteratorOfViews();

      while (iter.hasNext())
      {
         tmpValue = (ViewDiagram) iter.next();
         this.removeFromViews (tmpValue);
      }
   }


   /**
    * Return the view named 'name'.
    *
    * @param name  The name of the view to search for.
    * @return      A view named 'name' or null, if no such view exists.
    */
   public ViewDiagram getViewByName (String name)
   {
      ViewDiagram viewDiagram = null;

      if (name != null)
      {
         Iterator iter = iteratorOfViews();
         while (iter.hasNext() &&  (viewDiagram == null))
         {
            ViewDiagram view = (ViewDiagram) iter.next();

            if (name.equals (view.getName()))
            {
               viewDiagram = view;
            }
         }
      }

      return viewDiagram;
   } // getViewByName


   /**
    * Deletes itself and all items of type UMLDiagramItem, that are ONLY contained in this diagram,
    * but asks the user, if the diagram that should be deleted contains items
    * that are ONLY contained in this diagram.
    */
   public void delete()
   {
      FTreeSet itemsToDelete = new FTreeSet();
      Iterator elementsIter = null;

      elementsIter = this.iteratorOfElements();
      while (elementsIter.hasNext())
      {
         Object obj = elementsIter.next();
         if (obj instanceof UMLDiagramItem)
         {
            UMLDiagramItem item = (UMLDiagramItem) obj;
            Iterator diagsIter = item.iteratorOfDiagrams();

            // check if the item is contained in another diagram
            boolean containedInOtherDiagram = false;
            while (!containedInOtherDiagram && diagsIter.hasNext())
            {
               ASGDiagram tmpDiag = (ASGDiagram) diagsIter.next();
               if (tmpDiag != this && ! (tmpDiag instanceof ViewDiagram))
               {
                  containedInOtherDiagram = true;
               }
            }
            if (!containedInOtherDiagram)
            {
               itemsToDelete.add (item);
            }
         }
      }

      boolean deleteAnyway = true;
      int itemsToDeleteSize = itemsToDelete.size();
      if (itemsToDeleteSize > 0)
      {
         String itemSizeString = itemsToDeleteSize + "";
         if (itemsToDeleteSize == 1)
         {
            itemSizeString += " item";
         }
         else
         {
            itemSizeString += " items";
         }

         int answer = JOptionPane.showConfirmDialog (FrameMain.get(),
            itemSizeString + " in diagram '" + this + "' are not contained in other diagrams.\n" +
            "If you delete the diagram these items will be deleted from the project as well.\n" +
            "Before deleting the diagram, you may clean it up by selecting\n" +
            "'Edit Class Diagram ...' from the diagrams context-menu\n" +
            "\nDo you really want to delete the diagram?",
            "Delete diagram items",
            JOptionPane.YES_NO_OPTION);

         deleteAnyway =  (answer == JOptionPane.YES_OPTION);
      }

      if (deleteAnyway)
      {
         // OK, delete items and the diagram
         Iterator itemsToDeleteIter = itemsToDelete.iterator();
         while (itemsToDeleteIter.hasNext())
         {
             ((UMLDiagramItem) itemsToDeleteIter.next()).removeYou();
         }
         this.removeYou();
      }
   }

}

/*
 * $Log: UMLDiagram.java,v $
 * Revision 1.161.2.2  2006/02/16 15:25:17  fklar
 * + refactored method 'delete'
 * + reviewed usermessage that is popped up in method 'delete' (made it more verbose and corrected wrong description of what is happening, if user presses 'yes')
 *
 */
