/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.FDeclaration;


/**
 * @author       $Author: schneider $
 * @version      $Revision: 1.9 $
 * @deprecated   use {@link FDeclaration}
 */
public interface UMLDeclarationInterface
{
   /**
    * indicates a declaration element as internal used element. It is not shown as default.
    */
   public final static int CODE_DISPLAY_LEVEL = 0;

   /**
    * indicates a declaration element as user element. It is shown as default.
    */
   public final static int DESIGN_DISPLAY_LEVEL = CODE_DISPLAY_LEVEL + 1;

   /**
    * indicates a declaration element as a private element.
    */
   public final static int PRIVATE = 0;

   /**
    * indicates a declaration element as a public element.
    */
   public final static int PUBLIC = PRIVATE + 1;

   /**
    * indicates a declaration element as a protected element.
    */
   public final static int PROTECTED = PUBLIC + 1;

   /**
    * indicates a declaration element as a package element.
    */
   public final static int PACKAGE = PROTECTED + 1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int USERDEFINED = PACKAGE + 1;

   /**
    * declares the visibility characters.
    */
   public final static char[] VISIBILITY_CHAR = new char[]
      {'-', '+', '#', '@', '!'};

   /**
    * declares the visibility strings.
    */
   public final static String[] VISIBILITY_STRING = new String[]
      {"private", "public", "protected", "/*package*/", "/*user*/"};

}

/*
 * $Log: UMLDeclarationInterface.java,v $
 * Revision 1.9  2004/10/20 19:51:22  schneider
 * fixed doubled constants - UMLDeclarationInterface deprecated
 *
 */
