/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import de.uni_paderborn.fujaba.metamodel.FDeclaration;
import de.uni_paderborn.fujaba.metamodel.FType;


/**
 * @author    $Author: lowende $
 * @version   $Revision: 1.47 $
 */
public abstract class UMLDeclaration extends UMLDiagramItem implements Cloneable, FDeclaration
{
   /**
    * the default constructor only calls the constructor of UMLDiagramItem.
    */
   public UMLDeclaration()
   {
      super();
   }


   /**
    * @param coobraPersistent
    */
   protected UMLDeclaration (boolean coobraPersistent)
   {
      super (coobraPersistent);
   }


   /**
    * Indicates if the declaration (like class, attribute, method) was parsed from source code.
    */
   private boolean parsed = false;


   /**
    * Indicates if this declaration was parsed from source code.
    *
    * @param parsed  true, if was parsed from source code
    */
   public void setParsed (boolean parsed)
   {
      if (this.parsed != parsed)
      {
         this.parsed = parsed;
         firePropertyChange ("parsed", !parsed, parsed);
      }
   }


   /**
    * Get the parsed attribute of the UMLDeclaration object
    *
    * @return   The parsed value
    */
   public boolean isParsed()
   {
      return this.parsed;
   }


   /**
    * returns the type of the declaration element.
    *
    * @return   the type of the element.
    */
   public abstract UMLType getUMLType();


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int visibility;


   /**
    * Get the visibility attribute of the UMLDeclaration object
    *
    * @return   The visibility value
    */
   public int getVisibility()
   {
      return visibility;
   }


   /**
    * Sets the visibility attribute of the UMLDeclaration object
    *
    * @param visibility  The new visibility value
    */
   public void setVisibility (int visibility)
   {
      if (this.visibility != visibility)
      {
         int oldValue = this.visibility;
         this.visibility = visibility;
         firePropertyChange (VISIBILITY_PROPERTY, oldValue, visibility);
      }
   }


   /**
    * declares the display level of the declaration element.
    */
   private int displayLevel = FDeclaration.DESIGN_DISPLAY_LEVEL;


   /**
    * returns the display level of the declaration element.
    *
    * @return   the display level.
    */
   public int getDisplayLevel()
   {
      return this.displayLevel;
   } // getDisplayLevel


   /**
    * sets the display level of the declaration element.
    *
    * @param newDisplayLevel  the new display level.
    */
   public void setDisplayLevel (int newDisplayLevel)
   {
      if (newDisplayLevel != this.displayLevel)
      {
         int oldDisplayLevel = this.displayLevel;
         this.displayLevel = newDisplayLevel;
         firePropertyChange ("displayLevel", oldDisplayLevel, newDisplayLevel);
      }
   } // setDisplayLevel


   /**
    * Get the fType attribute of the UMLDeclaration object
    *
    * @return       The fType value
    * @see          de.uni_paderborn.fujaba.metamodel.FDeclaration#getFType()
    * @deprecated
    */
   public FType getFType()
   {
      return getUMLType();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeYou()
   {
      super.removeYou();
   }

}

/*
 * $Log: UMLDeclaration.java,v $
 * Revision 1.47  2004/11/14 18:58:28  lowende
 * The code of parsed members of a class is generated in the order they have been read.
 *
 */
