/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.uml;

import java.util.Iterator;

import de.uni_paderborn.fujaba.metamodel.*;
import de.uni_paderborn.fujaba.uml.unparse.UMLUnparseGetter;
import de.upb.tools.fca.FEmptyIterator;
import de.upb.tools.fca.FPropHashSet;
import de.upb.tools.sdm.Path;


/**
 * <h2>Associations</h2> <pre>
 *             +------+ 1                 1
 * UMLTypeList | name +--------------------- UMLType
 *             +------+ revTypes      types
 * </pre>
 *
 * @author    $Author: creckord $
 * @version   $Revision: 1.76.2.1 $
 */
public class UMLBaseTypes extends UMLIncrement implements UMLType, FBaseTypes
{
   // standard basetype names
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String INITIALIZER = "Initializer";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String BOOLEAN = "Boolean";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CHARACTER = "Character";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String STRING = "String";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String INTEGER = "Integer";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String BYTE = "Byte";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String SHORT_INTEGER = "ShortInteger";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String LONG_INTEGER = "LongInteger";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FLOAT = "Float";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DOUBLE = "Double";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String VOID = "Void";
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String CONSTRUCTOR = "constructor";


   /**
    * Constructor for class UMLBaseTypes
    */
   public UMLBaseTypes()
   {
      super();
   }


   /**
    * Constructor for class UMLBaseTypes
    *
    * @param name          No description provided
    * @param progLangType  No description provided
    * @param typeList      No description provided
    */
   public UMLBaseTypes (String name, String progLangType, UMLTypeList typeList)
   {
      super();
      setName (name);
      setProgLangType (progLangType);
      setRevTypes (typeList);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected String createUnparseModuleName()
   {
      return UMLUnparseGetter.getUnparseModuleName (this);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String name;


   /**
    * Get the name attribute of the UMLBaseTypes object
    *
    * @return   The name value
    */
   public String getName()
   {
      return name;
   }


   /**
    * Sets the name attribute of the UMLBaseTypes object
    *
    * @param name  The new name value
    */
   public void setName (String name)
   {
      // HACK: change Constructor to constructor
      if ("Constructor".equals (name))
      {
         name = UMLBaseTypes.CONSTRUCTOR;
      }

      String oldValue = this.name;
      // adjust position in UMLTypeList
      UMLTypeList theTypeList = getRevTypes();

      if (theTypeList != null)
      {
         theTypeList.removeFromTypes (this);
      }

      this.name = name;

      if (theTypeList != null)
      { // FIX ME: this should check for double entries

         theTypeList.addToTypes (this);
      }
      // if the name changes inform all UMLParams
      Iterator methodIter = new Path (this, "revParamType.revParam");
      UMLMethod tmpMethod;
      while (methodIter.hasNext())
      {
         tmpMethod = (UMLMethod) methodIter.next();
         tmpMethod.updateAssocOverFullMethodName();
      }
      firePropertyChange (FElement.NAME_PROPERTY, oldValue, name);
   }


   /**
    * Get the text attribute of the UMLBaseTypes object
    *
    * @return   The text value
    */
   public String getText()
   {
      return getName();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public String toString()
   {
      return getName();
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String progLangType;


   /**
    * Get the progLangType attribute of the UMLBaseTypes object
    *
    * @return   The progLangType value
    */
   public String getProgLangType()
   {
      return progLangType;
   }


   /**
    * Sets the progLangType attribute of the UMLBaseTypes object
    *
    * @param progLangType  The new progLangType value
    */
   public void setProgLangType (String progLangType)
   {
      String oldValue = this.progLangType;
      this.progLangType = progLangType;
      firePropertyChange ("progLangType", oldValue, progLangType);
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient FPropHashSet revAttrType;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevAttrType (FAttr value)
   {
      return  ( (this.revAttrType != null) &&
          (value != null) &&
         this.revAttrType.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevAttrType()
   {
      return  ( (this.revAttrType == null)
         ? FEmptyIterator.get()
         : this.revAttrType.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevAttrType()
   {
      return  ( (this.revAttrType == null)
         ? 0
         : this.revAttrType.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevAttrType (FAttr value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.revAttrType == null)
         {
            this.revAttrType = new FPropHashSet (this, "revAttrType");
         }
         changed = this.revAttrType.add (value);
         if (changed)
         {
            value.setAttrType (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevAttrType (FAttr value)
   {
      boolean changed = false;
      if ( (this.revAttrType != null) &&  (value != null))
      {
         changed = this.revAttrType.remove (value);
         if (changed)
         {
            value.setAttrType ((UMLType) null);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevAttrType()
   {
      UMLAttr tmpValue;
      Iterator iter = this.iteratorOfRevAttrType();
      while (iter.hasNext())
      {
         tmpValue = (UMLAttr) iter.next();
         this.removeFromRevAttrType (tmpValue);
      }
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient FPropHashSet revType;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevType (FQualifier value)
   {
      return  ( (this.revType != null) &&
          (value != null) &&
         this.revType.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevType()
   {
      return  ( (this.revType == null)
         ? FEmptyIterator.get()
         : this.revType.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevType()
   {
      return  ( (this.revType == null)
         ? 0
         : this.revType.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevType (FQualifier value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.revType == null)
         {
            this.revType = new FPropHashSet (this, REV_TYPE_PROPERTY);
         }
         changed = this.revType.add (value);
         if (changed)
         {
            value.setType (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevType (FQualifier value)
   {
      boolean changed = false;
      if ( (this.revType != null) &&  (value != null))
      {
         changed = this.revType.remove (value);
         if (changed)
         {
            value.setType (null);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevType()
   {
      UMLQualifier tmpValue;
      Iterator iter = this.iteratorOfRevType();
      while (iter.hasNext())
      {
         tmpValue = (UMLQualifier) iter.next();
         this.removeFromRevType (tmpValue);
      }
   }

   // ######################################################################
   // interface implementation
   // remember to initialize the variables

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient FPropHashSet revResultType;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevResultType (FMethod value)
   {
      return  ( (this.revResultType != null) &&
          (value != null) &&
         this.revResultType.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevResultType()
   {
      return  ( (this.revResultType == null)
         ? FEmptyIterator.get()
         : this.revResultType.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevResultType()
   {
      return  ( (this.revResultType == null)
         ? 0
         : this.revResultType.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevResultType (FMethod value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.revResultType == null)
         {
            this.revResultType = new FPropHashSet (this, "revResultType");
         }
         changed = this.revResultType.add (value);
         if (changed)
         {
            value.setResultType (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevResultType (FMethod value)
   {
      boolean changed = false;
      if ( (this.revResultType != null) &&  (value != null))
      {
         changed = this.revResultType.remove (value);
         if (changed)
         {
            value.setResultType (null);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevResultType()
   {
      UMLMethod tmpValue;
      Iterator iter = this.iteratorOfRevResultType();
      while (iter.hasNext())
      {
         tmpValue = (UMLMethod) iter.next();
         this.removeFromRevResultType (tmpValue);
      }
   }

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private transient FPropHashSet revParamType;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean hasInRevParamType (FParam value)
   {
      return  ( (this.revParamType != null) &&
          (value != null) &&
         this.revParamType.contains (value));
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public Iterator iteratorOfRevParamType()
   {
      return  ( (this.revParamType == null)
         ? FEmptyIterator.get()
         : this.revParamType.iterator());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public int sizeOfRevParamType()
   {
      return  ( (this.revParamType == null)
         ? 0
         : this.revParamType.size());
   }


   /**
    * Access method for an one to n association.
    *
    * @param value  The object added.
    * @return       No description provided
    */
   public boolean addToRevParamType (FParam value)
   {
      boolean changed = false;
      if (value != null)
      {
         if (this.revParamType == null)
         {
            this.revParamType = new FPropHashSet (this, "revParamType");
         }
         changed = this.revParamType.add (value);
         if (changed)
         {
            value.setParamType (this);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param value  No description provided
    * @return       No description provided
    */
   public boolean removeFromRevParamType (FParam value)
   {
      boolean changed = false;
      if ( (this.revParamType != null) &&  (value != null))
      {
         changed = this.revParamType.remove (value);
         if (changed)
         {
            value.setParamType (null);
         }
      }
      return changed;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void removeAllFromRevParamType()
   {
      UMLParam tmpValue;
      Iterator iter = this.iteratorOfRevParamType();
      while (iter.hasNext())
      {
         tmpValue = (UMLParam) iter.next();
         this.removeFromRevParamType (tmpValue);
      }
   }

   // ######################################################################

   /**
    * <pre>
    *             +------+ 1                 1
    * UMLTypeList | name +--------------------- UMLType
    *             +------+ revTypes      types
    * </pre>
    */
   private transient UMLTypeList revTypes;


   /**
    * Sets the revTypes attribute of the UMLBaseTypes object
    *
    * @param value  The new revTypes value
    * @return       No description provided
    */
   public boolean setRevTypes (FTypeList value)
   {
      boolean changed = false;

      if (this.revTypes != value)
      {
         if (this.revTypes != null)
         {
            UMLTypeList oldValue = this.revTypes;
            this.revTypes = null;
            oldValue.removeFromTypes (this);
         }
         this.revTypes = (UMLTypeList) value;
         if (value != null)
         {
            value.addToTypes (this);
         }
         changed = true;
      }

      return changed;
   }

   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the revTypes attribute of the UMLBaseTypes object
    *
    * @return   The revTypes value
    */
   public UMLTypeList getRevTypes()
   {
      return this.revTypes;
   }


   /**
    * Get the fRevTypes attribute of the UMLBaseTypes object
    *
    * @return   The fRevTypes value
    */
   public FTypeList getFRevTypes()
   {
      return getRevTypes();
   }
   // TODO-END

   // ######################################################################

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private UMLArray revArrayType;


   // TODO-BEGIN: Merge with JDK 1.5
   /**
    * Get the revArrayType attribute of the UMLBaseTypes object
    *
    * @return   The revArrayType value
    */
   public UMLArray getRevArrayType()
   {
      return this.revArrayType;
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FBaseTypes#getFRevArrayType()
    */
   /**
    * Get the fRevArrayType attribute of the UMLBaseTypes object
    *
    * @return   The fRevArrayType value
    */
   public FArray getFRevArrayType()
   {
      return getRevArrayType();
   }
   // TODO-END

   /**
    * Sets the revArrayType attribute of the UMLBaseTypes object
    *
    * @param revArrayType  The new revArrayType value
    */
   public void setRevArrayType (FArray revArrayType)
   {
      if (this.revArrayType != revArrayType)
      {
         // new partner
         UMLArray oldRevArrayType = this.revArrayType;
         if (this.revArrayType != null)
         {
            // inform old partner
            this.revArrayType = null;
            oldRevArrayType.setArrayType (this);
         }
         this.revArrayType = (UMLArray) revArrayType;
         if (revArrayType != null)
         {
            // inform new partner
            revArrayType.setArrayType (this);
         }
         firePropertyChange (REV_ARRAY_TYPE, oldRevArrayType, revArrayType);
      }
   }

   // ######################################################################

   /**
    * Get the realType attribute of the UMLBaseTypes object
    *
    * @return   The realType value
    */
   public UMLType getRealType()
   {
      return this;
   }


   /**
    * Get the dimension attribute of the UMLBaseTypes object
    *
    * @return   The dimension value
    */
   public int getDimension()
   {
      return 0;
   }

   // ######################################################################

   /**
    * Isolates the object so the garbage collector can remove it.
    */
   public void removeYou()
   {
      removeAllFromRevAttrType();
      removeAllFromRevType();
      removeAllFromRevResultType();
      removeAllFromRevParamType();

      setRevTypes (null);
      setRevArrayType (null);

      super.removeYou();
   }


   /**
    * Query the logical parent of this element (e.g. package of a class, diagram of an object).
    *
    * @return   the logical parent of this element;
    */
   public FElement getParentElement()
   {
      //todo: this is a top level object - should it be somewhere else?
      return UMLProject.get();
   }


   /*
    *  (non-Javadoc)
    *  @see de.uni_paderborn.fujaba.metamodel.FType#getFRealType()
    */
   /**
    * Get the fRealType attribute of the UMLBaseTypes object
    *
    * @return   The fRealType value
    */
   public FType getFRealType()
   {
      return getRealType();
   }

}

/*
 * $Log: UMLBaseTypes.java,v $
 * Revision 1.76.2.1  2006/04/27 10:25:50  creckord
 * Changed TreeSets to HashSets - sorted property is not needed and breaks with removeYou() of associated objects (because the compareTo() value changes)
 *
 */
