/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.texteditor;



/**
 * @author    $Author: cschneid $
 * @version   $Revision: 1.4 $ $Date: 2005/02/14 14:28:14 $
 */
public abstract class TextEditor
{
   /**
    * represents a single open file/text in the text editor
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.4 $ $Date: 2005/02/14 14:28:14 $
    */
   public interface Buffer
   {
      /**
       * @param enabled  true to enable syntax highlighting
       */
      void setSyntaxHighlightingEnabled (boolean enabled);


      /**
       * @param line  line of text to be added at the end of the buffer
       */
      void addLine (String line);


      /**
       * @param dirty  true to inform the editor that the text has not been saved, false vice
       *      versa
       */
      void setDirty (boolean dirty);


      /**
       * @param filename  new caption/filename of the buffer
       */
      void setFilename (String filename);


      /**
       * @return   the content of this buffer
       */
      String getText();


      /**
       * show a line in the editor (e.g. to highlight error).
       *
       * @param lineNr  which line to be shown
       */
      void showLine (int lineNr);
   }


   /**
    * listener interface for the owner of a buffer
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.4 $ $Date: 2005/02/14 14:28:14 $
    */
   public interface BufferOwner
   {
      /**
       * called whenever the user chooses to keep the content of the buffer
       *
       * @param buffer  which buffer should be saved
       */
      void bufferSaved (TextEditor.Buffer buffer);
   }


   /**
    * @return   a new buffer that is displayed in this editor
    */
   public Buffer createBuffer()
   {
      return createBuffer (null);
   }


   /**
    * @param owner  owner of the buffer (will be subscribed as listener)
    * @return       a new buffer that is displayed in this editor
    */
   public abstract Buffer createBuffer (BufferOwner owner);


   /**
    * the text editor for Fujaba
    */
   private static TextEditor instance;


   /**
    * @return   the text editor for Fujaba
    */
   public static TextEditor get()
   {
      try
      {
         Class.forName ("de.uni_paderborn.fujaba.texteditor.TextEditorImplementation");
      }
      catch (ClassNotFoundException e)
      {
         //JEdit not found
      }
      if (instance == null)
      {
         instance = new TextEditorMP();
      }
      return instance;
   }


   /**
    * @param implementation  new text editor to be used for Fujaba
    */
   public static void set (TextEditor implementation)
   {
      TextEditor.instance = implementation;
   }
}

/*
 * $Log: TextEditor.java,v $
 * Revision 1.4  2005/02/14 14:28:14  cschneid
 * introduced message view, getParentElement() for FElement, code generation and compiler messages in message view
 *
 */
