/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.sequencer;

import java.util.Iterator;
import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.codegen.*;
import de.upb.tools.fca.FLinkedList;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.30 $
 */
public class Seq extends Flow
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (Seq.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FLinkedList items = new FLinkedList();


   /**
    * Get the items attribute of the Seq object
    *
    * @return   The items value
    */
   public FLinkedList getItems()
   {
      return items;
   } // getItems


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param flow  No description provided
    */
   public void add (Flow flow)
   {
      if (flow instanceof Seq)
      {
         FLinkedList list =  ((Seq) flow).getItems();

         Object obj;
         Iterator tmpIter = list.iterator();

         while (tmpIter.hasNext())
         {
            obj = tmpIter.next();
            // HACK: AZ
            // iter.add (obj); does not work for an empty iterator iter.
            // however, iter is initialized to the end of items
            // Thus, items.add should do the job, too.
            items.add (obj);

            // next line causes trouble and seems not necessary
            // tmpIter.remove ();
         }
      }
      else
      {
         items.add (flow);
      }
   } // add


   /**
    * Get the empty attribute of the Seq object
    *
    * @return   The empty value
    */
   public boolean isEmpty()
   {
      return items.isEmpty();
   } // isEmpty


   /**
    * Get the lastOfItems attribute of the Seq object
    *
    * @return   The lastOfItems value
    */
   public Object getLastOfItems()
   {
      return  ( (this.items.isEmpty() == true)
         ? null
         : this.items.getLast());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param flowActivity  No description provided
    */
   public void removeLastFlowActivity (FlowActivity flowActivity)
   {
      if (!items.isEmpty())
      {
         Flow item = (Flow) getLastOfItems();
         if (item == flowActivity)
         {
            items.removeLast();
         }
         else
         {
            item.removeLastFlowActivity (flowActivity);
         }
      }
   } // removeLastFlowActivity


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param firstToken      No description provided
    * @param lastToken       No description provided
    * @param headExpression  No description provided
    * @return                No description provided
    */
   public OOGenToken generateSourceCode (OOGenToken firstToken, OOGenToken lastToken, OOExpression headExpression)
   {
      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode(" + firstToken + "," + lastToken + ")");
      }

      Flow currentFlow;
      Iterator iter = items.iterator();

      while (iter.hasNext())
      {
         currentFlow = (Flow) iter.next();

         firstToken = currentFlow.generateSourceCode (firstToken, lastToken);
         if (headExpression != null)
         {
            if (headExpression instanceof OOPrefixExpr)
            {
               OOPrefixExpr expr = (OOPrefixExpr) headExpression;
               if (expr.getMyOp() == OOPrefixOp.NOT_OP)
               {
                  headExpression = expr.getMyExpr();
               }
            }
            else
            {
               headExpression = OO.not (headExpression);
            }
            firstToken.appendStatement (OO.ifStat (headExpression));
            firstToken.appendStatement (OO.startBlock());
            firstToken.appendStatement (new OOBreakStatement());
            firstToken.appendStatement (OO.endBlock());
            headExpression = null;
         }
      }

      return firstToken;
   } // generateJava


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param firstToken  No description provided
    * @param lastToken   No description provided
    * @return            No description provided
    */
   public OOGenToken generateSourceCode (OOGenToken firstToken, OOGenToken lastToken)
   {
      if (log.isDebugEnabled())
      {
         log.debug (this + ".generateSourceCode(" + firstToken + "," + lastToken + ")");
      }

      Flow currentFlow;
      Iterator iter = items.iterator();

      while (iter.hasNext())
      {
         currentFlow = (Flow) iter.next();

         firstToken = currentFlow.generateSourceCode (firstToken, lastToken);
      }

      return firstToken;
   } // generateJava


   /**
    * @return   short string representation of current object
    */
   public String toString()
   {
      StringBuffer result = new StringBuffer();

      result.append ("Seq[]");

      return result.toString();
   }

}

/*
 * $Log: Seq.java,v $
 * Revision 1.30  2004/10/20 17:50:09  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
