/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences.gui;

import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

import javax.xml.parsers.SAXParserFactory;

import org.apache.log4j.Logger;
import org.xml.sax.*;
import org.xml.sax.helpers.DefaultHandler;

import de.uni_paderborn.lib.classloader.UPBClassLoader;


/**
 * The ServerListParser parses the PluginServer.xml document to get the
 * URLs for PluginList documents. The PluginDownloadManager scans the
 * document to parse available plug-ins to update and/or download it.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.14.2.1 $
 */
public class ServerListParser extends DefaultHandler
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (ServerListParser.class);

   /**
    * URL used in Plugin definitions (XML-files) to identify the DTD. DTD given as "SYSTEM"
    * (non-public) definition.
    */
   private final static String PLUGIN_SERVER_SYSTEM_ID = "http://www.upb.de/cs/fujaba/DTDs/PluginServer.dtd";

   /**
    * Alternative URL used in Plugin definitions (XML-files) to identify the DTD. DTD given
    * as "SYSTEM" (non-public) definition.
    */
   private final static String PLUGIN_SERVER_SYSTEM_ID2 = "http://www.fujaba.de/DTDs/PluginServer.dtd";

   /**
    * Name used in Plugin definitions (XML-files) to identify the DTD. DTD given as "PUBLIC"
    * definition.
    */
   private final static String PLUGIN_SERVER_PUBLIC_ID = "-//Fujaba//Fujaba Plugin Definition//EN//1.0";

   /**
    */
   private final static String PLUGIN_SERVER_DTD_RESOURCE = "DTDs/PluginServer.dtd";

   /**
    */
   private static URL pluginServerDTD;

   /**
    */
   private final static String PLUGIN_SERVER = "PluginServer";

   /**
    */
   private final static String SERVER_URL = "URL";

   /**
    * State
    */
   private final static int S_NONE = 0;

   /**
    * State
    */
   private final static int S_PLUGIN_SERVER = 1;

   /**
    * State
    */
   private final static int S_URL = 2;

   /**
    */
   private int state = S_NONE;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector urlVector = new Vector();


   /**
    * Constructor for class ServerListParser
    */
   public ServerListParser() { }


   /**
    * Get the pluginProperty attribute of the XMLToPluginProperty object
    *
    * @param xmlURL  No description provided
    * @return        The pluginProperty value
    */
   public Iterator getURLs (URL xmlURL)
   {
      if (parseXML (xmlURL))
      {
         return this.urlVector.iterator();
      }
      else
      {
         return null;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param xmlURL  No description provided
    * @return        No description provided
    */
   public boolean parseXML (URL xmlURL)
   {
      try
      {
         SAXParserFactory factory = SAXParserFactory.newInstance();
         factory.setValidating (true);
         factory.setNamespaceAware (true);

         XMLReader xmlReader = factory.newSAXParser().getXMLReader();
         xmlReader.setContentHandler (this);
         xmlReader.setErrorHandler (this);
         xmlReader.setEntityResolver (this);
         if (xmlURL != null)
         {
            xmlReader.parse (new InputSource (xmlURL.openStream()));
         }
         // if (log.isInfoEnabled()) log.info ("Parsed file: " + xmlFile);
         return true;
      }
      catch (Exception ex)
      {
         System.err.println (ex.getMessage());
         ex.printStackTrace();
         return false;
      }
   }


   /**
    * Method implements interface EntityResolver.
    *
    * @param publicId       No description provided
    * @param systemId       No description provided
    * @return               No description provided
    * @throws SAXException  Exception description not provided
    */
   public InputSource resolveEntity (String publicId, String systemId) throws SAXException
   {
      if (PLUGIN_SERVER_PUBLIC_ID.equals (publicId) ||
         PLUGIN_SERVER_SYSTEM_ID.equals (systemId) ||
         PLUGIN_SERVER_SYSTEM_ID2.equals (systemId))
      {
         if (pluginServerDTD == null)
         {
            pluginServerDTD = UPBClassLoader.get().getResource (PLUGIN_SERVER_DTD_RESOURCE);
         }
         if (pluginServerDTD != null)
         {
            try
            {
               return new InputSource (pluginServerDTD.openStream());
            }
            catch (Exception e)
            {
               if (log.isInfoEnabled())
               {
                  log.info ("Could not solve SYSTEM or PUBLIC reference for DTD.");
               }
               throw new SAXException (e);
            }
         }
      }
      try
      {
         return super.resolveEntity (publicId, systemId);
      }
      catch (Exception ex)
      {
         return null;
      }
   } // resolveEntity


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param uri    No description provided
    * @param name   No description provided
    * @param qName  No description provided
    */
   public void startElement (String uri, String name, String qName)
   {
      try
      {
         if (qName.equals (PLUGIN_SERVER))
         {
            state = S_PLUGIN_SERVER;
         }
         else if (qName.equals (SERVER_URL))
         {
            state = S_URL;
         }
      }
      catch (Exception ex)
      {
         ex.printStackTrace();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param ch      No description provided
    * @param start   No description provided
    * @param length  No description provided
    */
   public void characters (char[] ch, int start, int length)
   {
      String data = new String (ch, start, length);
      urlVector.add (data);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param uri    No description provided
    * @param name   No description provided
    * @param qName  No description provided
    */
   public void endElement (String uri, String name, String qName)
   {
      switch (state)
      {
         case S_PLUGIN_SERVER:
            state = S_NONE;
            break;
         default:
            state = S_NONE;
            break;
      }
   }

}

/*
 * $Log: ServerListParser.java,v $
 * Revision 1.14.2.1  2005/09/30 18:56:56  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
