/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences.gui;

import javax.swing.*;


/**
 * This class provides the generic architecture of the preferences panels. <h2>Associations
 * </h2> <pre>
 *                    1              PreferencesPanel               n
 * PreferencesDialog ------------------------------------------------- PreferencesPanel
 *                    preferencesDialog   {sorted}  preferencesPanels
 * </pre>
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.4 $
 */
public abstract class PreferencesPanel extends JPanel
{
   /**
    * Returns the preferred name of a tab for this panel
    *
    * @return   The preferredTabName value
    */
   public abstract String getPreferredTabName();


   /**
    * Set the options in the panel, because the options could have changed elsewhere.
    */
   public abstract void setPreferences();


   /**
    * Set all options to default values.
    */
   public abstract void setDefaults();


   /**
    * Set all options to default values.
    */
   public void setAllDefaults()
   {
      setDefaults();
   }


   /**
    * Get all the options from the panel and set the real options.
    */
   public abstract void okPressed();


   /**
    * <pre>
    *                    1              PreferencesPanel               n
    * PreferencesDialog ------------------------------------------------- PreferencesPanel
    *                    preferencesDialog   {sorted}  preferencesPanels
    * </pre>
    */
   private PreferencesDialog preferencesDialog;


   /**
    * Get the preferencesDialog attribute of the PreferencesPanel object
    *
    * @return   The preferencesDialog value
    */
   public PreferencesDialog getPreferencesDialog()
   {
      return preferencesDialog;
   }


   /**
    * Sets the preferencesDialog attribute of the PreferencesPanel object
    *
    * @param preferencesDialog  The new preferencesDialog value
    */
   public void setPreferencesDialog (PreferencesDialog preferencesDialog)
   {
      if (this.preferencesDialog != preferencesDialog)
      {
         // newPartner
         if (this.preferencesDialog != null)
         {
            // inform old partner
            PreferencesDialog oldPreferencesDialog = this.preferencesDialog;
            this.preferencesDialog = null;

            oldPreferencesDialog.removeFromPreferencesPanels (this);
         }

         this.preferencesDialog = preferencesDialog;
         if (preferencesDialog != null)
         {
            // inform new partner
            preferencesDialog.addToPreferencesPanels (this);
         }
      }
   }

}

/*
 * $Log: PreferencesPanel.java,v $
 * Revision 1.4  2004/10/20 17:50:08  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
