/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import de.uni_paderborn.fujaba.app.FrameMain;

import de.uni_paderborn.fujaba.preferences.PlugInsPreferences;


/**
 * The options panel for plug-in specific options and settings.
 *
 * @author    $Author: cschneid $
 * @version   $Revision: 1.11 $
 */
public class PlugInsPreferencesPanel extends PreferencesPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JList foldersList;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   StringListModel foldersListModel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JList downloadURLsList;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   StringListModel downloadURLsListModel;


   /**
    * Constructor for class PlugInsPreferencesPanel
    */
   public PlugInsPreferencesPanel()
   {
      setLayout (new BorderLayout());

      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel mainPanel = new JPanel();
      mainPanel.setLayout (gridBagLayout);

      // add plugins folder panel
      JPanel folderPanel = createPluginsFolderPanel();
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.weightx = 1;
      constraints.weighty = 1;
      mainPanel.add (folderPanel, constraints);

      // add plugins download URLs panel
      JPanel editorPanel = createDownloadURLsPanel();
      mainPanel.add (editorPanel, constraints);

      add (mainPanel, BorderLayout.NORTH);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createPluginsFolderPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Plug-in Folders"));
      panel.setLayout (gridBagLayout);

      foldersList = new JList();
      foldersList.setToolTipText ("Fujaba will search for plug-ins in these folders.");
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.BOTH;
      constraints.insets = new Insets (3, 4, 3, 4);
      constraints.weightx = 1;
      constraints.weighty = 1;

      JScrollPane scrollPane = new JScrollPane (foldersList);
      panel.add (scrollPane, constraints);

      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout (new FlowLayout (FlowLayout.LEFT));

      JButton addButton = new JButton ("Add");
      addButton.setToolTipText ("Add a new plug-in folder.");
      addButton.addActionListener (new AddFolderButtonListener());
      buttonPanel.add (addButton);

      JButton editButton = new JButton ("Edit");
      editButton.setToolTipText ("Edit the selected plug-in folder.");
      editButton.addActionListener (new EditFolderButtonListener());
      buttonPanel.add (editButton);

      JButton removeButton = new JButton ("Remove");
      removeButton.setToolTipText ("Remove the selected plug-in folders.");
      removeButton.addActionListener (new RemoveButtonListener (foldersList));
      buttonPanel.add (removeButton);

      constraints.insets = new Insets (0, 0, 0, 0);
      constraints.weighty = 0;
      panel.add (buttonPanel, constraints);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createDownloadURLsPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Plug-in Download URLs"));
      panel.setLayout (gridBagLayout);

      downloadURLsList = new JList();
      downloadURLsList.setToolTipText ("URLs for downloading plug-ins for Fujaba.");
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.BOTH;
      constraints.insets = new Insets (3, 4, 3, 4);
      constraints.weightx = 1;
      constraints.weighty = 1;

      JScrollPane scrollPane = new JScrollPane (downloadURLsList);
      panel.add (scrollPane, constraints);

      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout (new FlowLayout (FlowLayout.LEFT));

      JButton addButton = new JButton ("Add");
      addButton.setToolTipText ("Add a new server URL for downloading plug-ins.");
      addButton.addActionListener (new AddURLButtonListener());
      buttonPanel.add (addButton);

      JButton retrieveButton = new JButton ("Retrieve List");
      retrieveButton.setToolTipText ("Retrieve a list of available plug-in server URLs from Fujaba's homepage.");
      retrieveButton.addActionListener (new RetrieveURLsButtonListener());
      buttonPanel.add (retrieveButton);

      JButton editButton = new JButton ("Edit");
      editButton.setToolTipText ("Edit the selected server URL.");
      editButton.addActionListener (new EditURLButtonListener());
      buttonPanel.add (editButton);

      JButton removeButton = new JButton ("Remove");
      removeButton.setToolTipText ("Remove the selected server URLs.");
      removeButton.addActionListener (new RemoveButtonListener (downloadURLsList));
      buttonPanel.add (removeButton);

      constraints.insets = new Insets (0, 0, 0, 0);
      constraints.weighty = 0;
      panel.add (buttonPanel, constraints);

      return panel;
   }


   /**
    * @return   The preferredTabName value
    * @see      de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel#getPreferredTabName()
    */
   public String getPreferredTabName()
   {
      return "Plug-Ins";
   }


   /**
    * @see   de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel#setPreferences()
    */
   public void setPreferences()
   {
      PlugInsPreferences preferences = PlugInsPreferences.get();

      Vector folders = preferences.getPluginFolders();
      foldersListModel = new StringListModel (folders);
      foldersList.setModel (foldersListModel);

      Vector downloadURLs = preferences.getPluginDownloadURLs();
      downloadURLsListModel = new StringListModel (downloadURLs);
      downloadURLsList.setModel (downloadURLsListModel);
   }


   /**
    * @see   de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel#setDefaults()
    */
   public void setDefaults()
   {
      PlugInsPreferences.get().setDefaults();
      setPreferences();
   }


   /**
    * @see   de.uni_paderborn.fujaba.preferences.gui.PreferencesPanel#okPressed()
    */
   public void okPressed()
   {
      PlugInsPreferences preferences = PlugInsPreferences.get();

      preferences.setPluginFolders (foldersListModel.getStrings());
      preferences.setPluginDownloadURLs (downloadURLsListModel.getStrings());
   }


   // some inner classes

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.11 $
    */
   private class StringListModel extends AbstractListModel
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private Vector strings;


      /**
       * Constructor for class StringListModel
       *
       * @param str  No description provided
       */
      public StringListModel (Vector str)
      {
         this.strings = str;
      }


      /**
       * Get the strings attribute of the StringListModel object
       *
       * @return   The strings value
       */
      public Vector getStrings()
      {
         return this.strings;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param newString  No description provided
       */
      public void add (String newString)
      {
         if (!strings.contains (newString))
         {
            this.strings.add (newString);
            fireIntervalAdded (this, strings.indexOf (newString), strings.indexOf (newString));
         }
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param oldString  No description provided
       */
      public void remove (String oldString)
      {
         if (strings.contains (oldString))
         {
            this.strings.remove (oldString);
            fireIntervalRemoved (this, 0, strings.size());
         }
      }


      /**
       * @return   The size value
       * @see      javax.swing.ListModel#getSize()
       */
      public int getSize()
      {
         return this.strings.size();
      }


      /**
       * @param index  No description provided
       * @return       The elementAt value
       * @see          javax.swing.ListModel#getElementAt(int)
       */
      public Object getElementAt (int index)
      {
         return this.strings.elementAt (index);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.11 $
    */
   private class AddFolderButtonListener implements ActionListener
   {
      /**
       * @param event  No description provided
       * @see          java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
       */
      public void actionPerformed (ActionEvent event)
      {
         JFileChooser chooser = new JFileChooser (".");
         chooser.setFileSelectionMode (JFileChooser.DIRECTORIES_ONLY);

         int returnVal = chooser.showDialog (PlugInsPreferencesPanel.this, "Choose Directory");
         if (returnVal == JFileChooser.APPROVE_OPTION)
         {
            try
            {
               foldersListModel.add (chooser.getSelectedFile().getCanonicalPath());
            }
            catch (IOException e)
            {
               e.printStackTrace();
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.11 $
    */
   private class EditFolderButtonListener implements ActionListener
   {
      /**
       * @param event  No description provided
       * @see          java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
       */
      public void actionPerformed (ActionEvent event)
      {
         String oldFolder = (String) foldersList.getSelectedValue();
         if (oldFolder != null)
         {
            JFileChooser chooser = new JFileChooser (oldFolder);
            chooser.setFileSelectionMode (JFileChooser.DIRECTORIES_ONLY);

            int returnVal = chooser.showDialog (PlugInsPreferencesPanel.this, "Choose Directory");
            if (returnVal == JFileChooser.APPROVE_OPTION)
            {
               try
               {
                  foldersListModel.remove (oldFolder);
                  foldersListModel.add (chooser.getSelectedFile().getCanonicalPath());
               }
               catch (IOException e)
               {
                  e.printStackTrace();
               }
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.11 $
    */
   private class RemoveButtonListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private JList list;


      /**
       * Constructor for class RemoveButtonListener
       *
       * @param list  No description provided
       */
      public RemoveButtonListener (JList list)
      {
         this.list = list;
      }


      /**
       * @param event  No description provided
       * @see          java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
       */
      public void actionPerformed (ActionEvent event)
      {
         Object[] selectedValues = list.getSelectedValues();
         for (int i = 0; i < selectedValues.length; i++)
         {
            String str = (String) selectedValues[i];
            StringListModel listModel = (StringListModel) list.getModel();
            listModel.remove (str);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.11 $
    */
   private class AddURLButtonListener implements ActionListener
   {
      /**
       * @param event  No description provided
       * @see          java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
       */
      public void actionPerformed (ActionEvent event)
      {
         String newURL = JOptionPane.showInputDialog (PlugInsPreferencesPanel.this, "Add a new download URL:");
         if (newURL != null && newURL.trim().length() != 0)
         {
            downloadURLsListModel.add (newURL);
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.11 $
    */
   private class EditURLButtonListener implements ActionListener
   {
      /**
       * @param event  No description provided
       * @see          java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
       */
      public void actionPerformed (ActionEvent event)
      {
         String oldURL = (String) downloadURLsList.getSelectedValue();
         if (oldURL != null)
         {
            String newURL = JOptionPane.showInputDialog (PlugInsPreferencesPanel.this, "Edit the download URL:", oldURL);
            if (newURL != null && newURL.trim().length() != 0)
            {
               downloadURLsListModel.remove (oldURL);
               downloadURLsListModel.add (newURL);
            }
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: cschneid $
    * @version   $Revision: 1.11 $
    */
   private class RetrieveURLsButtonListener implements ActionListener
   {
      /**
       * @param event  No description provided
       * @see          java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
       */
      public void actionPerformed (ActionEvent event)
      {
         String downloadURL = null;
         try
         {
            ServerListParser serverListParser = new ServerListParser();
            Iterator urlIter = serverListParser.getURLs (new URL (PlugInsPreferences.PLUGIN_SERVER_LIST));
            if (urlIter != null)
            {
               while (urlIter.hasNext())
               {
                  downloadURL = (String) urlIter.next();
                  downloadURLsListModel.add (downloadURL);
               }
            }
            else
            {
               JOptionPane.showMessageDialog (FrameMain.get(), "An error occurred while retrieving the server list." +
                  " Are you connected to the Internet? Consult the console for a more detailed message.", "Error", JOptionPane.ERROR_MESSAGE);
            }
         }
         catch (Exception ex)
         {
            ex.printStackTrace();
         }
      }
   }

}

/*
 * $Log: PlugInsPreferencesPanel.java,v $
 * Revision 1.11  2005/03/08 09:49:33  cschneid
 * plugins server list downloaded if empty (empty by default)
 *
 */
