/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import de.uni_paderborn.fujaba.preferences.IconsPreferences;
import de.uni_paderborn.lib.basic.ImageResourceManager;
import de.uni_paderborn.lib.classloader.UPBClassLoader;
import de.uni_paderborn.lib.java.io.FileComparator;
import de.uni_paderborn.lib.java.io.GIFJPGFileFilter;
import de.upb.tools.fca.FCollections;
import de.upb.tools.fca.FLinkedList;


/**
 * Options panel for specifying icons.
 *
 * @author    $Author: trinet $
 * @version   $Revision: 1.6 $
 */
public class IconsPreferencesPanel extends PreferencesPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String tabName;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String key;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Hashtable correlation;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox chooserComboBox;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField iconTextField;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   ImagePreview imagePreview;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField dirLabel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JList iconList;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   FilesListModel filesListModel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   File currentDir;


   /**
    * Constructor for class IconsPreferencesPanel
    *
    * @param tabName  No description provided
    * @param key      No description provided
    */
   public IconsPreferencesPanel (String tabName, String key)
   {
      this.tabName = tabName;
      this.key = key;

      iconTextField = new JTextField (25);
      iconTextField.setEditable (false);

      IconsPreferences options = IconsPreferences.get();

      correlation = options.getHashtableItem (key);

      currentDir = new File (options.getCurrentDir (key));
      if (!currentDir.isDirectory())
      {
         currentDir = new File (System.getProperty ("user.home"));
      }

      dirLabel = new JTextField (currentDir.getPath(), 25);
      dirLabel.setEditable (false);

      filesListModel = new FilesListModel();
      imagePreview = new ImagePreview();
      iconList = new JList (filesListModel);

      chooserComboBox = new JComboBox();
      chooserComboBox.addActionListener (new ComboBoxListener());
      Enumeration enumeration = correlation.keys();
      while (enumeration.hasMoreElements())
      {
         chooserComboBox.addItem (enumeration.nextElement());
      }

      setLayout (new GridLayout (0, 2));

      JPanel leftPanel = createLeftPanel();
      add (leftPanel);

      JPanel rightPanel = createRightPanel();
      add (rightPanel);
   } // constructor


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected JPanel createLeftPanel()
   {
      JPanel panel = new JPanel();

      GridBagLayout gridBag = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();
      panel.setLayout (gridBag);

      JPanel chooserPanel = new JPanel();
      chooserPanel.setBorder (new TitledBorder ("Current settings"));
      chooserPanel.setLayout (new GridLayout (2, 0));
      chooserPanel.add (chooserComboBox);
      chooserPanel.add (iconTextField);

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.BOTH;
      gridBag.setConstraints (chooserPanel, constraints);
      panel.add (chooserPanel);

      JPanel iconPanel = new JPanel();
      iconPanel.setLayout (new BorderLayout());
      iconPanel.setBorder (new TitledBorder ("Current selected image"));
      iconPanel.add (BorderLayout.CENTER, imagePreview);
      constraints.weightx = 1.0;
      constraints.weighty = 1.0;
      gridBag.setConstraints (iconPanel, constraints);
      panel.add (iconPanel);

      return panel;
   } // createLeftPanel


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   protected JPanel createRightPanel()
   {
      JPanel panel = new JPanel();

      GridBagLayout gridBag = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();
      panel.setLayout (gridBag);

      iconList.addListSelectionListener (imagePreview);

      JScrollPane listScrollPane = new JScrollPane();
      listScrollPane.getViewport().setScrollMode (JViewport.BACKINGSTORE_SCROLL_MODE);
      listScrollPane.getViewport().add (iconList);

      JPanel listPanel = new JPanel();
      listPanel.setLayout (new BorderLayout());
      listPanel.setBorder (new TitledBorder ("Directory listing"));
      listPanel.add (dirLabel, BorderLayout.NORTH);
      listPanel.add (listScrollPane, BorderLayout.CENTER);

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.BOTH;
      constraints.weightx = 1.0;
      constraints.weighty = 1.0;
      gridBag.setConstraints (listPanel, constraints);
      panel.add (listPanel);

      JButton dirButton = new JButton ("Change directory");
      dirButton.addActionListener (new DirButtonListener());
      constraints.weightx = 0.0;
      constraints.weighty = 0.0;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      gridBag.setConstraints (dirButton, constraints);
      panel.add (dirButton);

      JPanel buttonPanel = new JPanel();
      buttonPanel.setLayout (new GridLayout (0, 2));

      JButton setButton = new JButton ("Set icon");
      setButton.addActionListener (new SetButtonListener());
      buttonPanel.add (setButton);

      JButton removeButton = new JButton ("Remove icon");
      removeButton.addActionListener (new RemoveButtonListener());
      buttonPanel.add (removeButton);

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      gridBag.setConstraints (buttonPanel, constraints);
      panel.add (buttonPanel);

      return panel;
   } // createRightPanel


   /**
    * Returns the preferred name of a tab for this panel
    *
    * @return   The preferredTabName value
    */
   public String getPreferredTabName()
   {
      return tabName;
   } // getPreferredTabName


   /**
    * Set all options to default values.
    */
   public void setDefaults()
   {
      IconsPreferences.get().setDefaults();
      setPreferences();
   } // setDefaults


   /**
    * Set the options in the panel, because the options can have changed elsewhere.
    */
   public void setPreferences()
   {
      IconsPreferences options = IconsPreferences.get();

      correlation = options.getHashtableItem (key);
      currentDir = new File (options.getCurrentDir (key));
      if (!currentDir.isDirectory())
      {
         currentDir = new File (System.getProperty ("user.home"));
      }

      dirLabel.setText (currentDir.getPath());

      Object item = chooserComboBox.getSelectedItem();
      if (item != null)
      {
         String iconName = (String) correlation.get (item.toString());
         if (iconName != null &&
            !iconName.equals (IconsPreferences.NO_ENTRY))
         {
            iconTextField.setText (iconName);
         }
      }
   } // setOptions


   /**
    * Get all the options from the panel and set the real options.
    */
   public void okPressed()
   {
      IconsPreferences options = IconsPreferences.get();

      // remove all keys with entry NO_ENTRY from hashtable correlation
      Enumeration enumeration = correlation.keys();
      while (enumeration.hasMoreElements())
      {
         Object tmpKey = enumeration.nextElement();
         if (correlation.get (tmpKey).equals (IconsPreferences.NO_ENTRY))
         {
            correlation.remove (tmpKey);
         }
      }

      options.putHashtableItem (key, correlation);
      options.setCurrentDir (key, currentDir.toString());
   } // okPressed

   // ********************** Some inner classes **************************************

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: trinet $
    * @version   $Revision: 1.6 $
    */
   private class DirButtonListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         JFileChooser fileChooser = new JFileChooser (currentDir);
         fileChooser.setFileSelectionMode (JFileChooser.DIRECTORIES_ONLY);
         int value = fileChooser.showDialog (null, "Choose directory");
         if (value == JFileChooser.APPROVE_OPTION)
         {
            File dir = fileChooser.getSelectedFile();
            if (dir.isDirectory())
            {
               currentDir = dir;
               filesListModel.update();
            }
         }
      } // actionPerformed

   } // DirButtonListener


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: trinet $
    * @version   $Revision: 1.6 $
    */
   private class FilesListModel extends AbstractListModel
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private FLinkedList files = new FLinkedList();


      /**
       * Constructor for class FilesListModel
       */
      public FilesListModel()
      {
         update();
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      public void update()
      {
         GIFJPGFileFilter filter = GIFJPGFileFilter.get();
         File[] fileArray = currentDir.listFiles (filter);

         if (fileArray != null &&
            fileArray.length > 0)
         {
            files = new FLinkedList (fileArray);

            FCollections.sort (files, FileComparator.get());
            dirLabel.setText (currentDir.getPath());

         } // end of if ()
         else
         {
            if (files != null)
            {
               files.clear();
            } // end of if ()

            dirLabel.setText ("");
         } // end of else
         dirLabel.validate();
         fireContentsChanged (this, 0, getSize());

      } // update


      /**
       * Get the elementAt attribute of the FilesListModel object
       *
       * @param index  No description provided
       * @return       The elementAt value
       */
      public Object getElementAt (int index)
      {
         return files.get (index);
      } // getElementAt


      /**
       * Get the size attribute of the FilesListModel object
       *
       * @return   The size value
       */
      public int getSize()
      {
         return files.size();
      } // getSize

   } // MethodListModel


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: trinet $
    * @version   $Revision: 1.6 $
    */
   private class ImagePreview extends JComponent implements ListSelectionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private ImageIcon thumbnail;
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private String pathName;


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      public void loadImage()
      {
         if ( (pathName != null) &&  (!pathName.equals (IconsPreferences.NO_ENTRY)))
         {
            thumbnail = ImageResourceManager.get().getImageIcon (UPBClassLoader.DEFAULT_CLASSLOADER, pathName);

            if ( (thumbnail != null) &&
                ( (thumbnail.getIconWidth() > this.getSize().width) ||
                (thumbnail.getIconHeight() > this.getSize().height)))
            {
               if (thumbnail.getIconWidth() > thumbnail.getIconHeight())
               {
                  thumbnail = new ImageIcon (thumbnail.getImage().
                     getScaledInstance (this.getSize().width,
                     -1, Image.SCALE_DEFAULT));
               }
               else
               {
                  thumbnail = new ImageIcon (thumbnail.getImage().
                     getScaledInstance (-1, this.getSize().height,
                     Image.SCALE_DEFAULT));
               }
            }
         }
      } // loadImage


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param pathName  No description provided
       */
      public void valueChanged (String pathName)
      {
         this.pathName = pathName;

         if (this.isShowing())
         {
            loadImage();
            this.repaint();
         }
      } // valueChanged


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void valueChanged (ListSelectionEvent e)
      {
         JList list = (JList) e.getSource();

         if (list.getSelectedValue() == null)
         {
            return;
         }

         pathName =  ((File) list.getSelectedValue()).getAbsolutePath();

         if (this.isShowing())
         {
            loadImage();
            this.repaint();
         }
      } // valueChanged


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param g  No description provided
       */
      public void paint (Graphics g)
      {
         if (thumbnail == null)
         {
            loadImage();
         }
         if (thumbnail != null)
         {
            int x = this.getInsets().left +
                (this.getWidth() - this.getInsets().left
               - this.getInsets().right - thumbnail.getIconWidth()) / 2;
            int y = this.getInsets().top +
                (this.getHeight() - this.getInsets().top
               - this.getInsets().bottom - thumbnail.getIconHeight()) / 2;

            thumbnail.paintIcon (this, g, x, y);
         }
      } // paint

   } // MethodListModel


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: trinet $
    * @version   $Revision: 1.6 $
    */
   private class ComboBoxListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         JComboBox comboBox = (JComboBox) e.getSource();
         String iconName = (String) correlation.get (comboBox.getSelectedItem().toString());
         if (!iconName.equals (IconsPreferences.NO_ENTRY))
         {
            iconTextField.setText (iconName);
         }
         else
         {
            iconTextField.setText ("");
         }
         imagePreview.valueChanged (iconName);
         iconList.clearSelection();
      } // actionPerformed

   } // ComboBoxListener


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: trinet $
    * @version   $Revision: 1.6 $
    */
   private class SetButtonListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         File selectedIcon = (File) iconList.getSelectedValue();
         if (selectedIcon != null)
         {
            String pathName = selectedIcon.getAbsolutePath();
            Object item = chooserComboBox.getSelectedItem();
            if (item != null)
            {
               correlation.put (item.toString(), pathName);
               iconTextField.setText (pathName);
            }
         }
      } // actionPerformed

   } // SetButtonListener


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: trinet $
    * @version   $Revision: 1.6 $
    */
   private class RemoveButtonListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         Object item = chooserComboBox.getSelectedItem();
         if (item != null)
         {
            correlation.put (item.toString(), IconsPreferences.NO_ENTRY);
            iconTextField.setText ("");
         }
      } // actionPerformed

   } // SetButtonListener

}

/*
 * $Log: IconsPreferencesPanel.java,v $
 * Revision 1.6  2004/11/08 19:16:18  trinet
 * changed saving of FSAProperties, added String support for Maps in BasicIncrement, some cleanup
 *
 */
