/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences.gui;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.preferences.GeneralPreferences;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.21 $
 */
public class GeneralPreferencesPanel extends PreferencesPanel
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField workspaceTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField viewFilterTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField jdkTextField;
   /**
    * check to ignore jdk missing/wrong
    */
   private JCheckBox jdkIgnored;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox externalEditorCheckBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField externalEditorTextField;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JButton extEditorBrowseButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JTextField tmpDirTextField;
   /**
    * for versioning repository
    */
   JCheckBox repositoryCheckBox;
   /**
    * allow save as FPR
    */
   JCheckBox fprSaveCheckBox;
   /**
    * for recover mechanism
    */
   JCheckBox recoverCheckBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox createBackupCheckBox;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton workspaceRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton projectRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JRadioButton tmpDirRadioButton;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JCheckBox parseCommandLinesCheckBox;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private JComboBox lookAndFeelComboBox;


   /**
    * Constructor for class GeneralPreferencesPanel
    */
   public GeneralPreferencesPanel()
   {
      setLayout (new BorderLayout());

      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel mainPanel = new JPanel();
      mainPanel.setLayout (gridBagLayout);

      // add folder panel
      JPanel folderPanel = createFolderPanel();
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.BOTH;
      constraints.weightx = 1;
      mainPanel.add (folderPanel, constraints);

      // add editorPanel
      JPanel editorPanel = createEditorPanel();
      mainPanel.add (editorPanel, constraints);

      // add projects panel
      JPanel projectsPanel = createProjectPanel();
      constraints.gridwidth = GridBagConstraints.RELATIVE;
      mainPanel.add (projectsPanel, constraints);

      // add exportFolder panel
      JPanel exportFolderPanel = createExportFolderPanel();
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      mainPanel.add (exportFolderPanel, constraints);

      // add process panel
      JPanel processPanel = createProcessPanel();
      mainPanel.add (processPanel, constraints);

      // add look and feel panel
      JPanel lafPanel = createLookAndFeelPanel();
      mainPanel.add (lafPanel, constraints);

      add (mainPanel, BorderLayout.NORTH);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createFolderPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Folder"));
      panel.setLayout (gridBagLayout);

      // workspace folder
      JLabel workspaceLabel = new JLabel ("Workspace:");
      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.insets = new Insets (3, 3, 3, 3);
      constraints.weightx = 0;
      constraints.gridx = 0;
      constraints.gridy = 0;
      panel.add (workspaceLabel, constraints);

      workspaceTextField = new JTextField();
      workspaceTextField.setToolTipText ("This folder will be used for import/export of source files.");
      constraints.insets = new Insets (0, 3, 3, 0);
      constraints.weightx = 1;
      constraints.gridx = 1;
      panel.add (workspaceTextField, constraints);

      JButton browseButton = new JButton ("Browse");
      browseButton.addActionListener (new BrowseButtonListener (workspaceTextField, JFileChooser.DIRECTORIES_ONLY));
      constraints.insets = new Insets (0, 3, 3, 0);
      constraints.gridwidth = 1;
      constraints.weightx = 0;
      constraints.gridx = 3;
      panel.add (browseButton, constraints);

      // temporary data folder
      JLabel tmpDirLabel = new JLabel ("Temporary Data:");
      constraints.insets = new Insets (3, 3, 3, 3);
      constraints.gridx = 0;
      constraints.gridy = 1;
      panel.add (tmpDirLabel, constraints);

      tmpDirTextField = new JTextField();
      tmpDirTextField.setToolTipText ("This folder will be used to save temporary data.");
      constraints.insets = new Insets (0, 3, 3, 0);
      constraints.weightx = 1;
      constraints.gridx = 1;
      panel.add (tmpDirTextField, constraints);

      browseButton = new JButton ("Browse");
      browseButton.addActionListener (new BrowseButtonListener (tmpDirTextField, JFileChooser.DIRECTORIES_ONLY));
      constraints.insets = new Insets (0, 3, 3, 0);
      constraints.weightx = 0;
      constraints.gridx = 3;
      panel.add (browseButton, constraints);

      // views filter folder
      JLabel viewFilterLabel = new JLabel ("Views Filter:");
      constraints.insets = new Insets (3, 3, 3, 3);
      constraints.gridx = 0;
      constraints.gridy = 2;
      panel.add (viewFilterLabel, constraints);

      viewFilterTextField = new JTextField();
      viewFilterTextField.setToolTipText ("This folder contains the diagram view filters.");
      constraints.insets = new Insets (0, 3, 3, 0);
      constraints.weightx = 1;
      constraints.gridx = 1;
      panel.add (viewFilterTextField, constraints);

      browseButton = new JButton ("Browse");
      browseButton.addActionListener (new BrowseButtonListener (viewFilterTextField, JFileChooser.DIRECTORIES_ONLY));
      constraints.weightx = 0;
      constraints.gridx = 3;
      panel.add (browseButton, constraints);

      // JDK folder
      JLabel jdkLabel = new JLabel ("JDK:");
      constraints.insets = new Insets (3, 3, 3, 3);
      constraints.gridx = 0;
      constraints.gridy = 3;
      panel.add (jdkLabel, constraints);

      jdkTextField = new JTextField();
      jdkTextField.setToolTipText ("This folder contains your JDK.");
      constraints.insets = new Insets (0, 3, 3, 0);
      constraints.weightx = 1;
      constraints.gridx = 1;
      panel.add (jdkTextField, constraints);

      browseButton = new JButton ("Browse");
      browseButton.addActionListener (new BrowseButtonListener (jdkTextField, JFileChooser.DIRECTORIES_ONLY));
      constraints.weightx = 0;
      constraints.gridx = 3;
      panel.add (browseButton, constraints);

      // JDK ignore
      JLabel jdkIgnoreLabel = new JLabel ("");
      constraints.insets = new Insets (3, 3, 3, 3);
      constraints.gridx = 0;
      constraints.gridy = 4;
      panel.add (jdkIgnoreLabel, constraints);

      jdkIgnored = new JCheckBox ("Ignore missing/wrong JDK");
      jdkIgnored.setToolTipText ("If checked no dialog will be raised to ask for a correct JDK.");
      constraints.insets = new Insets (0, 3, 3, 0);
      constraints.weightx = 1;
      constraints.gridx = 1;
      panel.add (jdkIgnored, constraints);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createEditorPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Editor"));
      panel.setLayout (gridBagLayout);

      externalEditorCheckBox = new JCheckBox();
      externalEditorCheckBox.addActionListener (new UseExtEditorButtonListener());
      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridx = 0;
      constraints.gridy = 0;
      constraints.insets = new Insets (3, 3, 0, 1);
      panel.add (externalEditorCheckBox, constraints);

      JLabel useExternalEditorLabel = new JLabel ("Use External Editor");
      constraints.insets = new Insets (3, 0, 0, 0);
      constraints.gridx = 1;
      panel.add (useExternalEditorLabel, constraints);

      JLabel externalEditorLabel = new JLabel ("Editor:");
      constraints.insets = new Insets (3, 0, 0, 0);
      constraints.gridx = 1;
      constraints.gridy = 1;
      panel.add (externalEditorLabel, constraints);

      externalEditorTextField = new JTextField();
      externalEditorTextField.setToolTipText ("This program will be executed as editor.");
      constraints.insets = new Insets (0, 3, 3, 0);
      constraints.weightx = 1;
      constraints.gridx = 2;
      panel.add (externalEditorTextField, constraints);

      extEditorBrowseButton = new JButton ("Browse");
      extEditorBrowseButton.addActionListener (new BrowseButtonListener (externalEditorTextField, JFileChooser.FILES_AND_DIRECTORIES));
      constraints.insets = new Insets (0, 3, 3, 0);
      constraints.weightx = 0;
      constraints.gridx = 3;
      panel.add (extEditorBrowseButton, constraints);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createProjectPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Project"));
      panel.setLayout (gridBagLayout);

      JPanel repositoryPanel = new JPanel();
      repositoryPanel.setLayout (new GridLayout());
      repositoryCheckBox = new JCheckBox ("Activate Versioning Repository");
      repositoryCheckBox.setToolTipText ("Repository will be activated for versioning projects (requires restart)");
      repositoryPanel.add (repositoryCheckBox);

      fprSaveCheckBox = new JCheckBox ("though allow FPR Files");
      fprSaveCheckBox.setToolTipText ("Allow to save as FPR although the versioning repository is activated");
      repositoryPanel.add (fprSaveCheckBox);

      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.fill = GridBagConstraints.HORIZONTAL;
      constraints.anchor = GridBagConstraints.NORTHWEST;
      constraints.insets = new Insets (0, 3, 3, 3);
      constraints.weightx = 1;
      panel.add (repositoryPanel, constraints);

      recoverCheckBox = new JCheckBox ("Activate Auto-Recover");
      recoverCheckBox.setToolTipText ("Auto-Recover enables Fujaba to recover the open project after a program crash");
      repositoryCheckBox.addActionListener (
         new ActionListener()
         {
            /**
             * Invoked when repository is (de)activated
             *
             * @param e  No description provided
             */
            public void actionPerformed (ActionEvent e)
            {
               recoverCheckBox.setEnabled (repositoryCheckBox.isSelected());
               if (!repositoryCheckBox.isSelected())
               {
                  recoverCheckBox.setSelected (false);
               }
               fprSaveCheckBox.setEnabled (repositoryCheckBox.isSelected());
               fprSaveCheckBox.setSelected (!repositoryCheckBox.isSelected());
            }
         });
      panel.add (recoverCheckBox, constraints);

      createBackupCheckBox = new JCheckBox ("Create Backup Files for Project");
      createBackupCheckBox.setToolTipText ("Files will be saved with *.bak.fpr suffix.");
      constraints.insets = new Insets (0, 3, 3, 3);
      constraints.weighty = 1;
      panel.add (createBackupCheckBox, constraints);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createExportFolderPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Export Folder"));
      panel.setLayout (gridBagLayout);

      workspaceRadioButton = new JRadioButton ("Export to Workspace Folder");
      workspaceRadioButton.setToolTipText ("Source code files will be exported to the workspace folder.");
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridwidth = GridBagConstraints.REMAINDER;
      constraints.weightx = 1;
      constraints.insets = new Insets (3, 3, 3, 3);
      panel.add (workspaceRadioButton, constraints);

      projectRadioButton = new JRadioButton ("Export to Project Folder");
      projectRadioButton.setToolTipText ("Source code files will be exported to the project folder.");
      constraints.anchor = GridBagConstraints.WEST;
      constraints.weightx = 1;
      constraints.insets = new Insets (0, 3, 3, 3);
      panel.add (projectRadioButton, constraints);

      tmpDirRadioButton = new JRadioButton ("Export to Temporary Folder");
      tmpDirRadioButton.setToolTipText ("Source code files will be exported to the temporary folder.");
      constraints.anchor = GridBagConstraints.WEST;
      constraints.weightx = 1;
      constraints.insets = new Insets (0, 3, 3, 3);
      panel.add (tmpDirRadioButton, constraints);

      ButtonGroup group = new ButtonGroup();
      group.add (workspaceRadioButton);
      group.add (projectRadioButton);
      group.add (tmpDirRadioButton);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createProcessPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Program Execution"));
      panel.setLayout (gridBagLayout);

      parseCommandLinesCheckBox = new JCheckBox ("Enable Command Line Parsing");
      parseCommandLinesCheckBox.setToolTipText ("Parse the command line for wildcards when starting programs (e.g. Java Compiler).");
      constraints.anchor = GridBagConstraints.WEST;
      constraints.weightx = 1;
      constraints.insets = new Insets (3, 3, 3, 3);
      panel.add (parseCommandLinesCheckBox, constraints);

      return panel;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private JPanel createLookAndFeelPanel()
   {
      GridBagLayout gridBagLayout = new GridBagLayout();
      GridBagConstraints constraints = new GridBagConstraints();

      JPanel panel = new JPanel();
      panel.setBorder (new TitledBorder ("Look & Feel"));
      panel.setLayout (gridBagLayout);

      JLabel lafLabel = new JLabel ("Select Look & Feel:");
      constraints.anchor = GridBagConstraints.WEST;
      constraints.gridwidth = GridBagConstraints.RELATIVE;
      constraints.insets = new Insets (3, 3, 3, 3);
      panel.add (lafLabel, constraints);

      lookAndFeelComboBox = new JComboBox();
      lookAndFeelComboBox.setToolTipText ("Fujaba needs to be restarted for changes to take effect.");
      constraints.insets = new Insets (3, 3, 3, 3);
      constraints.weightx = 1;
      panel.add (lookAndFeelComboBox, constraints);

      return panel;
   }


   /**
    * @return   The preferredTabName value
    * @see      PreferencesPanel#getPreferredTabName()
    */
   public String getPreferredTabName()
   {
      return "General";
   }


   /**
    * @see   PreferencesPanel#setPreferences()
    */
   public void setPreferences()
   {
      GeneralPreferences options = GeneralPreferences.get();

      workspaceTextField.setText (options.getWorkspaceFolder());
      viewFilterTextField.setText (options.getViewFilterFolder());
      tmpDirTextField.setText (options.getTemporaryFolder());
      jdkTextField.setText (options.getJDKFolder());
      jdkIgnored.setSelected (options.isJDKFolderIgnored());

      externalEditorCheckBox.setSelected (options.isUseExtEditor());
      externalEditorTextField.setText (options.getExternalEditor());
      if (!options.isUseExtEditor())
      {
         externalEditorTextField.setEnabled (false);
         extEditorBrowseButton.setEnabled (false);
      }

      repositoryCheckBox.setSelected (options.isRepositoryActivated());
      recoverCheckBox.setSelected (options.isRecoverActivated());
      fprSaveCheckBox.setSelected (options.isFPRActivated());
      createBackupCheckBox.setSelected (options.isCreateProjectBackup());

      workspaceRadioButton.setSelected (options.isExportToWorkspaceFolder());
      projectRadioButton.setSelected (options.isExportToProjectFolder());
      tmpDirRadioButton.setSelected (options.isExportToTemporaryFolder());

      parseCommandLinesCheckBox.setSelected (options.isCommandLineParsing());

      UIManager.LookAndFeelInfo[] installedLaFs = UIManager.getInstalledLookAndFeels();
      for (int i = 0; i < installedLaFs.length; i++)
      {
         lookAndFeelComboBox.addItem (installedLaFs[i].getName());
      }
      lookAndFeelComboBox.setSelectedItem (options.getLookAndFeel());
   }


   /**
    * @see   PreferencesPanel#setDefaults()
    */
   public void setDefaults()
   {
      GeneralPreferences.get().setDefaults();
      setPreferences();
   }


   /**
    * @see   PreferencesPanel#okPressed()
    */
   public void okPressed()
   {
      GeneralPreferences options = GeneralPreferences.get();

      options.setWorkspaceFolder (workspaceTextField.getText());
      options.setViewFilterFolder (viewFilterTextField.getText());
      options.setTemporaryFolder (tmpDirTextField.getText());
      options.setJDKFolder (jdkTextField.getText());
      options.setJDKFolderIgnored (jdkIgnored.isSelected());

      options.setUseExtEditor (externalEditorCheckBox.isSelected());
      options.setExternalEditor (externalEditorTextField.getText());

      options.setRepositoryActivated (repositoryCheckBox.isSelected());
      options.setRecoverActivated (recoverCheckBox.isSelected());
      options.setFPRActivated (fprSaveCheckBox.isSelected());
      options.setCreateProjectBackup (createBackupCheckBox.isSelected());

      options.setExportToWorkspaceFolder (workspaceRadioButton.isSelected());
      options.setExportToProjectFolder (projectRadioButton.isSelected());
      options.setExportToTemporaryFolder (tmpDirRadioButton.isSelected());

      options.setCommandLineParsing (parseCommandLinesCheckBox.isSelected());

      options.setLookAndFeel ((String) lookAndFeelComboBox.getSelectedItem());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.21 $
    */
   private class UseExtEditorButtonListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param event  No description provided
       */
      public void actionPerformed (ActionEvent event)
      {
         JCheckBox checkBox = (JCheckBox) event.getSource();
         boolean enabled = checkBox.isSelected();

         externalEditorTextField.setEnabled (enabled);
         extEditorBrowseButton.setEnabled (enabled);
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @author    $Author: lowende $
    * @version   $Revision: 1.21 $
    */
   private static class BrowseButtonListener implements ActionListener
   {
      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private int selectionMode;

      /**
       * No comment provided by developer, please add a comment to improve documentation.
       */
      private JTextField targetTextField;


      /**
       * Constructor for class BrowseButtonListener
       *
       * @param targetTextField  No description provided
       * @param selectionMode    No description provided
       */
      public BrowseButtonListener (JTextField targetTextField, int selectionMode)
      {
         this.targetTextField = targetTextField;
         this.selectionMode = selectionMode;
      }


      /**
       * No comment provided by developer, please add a comment to improve documentation.
       *
       * @param e  No description provided
       */
      public void actionPerformed (ActionEvent e)
      {
         // create a filechooser
         File file = new File (System.getProperty ("user.dir"), "*.*");
         JFileChooser fileChooser = new JFileChooser (file);
         fileChooser.setFileSelectionMode (selectionMode);

         // open the filechooser
         if (fileChooser.showOpenDialog (FrameMain.get().getFrame()) == JFileChooser.APPROVE_OPTION)
         {
            file = fileChooser.getSelectedFile();
            if (file.exists())
            {
               targetTextField.setText (file.getPath());
            }
         }

      } // actionPerformed
   }
}

/*
 * $Log: GeneralPreferencesPanel.java,v $
 * Revision 1.21  2004/12/02 22:24:32  lowende
 * Inner class set to static.
 *
 */
