/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences.gui;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.TitledBorder;
import de.uni_paderborn.fujaba.app.*;
import de.uni_paderborn.fujaba.codegen.*;
import de.uni_paderborn.fujaba.preferences.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.1.2.1 $ $Date: 2005/08/23 08:24:55 $
 */
public class CodeGenPreferencesPanel extends PreferencesPanel
{
   /**
    *Constructor for class CodeGenPreferencesPanel
    */
   public CodeGenPreferencesPanel()
   {
      setLayout (new BorderLayout());

      JPanel mainPanel = new JPanel();
      mainPanel.setLayout (new PanelColumnLayout());
      mainPanel.setBorder (new TitledBorder ("Select Target Language"));

      Map map = CodeGenPreferences.get().getSelectedCodeGenTargetNames();
      Iterator iter = map.keySet().iterator();
      boxes = new HashMap();
      while (iter.hasNext())
      {
         String target = (String) iter.next();
         JCheckBox box = new JCheckBox (target, false);
         Boolean bool = (Boolean) map.get (target);
         if ( (bool != null) &&  (bool.booleanValue()))
         {
            box.setSelected (true);
         }
         boxes.put (target, box);
         mainPanel.add (box);
      }
      add (mainPanel, BorderLayout.NORTH);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Map boxes;


   /**
    * Returns the preferred name of a tab for this panel
    *
    * @return   The preferredTabName value
    */
   public String getPreferredTabName()
   {
      return "Code Generation";
   }


   /**
    * Get all the options from the panel and set the real options.
    */
   public void okPressed()
   {
      Map map = CodeGenPreferences.get().getSelectedCodeGenTargetNames();
      Iterator iter = map.keySet().iterator();
      while (iter.hasNext())
      {
         String key = (String) iter.next();
         map.put (key, new Boolean (false));
      }
      iter = boxes.keySet().iterator();
      while (iter.hasNext())
      {
         String key = (String) iter.next();
         JCheckBox value = (JCheckBox) boxes.get (key);
         if (value.isSelected())
         {
            map.put (key, new Boolean (true));
            CodeGenFactory.get().setCurrentTarget (key);
         }
      }
      CodeGenPreferences.get().save();
   }


   /**
    * Set all options to default values.
    */
   public void setDefaults()
   {
      CodeGenPreferences.get().setDefaults();
      setPreferences();
   }


   /**
    * Sets the preferences attribute of the CodeGenPreferencesPanel object
    */
   public void setPreferences()
   {
      Map targets = CodeGenPreferences.get().getSelectedCodeGenTargetNames();
      Iterator iter = boxes.keySet().iterator();
      while (iter.hasNext())
      {
         String key = (String) iter.next();
         Boolean selected = (Boolean) targets.get (key);
         if (selected.booleanValue())
         {
            JCheckBox box = (JCheckBox) boxes.get (key);
            box.setSelected (true);
         }
      }
   }

}

/*
 * $Log: CodeGenPreferencesPanel.java,v $
 * Revision 1.1.2.1  2005/08/23 08:24:55  lowende
 * Removed compile warnings.
 *
 */
