/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.Vector;

import de.uni_paderborn.fujaba.app.FujabaApp;



/**
 * @author    alptekin
 * @version   $Revision: 1.9.2.1 $
 */
public class PlugInsPreferences extends AbstractPreferences
{

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PROPERTY_NAME = "PlugIns.";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PLUGIN_SERVER_LIST = "http://www.uni-paderborn.de/cs/fujaba/downloads/plugins/PluginServer.xml";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String FOLDERS = "Folders";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DOWNLOAD_URLS = "DownloadURL";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String DEF_FOLDER;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   //private final static String DEF_DOWNLOAD_URL = "http://www.uni-paderborn.de/cs/fujaba/downloads/plugins/PluginList.xml";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static PlugInsPreferences pluginOptions;

   static
   {
      String defFolder = "./plugins";
      if (FujabaApp.FUJABA_BASE != null)
      {
         try
         {
            URI pluginUri = FujabaApp.FUJABA_BASE.resolve ("plugins");
            defFolder = new File (pluginUri).getPath();
         }
         catch (Exception ex)
         {
         }
      }
      DEF_FOLDER = defFolder;
   }


   /**
    * Constructor for class PluginOptions
    */
   private PlugInsPreferences() { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static synchronized PlugInsPreferences get()
   {
      if (pluginOptions == null)
      {
         pluginOptions = new PlugInsPreferences();
      }

      return pluginOptions;
   }


   /**
    * Sets the defaults attribute of the PluginOptions object
    */
   public void setDefaults()
   {
      PreferencesProperties propertyOptions = PreferencesProperties.get();

      Vector folders = new Vector();
      folders.add (DEF_FOLDER);
      propertyOptions.putSetting (PROPERTY_NAME + FOLDERS, folders);

      Vector downloadURLs = new Vector();
      //downloadURLs.add (DEF_DOWNLOAD_URL);
      propertyOptions.putSetting (PROPERTY_NAME + DOWNLOAD_URLS, downloadURLs);
   }


   // ----------------------------------------------------------------------------
   // property change support
   // ----------------------------------------------------------------------------

   /**
    * Access method for an one to n association.
    *
    * @param propertyName  The object added.
    * @param listener      The object added.
    */
   public void addPropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().addPropertyChangeListener (propertyName, listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param propertyName  No description provided
    * @param listener      No description provided
    */
   public void removePropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().removePropertyChangeListener (propertyName, listener);
   }


   // ----------------------------------------------------------------------------
   // getter and setter for the properties
   // ----------------------------------------------------------------------------


   /**
    * Sets the pluginFolders attribute of the PluginOptions object
    *
    * @param value  The new pluginFolders value
    */
   public void setPluginFolders (Vector value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + FOLDERS, value);
      setModified (true);
   }


   /**
    * Get the pluginFolders attribute of the PluginOptions object
    *
    * @return   The pluginFolders value
    */
   public Vector getPluginFolders()
   {
      Vector defaultVector = new Vector();
      defaultVector.add (DEF_FOLDER);

      return PreferencesProperties.get().getVectorSetting (PROPERTY_NAME + FOLDERS, defaultVector);
   }


   /**
    * Sets the pluginDownloadURLs attribute of the PluginOptions object
    *
    * @param value  The new pluginDownloadURLs value
    */
   public void setPluginDownloadURLs (Vector value)
   {
      PreferencesProperties.get().putSetting (PROPERTY_NAME + DOWNLOAD_URLS, value);
      setModified (true);
   }


   /**
    * Get the pluginDownloadURLs attribute of the PluginOptions object
    *
    * @return   The pluginDownloadURLs value
    */
   public Vector getPluginDownloadURLs()
   {
      Vector defaultVector = new Vector();
      //defaultVector.add (DEF_DOWNLOAD_URL);

      return PreferencesProperties.get().getVectorSetting (PROPERTY_NAME + DOWNLOAD_URLS, defaultVector);
   }

}

/*
 * $Log: PlugInsPreferences.java,v $
 * Revision 1.9.2.1  2005/12/15 15:21:51  creckord
 * - FujabaApp can determine the Fujaba install location now
 * - Template dir and default plugin dir are determined based on install location instead of current dir
 *
 * - UMLCollabStat has an int number for its sequence number now instead of noText
 * - hopefully fixed UMLCollabStats losing/messing up their order and number between save & load
 * - threadId is honored by renumbering methods and GUI
 *
 * - FTreeEnumeration can enumerate elements nested in other elements of target type now
 * - iterator/elementsOfClasses in FProject returns inner classes now, too
 *
 * - UMLClass doesn't lose inner classes anymore (hopefully)
 *
 */
