/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences;

import java.beans.PropertyChangeListener;



/**
 * Contains all options for debugging.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.8 $
 */
public class DebugPreferences extends AbstractPreferences
{
   /**
    * This constant is the properties key for Fujaba's properties.
    */
   public final static String PROPERTY_NAME = "Debug.";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String MODE = "Mode";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String GENERATED = "SaveGenerated";

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String DEBUG_LEVEL = "DebugLevel";

   // some default values
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static boolean DEF_MODE = false;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static boolean DEF_GENERATED = true;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEF_DEBUG_LEVEL = 0;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_SAVELOAD = 1;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_CODEGENERATION = DEBUG_LEVEL_SAVELOAD * 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_DISPLAY = DEBUG_LEVEL_CODEGENERATION * 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_ANALYZING = DEBUG_LEVEL_DISPLAY * 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_UML = DEBUG_LEVEL_ANALYZING * 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_PARSING = DEBUG_LEVEL_UML * 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_GUI = DEBUG_LEVEL_PARSING * 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_REMOVEYOU = DEBUG_LEVEL_GUI * 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_PLUGINS = DEBUG_LEVEL_REMOVEYOU * 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static int DEBUG_LEVEL_ELSE = DEBUG_LEVEL_PLUGINS * 2;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int debugLevel = -1;

   /**
    * The instance of this singleton class. Use OptionsDebug.get() to get an instance of this
    * class.
    *
    * @see   #get
    */
   private static DebugPreferences options;


   /**
    * The <B>private</B> constructor for this class. Use OptionsDebug.get() to get an instance
    * of this class.
    *
    * @see   #get
    */
   protected DebugPreferences() { }


   /**
    * This method provides the user the singleton instance of this class.
    *
    * @return   No description provided
    */
   public static synchronized DebugPreferences get()
   {
      if (options == null)
      {
         options = new DebugPreferences();
      }

      return options;
   } // get


   /**
    * Set the default values for all options.
    */
   public void setDefaults()
   {
      PreferencesProperties options = PreferencesProperties.get();

      options.putSetting (PROPERTY_NAME + MODE, DEF_MODE);
      options.putSetting (PROPERTY_NAME + DEBUG_LEVEL, DEF_DEBUG_LEVEL);
      options.putSetting (PROPERTY_NAME + GENERATED, DEF_GENERATED);
   } // setDefaults


   // ----------------------------------------------------------------------------
   // property change support
   // ----------------------------------------------------------------------------

   /**
    * Access method for an one to n association.
    *
    * @param propertyName  The object added.
    * @param listener      The object added.
    */
   public void addPropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().addPropertyChangeListener (propertyName, listener);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param propertyName  No description provided
    * @param listener      No description provided
    */
   public void removePropertyChangeListener (String propertyName, PropertyChangeListener listener)
   {
      // use default properties for the Fujaba core
      PreferencesProperties.get().removePropertyChangeListener (propertyName, listener);
   }


   // ----------------------------------------------------------------------------
   // getter and setter for the properties
   // ----------------------------------------------------------------------------

   /**
    * Sets the debugMode attribute of the OptionsDebug object
    *
    * @param value  The new debugMode value
    */
   public void setDebugMode (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + MODE, DEF_MODE) != value)
      {
         options.putSetting (PROPERTY_NAME + MODE, value);
         setModified (true);
      }
   } // setDebugMode


   /**
    * Get the debugMode attribute of the OptionsDebug object
    *
    * @return   The debugMode value
    */
   public boolean isDebugMode()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + MODE);
   } // isDebugMode


   /**
    * Sets the saveGenerated attribute of the OptionsDebug object
    *
    * @param value  The new saveGenerated value
    */
   public void setSaveGenerated (boolean value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getBoolSetting (PROPERTY_NAME + GENERATED, DEF_GENERATED) != value)
      {
         options.putSetting (PROPERTY_NAME + GENERATED, value);
         setModified (true);
      }
   } // setSaveGenerated


   /**
    * Get the saveGenerated attribute of the OptionsDebug object
    *
    * @return   The saveGenerated value
    */
   public boolean isSaveGenerated()
   {
      return PreferencesProperties.get().getBoolSetting (PROPERTY_NAME + GENERATED);
   } // isSaveGenerated


   /**
    * Sets the debugLevel attribute of the OptionsDebug object
    *
    * @param value  The new debugLevel value
    */
   public void setDebugLevel (int value)
   {
      PreferencesProperties options = PreferencesProperties.get();
      if (options.getIntSetting (PROPERTY_NAME + DEBUG_LEVEL, DEF_DEBUG_LEVEL) != value)
      {
         options.putSetting (PROPERTY_NAME + DEBUG_LEVEL, value);
         setModified (true);
      }
   }


   /**
    * Get the debugLevel attribute of the OptionsDebug object
    *
    * @return   The debugLevel value
    */
   public int getDebugLevel()
   {
      if (debugLevel < 0)
      {
         debugLevel = PreferencesProperties.get().getIntSetting (PROPERTY_NAME + DEBUG_LEVEL, DEF_DEBUG_LEVEL);
      }

      return debugLevel;
   }


   /**
    * Get the specificDebugLevel attribute of the OptionsDebug object
    *
    * @param value  No description provided
    * @return       The specificDebugLevel value
    */
   public boolean isSpecificDebugLevel (int value)
   {
      return  (getDebugLevel() & value) == value;
   }

}

/*
 * $Log: DebugPreferences.java,v $
 * Revision 1.8  2004/10/20 17:50:07  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
