/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.preferences;

import java.util.*;
import de.uni_paderborn.fujaba.codegen.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.1.2.1 $ $Date: 2005/08/23 08:24:50 $
 */
public class CodeGenPreferences extends AbstractPreferences
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String PROPERTY_PREFIX = "CodeGenTarget.";


   /**
    *Constructor for class CodeGenPreferences
    *
    * @param init  No description provided
    */
   private CodeGenPreferences (boolean init)
   {
      selectedCodeGenTargetNames = new HashMap();
      Vector v = JavaPreferences.get().getCodeGenTargetName();
      for (int i = 0; i < v.size(); i++)
      {
         String target = (String) v.get (i);
         //since there is no difference between code generation MECHANISM between rtjava and java, get rid of the term rtjava.
         if (target.equals ("rtjava"))
         {
            selectedCodeGenTargetNames.put ("java", new Boolean (false));
         }
         else
         {
            selectedCodeGenTargetNames.put (target, new Boolean (false));
         }
      }
      //as long as the java code generation belongs to the Fujaba core...
      selectedCodeGenTargetNames.put ("java", new Boolean (false));

      if (init)
      {
         setDefaults (true);
         load();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Map selectedCodeGenTargetNames;


   /**
    * Get the selectedCodeGenTargetNames attribute of the CodeGenPreferences object
    *
    * @return   The selectedCodeGenTargetNames value
    */
   public Map getSelectedCodeGenTargetNames()
   {
      return selectedCodeGenTargetNames;
   }


   /**
    * Sets the defaults attribute of the AbstractPreferences object
    */
   public void setDefaults()
   {
      setDefaults (false);
   }


   /**
    * Sets the defaults attribute of the AbstractPreferences object
    *
    * @param temporarily  when true save() is not called
    */
   private void setDefaults (boolean temporarily)
   {
      Iterator iter = selectedCodeGenTargetNames.keySet().iterator();
      while (iter.hasNext())
      {
         String key = (String) iter.next();
         selectedCodeGenTargetNames.put (key, new Boolean (false));
      }
      //selectedCodeGenTargetNames.put(JavaPreferences.get().getCodeGenTargetName().get(0), new Boolean(true));

      if (!temporarily)
      {
         save();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void load()
   {
      Iterator iter = selectedCodeGenTargetNames.keySet().iterator();
      boolean success = false;
      while (iter.hasNext())
      {
         String targetName = (String) iter.next();
         boolean bool = PreferencesProperties.get().getBoolSetting (PROPERTY_PREFIX + targetName);
         if (bool)
         {
            success = true;
            selectedCodeGenTargetNames.put (targetName, new Boolean (bool));
         }
      }

      //deprecated
      if (!success)
      {
         Vector defaultTargets = PreferencesProperties.get().getVectorSetting ("Java.CodeGenTargetName");
         for (int i = 0; i < defaultTargets.size(); i++)
         {
            String target = (String) defaultTargets.get (i);
            //since there is no difference between code generation MECHANISM between rtjava and java, get rid of the term rtjava.
            if (target.equals ("rtjava"))
            {
               selectedCodeGenTargetNames.put ("java", new Boolean (true));
            }
            else
            {
               selectedCodeGenTargetNames.put (target, new Boolean (true));
            }
         }
      }

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void save()
   {
      Iterator iter = selectedCodeGenTargetNames.keySet().iterator();
      while (iter.hasNext())
      {
         String targetName = (String) iter.next();
         Boolean bool = (Boolean) selectedCodeGenTargetNames.get (targetName);
         PreferencesProperties.get().putSetting (PROPERTY_PREFIX + targetName, bool.booleanValue());
      }
      PreferencesProperties.get().putSetting ("Java.CodeGenTargetName0", CodeGenFactory.get().getCurrentTarget().getName());
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private static CodeGenPreferences theInstance = null;


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public static CodeGenPreferences get()
   {
      if (theInstance == null)
      {
         theInstance = new CodeGenPreferences (true);
      }

      return theInstance;
   }
}

/*
 * $Log: CodeGenPreferences.java,v $
 * Revision 1.1.2.1  2005/08/23 08:24:50  lowende
 * Removed compile warnings.
 *
 */
