/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.packagediagrams.gui;

import java.util.Enumeration;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;

import de.uni_paderborn.fujaba.app.FrameDecorator;
import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.packagediagrams.PackageDiagram;
import de.uni_paderborn.fujaba.uml.UMLDiagram;
import de.uni_paderborn.fujaba.views.ViewDiagram;
import de.upb.lib.userinterface.UserInterfaceManager;


/**
 * This class handles the change of the user interface, if a diagram was selected.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.17 $
 */
public class FrameDecoratorPackageDiagram extends FrameDecorator
{
   /**
    * Checks wether decorator is responsible for the given diagram. Changes the visibility
    * of menus/toolbars. Called, if diagram is entered.
    *
    * @param diag  No description provided
    */
   public void enterDiagram (ASGDiagram diag)
   {
      setVisibilityOfUserInterface (diag, true);
   } // enterDiagram


   /**
    * Checks wether decorator is responsible for the given diagram. Changes the visibility
    * of menus/toolbars. Called, if diagram is entered.
    *
    * @param diag  No description provided
    */
   public void leaveDiagram (ASGDiagram diag)
   {
      setVisibilityOfUserInterface (diag, false);
   } // leaveDiagram


   /**
    * Sets the visibilityOfUserInterface attribute of the FrameDecoratorPackageDiagram object
    *
    * @param diag     The new visibilityOfUserInterface value
    * @param visible  The new visibilityOfUserInterface value
    */
   private void setVisibilityOfUserInterface (ASGDiagram diag, boolean visible)
   {
      while (diag != null && diag instanceof ViewDiagram)
      {
         diag =  ((ViewDiagram) diag).getDiagram();
      }

      UserInterfaceManager uiManager = UserInterfaceManager.get();
      JMenu menu = uiManager.getFromMenus ("packageDiagramMenu");
      JToolBar toolBar = uiManager.getFromToolBars ("packageDiagramToolBar");

      if (diag != null && diag instanceof PackageDiagram)
      {
         if (menu != null)
         {
            menu.setVisible (visible);
            menu.setEnabled (visible);
         }

         if (toolBar != null)
         {
            if (visible)
            {
               FrameMain.get().getCurrentInternalFrame().addDiagramToolBar (toolBar);
            }
            else
            {
               //FrameMain.get().getInternalFrame (diag).removeDiagramToolBar (toolBar);
            }
         }
      }
   } // setVisibilityOfUserInterface


   /**
    * Get the treeNode attribute of the FrameDecoratorPackageDiagram object
    *
    * @param diagEnum  No description provided
    * @return          The treeNode value
    */
   public DefaultMutableTreeNode getTreeNode (Enumeration diagEnum)
   {
      DefaultMutableTreeNode node = new DefaultMutableTreeNode ("Package diagrams");

      ASGDiagram diag;
      PackageDiagram packageDiag;

      while (diagEnum.hasMoreElements())
      {
         diag = (ASGDiagram) diagEnum.nextElement();

         if (diag instanceof PackageDiagram)
         {
            packageDiag = (PackageDiagram) diag;
            node.add (getTreeNode (packageDiag));
         }
      }
      return node;
   }


   /**
    * Get the treeNode attribute of the FrameDecoratorPackageDiagram object
    *
    * @param diag  No description provided
    * @return      The treeNode value
    */
   public DefaultMutableTreeNode getTreeNode (UMLDiagram diag)
   {
      DefaultMutableTreeNode node = new DefaultMutableTreeNode (diag);

      return node;
   } // getTreeNode

}

/*
 * $Log: FrameDecoratorPackageDiagram.java,v $
 * Revision 1.17  2004/10/20 17:50:03  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
