/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.packagediagrams.actions;

import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

import javax.swing.AbstractAction;

import de.uni_paderborn.fujaba.app.FrameMain;
import de.uni_paderborn.fujaba.asg.ASGDiagram;
import de.uni_paderborn.fujaba.fsa.swing.DiagramKindComboBoxModel;
import de.uni_paderborn.fujaba.packagediagrams.DiagramUsage;
import de.uni_paderborn.fujaba.uml.UMLProject;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: lowende $
 * @version   $Revision: 1.14.2.3 $
 */
public class GoToDiagramAction extends AbstractAction
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {
      Object source = event.getSource();
      if (source instanceof Iterator)
      {
         Iterator iter = (Iterator) source;
         if (iter.hasNext())
         {
            source = iter.next();
         }
      }

      if (source instanceof DiagramUsage)
      {
         try
         {
            DiagramUsage usage = (DiagramUsage) source;
            ASGDiagram diagram = usage.getDiagram();
            if (diagram == null)
            {
               Class diagramKindClass = DiagramKindComboBoxModel.getDiagramKindClass (usage.getDiagramKind());
               if (diagramKindClass != null)
               {
                  try
                  {
                     Constructor constructor = diagramKindClass.getConstructor (new Class[]{String.class, UMLProject.class});
                     diagram = (ASGDiagram) constructor.newInstance (new Object[]{usage.getName(), UMLProject.get()});
                  }
                  catch (NoSuchMethodException e)
                  {
                     throw new RuntimeException ("Class " + diagramKindClass.getName() + " was registed " +
                        "as diagram kind for package diagrams but does not have an appropriate contructor!", e);
                  }
                  catch (IllegalAccessException e)
                  {
                     throw new RuntimeException ("Creation of diagram " + diagramKindClass.getName() + " failed!", e);
                  }
                  catch (InvocationTargetException e)
                  {
                     throw new RuntimeException ("Creation of diagram " + diagramKindClass.getName() + " failed!", e);
                  }
                  catch (InstantiationException e)
                  {
                     throw new RuntimeException ("Creation of diagram " + diagramKindClass.getName() + " failed!", e);
                  }

                  usage.setDiagram (diagram); //Makes a connection between usage and diagram

                  // Updates the project tree.
                  FrameMain.get().createNewTreeItems();
               }
               else
               {
                  throw new RuntimeException ("Type of the package unknown!");
               }

            }
            // Select the item in the project tree.
            FrameMain.get().selectTreeItem (diagram);
            UMLProject.get().refreshDisplay();
         }
         finally
         {
         }
      }
   } // actionPerformed

}

/*
 * $Log: GoToDiagramAction.java,v $
 * Revision 1.14.2.3  2005/08/23 08:24:54  lowende
 * Removed compile warnings.
 *
 */
