/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.io.*;
import java.util.*;

import org.apache.log4j.Logger;

import de.uni_paderborn.fujaba.app.FrameMain;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.26.2.1 $
 */
public class mpEDIT implements EditorInterface
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (mpEDIT.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private ResourceBundle strings;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private PropMan propMan;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Properties props;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector docs;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector beans;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private KeyMap keyMap;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private EditorOwnerInterface editorOwner;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int untitled_count;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Dimension screenDim;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Dimension windowSize;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int windowOffset;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Point lastPlace;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean highlightingEnabled = true;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FrameMain frameMain;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public final static String stringsResourceName = "de.uni_paderborn.fujaba.mpEdit.stringsResourceBundle";

   // constructor puts together UI

   /**
    * Constructor for class mpEDIT
    *
    * @param main  No description provided
    */
   public mpEDIT (FrameMain main)
   {
      init (main);
   }


   /**
    * Constructor for class mpEDIT
    *
    * @param main                 No description provided
    * @param highlightingEnabled  No description provided
    */
   public mpEDIT (FrameMain main, boolean highlightingEnabled)
   {
      setHighlightingEnabled (highlightingEnabled);
      init (main);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param main  No description provided
    */
   private void init (FrameMain main)
   {
      searchPatterns.addElement ("Search1");
      searchPatterns.addElement ("Search2");

      propMan = new PropMan();
      props = propMan.getProperties();

      strings = ResourceBundle.getBundle (stringsResourceName, Locale.getDefault());

      keyMap = new KeyMapStd();

      screenDim = Toolkit.getDefaultToolkit().getScreenSize();

      windowSize = new Dimension (screenDim.width * 2 / 3, screenDim.height * 2 / 3);
      windowOffset = screenDim.height / 21;

      docs = new Vector (5, 5);

      frameMain = main;
   }


   /**
    * Sets the highlightingEnabled attribute of the mpEDIT object
    *
    * @param value  The new highlightingEnabled value
    */
   public void setHighlightingEnabled (boolean value)
   {
      this.highlightingEnabled = value;
   }


   /**
    * Get the highlightingEnabled attribute of the mpEDIT object
    *
    * @return   The highlightingEnabled value
    */
   public boolean getHighlightingEnabled()
   {
      return highlightingEnabled;
   }


   /**
    * Get the owner attribute of the mpEDIT object
    *
    * @return   The owner value
    */
   public EditorOwnerInterface getOwner()
   {
      return editorOwner;
   }


   /**
    * Get the untitled attribute of the mpEDIT object
    *
    * @return   The untitled value
    */
   public int getUntitled()
   {
      return ++untitled_count;
   }


   /**
    * Opens a new, empty, document.
    *
    * @param o  No description provided
    * @return   A DocInterface for the opened document.
    */
   public synchronized DocInterface newDoc (DocOwnerInterface o)
   {
      DocMan doc = (DocMan) newDoc();

      if (doc != null)
      {
         doc.setOwner (o);
      }

      return doc;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   public synchronized DocInterface newDoc()
   {
      DocMan doc = new DocMan (this, strings, props);
      TextFrame textFrame = doc.newFrame (getPlace (windowSize), windowSize);
      doc.setUntitled (++untitled_count);
      textFrame.setVisible (true);
      docs.addElement (doc);
      return doc;
   }


   /**
    * Opens a file dialog, and then the specified file. The current document is used if it
    * is not busy, or else a new editor document is created.
    *
    * @param doc        The current document.
    * @param textFrame  The current textFrame.
    */
   public synchronized void openDocDialog (DocMan doc, TextFrame textFrame)
   {
      boolean newdoc;
      String filename = getFileForOpen (textFrame);

      if (filename != null)
      {
         newdoc = doc.isBusy();

         if (newdoc)
         {
            doc = new DocMan (this, strings, props);
            textFrame = doc.newFrame (getPlace (windowSize), windowSize);
         }
         else
         {
            if (editorOwner != null)
            {
               editorOwner.closingDoc (doc);
            }
            ;
         }

         doc.openDoc (textFrame, filename);

         if (editorOwner != null)
         {
            editorOwner.openedDoc (doc);
         } // notify EditorOwnerInterface

         if (newdoc)
         {
            textFrame.setVisible (true);
            docs.addElement (doc);
         }
      }
   }


   /**
    * Opens a new editor window containing the specified file.
    *
    * @param filename  A full path to a text file to be opened.
    * @param o         No description provided
    * @return          A DocInterface for the opened document.
    */
   public synchronized DocInterface openDoc (DocOwnerInterface o, String filename)
   {
      DocMan doc = (DocMan) openDoc (filename);

      if (doc != null)
      {
         doc.setOwner (o);
      }

      return doc;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param filename  No description provided
    * @return          No description provided
    */
   public synchronized DocInterface openDoc (String filename)
   {
      TextFrame frame;
      DocMan doc = null;
      File file;

      file = new File (filename);

      if (file.isFile())
      {
         doc = new DocMan (this, strings, props);
         frame = doc.newFrame (getPlace (windowSize), windowSize);
         doc.openDoc (frame, filename);
         frame.setVisible (true);
         docs.addElement (doc);
      }
      else
      {
         if (log.isInfoEnabled())
         {
            log.info ("File not found: " + filename);
         }
      }

      return doc;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public synchronized void openOneDoc()
   {
      if (docs.size() == 0)
      {
         newDoc();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param doc  No description provided
    */
   public synchronized void closeDoc (DocMan doc)
   {
      int i;
      int
         max;

      max = docs.size();

      for (i = 0; i < max; i++)
      {
         if (doc == (DocMan) docs.elementAt (i))
         {
            docs.removeElementAt (i);
            max--;
            break;
         }
      }

      if (editorOwner != null)
      {
         editorOwner.closingDoc (doc);
      }

      if (max == 0)
      {
         if (editorOwner != null)
         {
            editorOwner.lastFileClosed();
         }
      } // notify DocOwnerInterface

   }


   /**
    * Get the windowSize attribute of the mpEDIT object
    *
    * @return   The windowSize value
    */
   public Dimension getWindowSize()
   {
      return windowSize;
   }


   /**
    * Get the place attribute of the mpEDIT object
    *
    * @param size  No description provided
    * @return      The place value
    */
   public synchronized Point getPlace (Dimension size)
   {
      Point place = null;

      if (lastPlace == null)
      {
         place = new Point (20, 20);
      }
      else
      {
         place = new Point (lastPlace);

         place.y += windowOffset;
         place.x += windowOffset;

         if ( (place.x + size.width) > screenDim.width)
         {
            place.x = 20;
         }

         if ( (place.y + size.height) > screenDim.height)
         {
            place.y = 20;
         }
      }

      lastPlace = place;

      return place;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   String openDir = ".";


   /**
    * Get the fileForOpen attribute of the mpEDIT object
    *
    * @param textFrame  No description provided
    * @return           The fileForOpen value
    */
   private String getFileForOpen (TextFrame textFrame)
   {
      String prompt;
      String filename;
      String pathname;

      prompt = strings.getString ("DialogOpen");

      FileDialog d = new FileDialog (textFrame, prompt, FileDialog.LOAD);

      d.setFile ("*");
      d.setDirectory (openDir);
      d.setVisible (true);

      openDir = d.getDirectory();
      filename = d.getFile();
      pathname = openDir + filename;

      d.dispose();

      if (filename != null)
      {
         return pathname;
      }
      else
      {
         return null;
      }
   }


   /**
    * Get the keyAction attribute of the mpEDIT object
    *
    * @param modifiers  No description provided
    * @param keys       No description provided
    * @return           The keyAction value
    */
   public String getKeyAction (int modifiers, int keys)
   {
      return keyMap.getAction (modifiers, keys);
   }

   // this methods have fixed filenames for now - will change

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private final static String keytableFilename = "keys.set";


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void loadKeytable()
   {
      try
      {
         FileReader fr = new FileReader (keytableFilename);
         keyMap = new KeyMapFile (fr);
      }
      catch (FileNotFoundException e)
      {
         if (log.isInfoEnabled())
         {
            log.info ("No keys.set file");
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   public void saveKeytable()
   {
      try
      {
         FileWriter fw = new FileWriter (keytableFilename, false);
         keyMap.writeTo (fw);
      }
      catch (IOException e)
      {
         if (log.isInfoEnabled())
         {
            log.info ("Cannot save keys.set file");
         }
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Vector
   /*
    *  String
    */
      searchPatterns = new Vector();


   /**
    * Access method for an one to n association.
    *
    * @param patt  The object added.
    */
   public void addSearchPattern (String patt)
   {
      int i = searchPatterns.indexOf (patt);

      // do not do anything if it patt is last element
      if (i != searchPatterns.size() - 1)
      {
         // if already exists delete
         if (i >= 0)
         {
            searchPatterns.removeElementAt (i);
         }

         // add at end of a list
         searchPatterns.addElement (patt);
      }
   }


   /**
    * Get the searchPatterns attribute of the mpEDIT object
    *
    * @return   The searchPatterns value
    */
   public String[] getSearchPatterns()
   {
      String[] newArray = new String[searchPatterns.size()];
      searchPatterns.copyInto (newArray);
      return newArray;
   }


   /**
    * Get the latestSearchPattern attribute of the mpEDIT object
    *
    * @return   The latestSearchPattern value
    */
   public String getLatestSearchPattern()
   {
      return (String) searchPatterns.lastElement();
   }

   // remember where new files are being saved

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   String saveDir = ".";


   /**
    * Sets the saveDir attribute of the mpEDIT object
    *
    * @param dir  The new saveDir value
    */
   public void setSaveDir (String dir)
   {
      saveDir = dir;
   }


   /**
    * Get the saveDir attribute of the mpEDIT object
    *
    * @return   The saveDir value
    */
   public String getSaveDir()
   {
      return saveDir;
   }


   /**
    * Get the frameMain attribute of the mpEDIT object
    *
    * @return   The frameMain value
    */
   public FrameMain getFrameMain()
   {
      return frameMain;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param p  No description provided
    */
   public void updateProperties (Properties p)
   {
      int i;
      DocMan doc;

      props = p;
      i = docs.size();

      while (i-- > 0)
      {
         doc = (DocMan) docs.elementAt (i);
         doc.setProperties (props);
         doc.applyProperties();
      }

      propMan.writeProperties (p);
   }


   /**
    * Get the beans attribute of the mpEDIT object
    *
    * @return   The beans value
    */
   public Vector getBeans()
   {
      return beans;
   }


   /**
    * Closes all documents. If the "bail" flag is true changes will be discarded, otherwise
    * the user will be queried.
    *
    * @param bail  Exit immediately, discarding changes.
    */
   public void closeDocs (boolean bail)
   {
      DocMan d;

      int i = docs.size();

      while (--i >= 0)
      {
         d = (DocMan) docs.elementAt (i);
         d.closeDoc (bail);
      }
   }
}

/*
 * $Log: mpEDIT.java,v $
 * Revision 1.26.2.1  2005/09/30 18:57:14  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
