/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.10 $
 */
class TextCursor extends Thread
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private TextCanvas canvas;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean flash;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean undraw; // true when the next draw erases

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private Rectangle r;


   /**
    * Constructor for class TextCursor
    *
    * @param c  No description provided
    */
   public TextCursor (TextCanvas c)
   {
      canvas = c;
      r = new Rectangle();
   }


   /**
    * Main processing method for the TextCursor object
    */
   public void run()
   {
      while (true)
      {
         try
         {
            sleep (400);
         }
         catch (InterruptedException e)
         {
         }

         sync_draw();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private synchronized void sync_draw()
   {
      if (flash)
      {
         draw_or_undraw();
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param draw  No description provided
    */
   public synchronized void pause_cursor (boolean draw)
   {
      if (undraw)
      {
         draw_or_undraw();
      }

      flash = false;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param draw  No description provided
    */
   public synchronized void release_cursor (boolean draw)
   {
      if (!undraw)
      {
         draw_or_undraw();
      }

      flash = true;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @return   No description provided
    */
   private boolean draw_or_undraw()
   {
      Graphics g = canvas.getGraphics();

      if (g != null)
      {
         if (!undraw)
         {
            canvas.getCursorPos (g, r);
         }
         g.setColor (Color.black);
         g.setXORMode (Color.white);
         g.drawLine (r.x, r.y, r.x, r.y + r.height - 1);
         undraw = !undraw;
         g.dispose();
      }

      return undraw;
   }

//      public static void dumpStack() {new Exception("Stack trace").printStackTrace();}

}

/*
 * $Log: TextCursor.java,v $
 * Revision 1.10  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
