/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;


/**
 * The Ruler is used to measure pixel lengths of strings.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.14 $
 */
public class Ruler
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private DocMan docMan;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private FontMetrics fontMetrics;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int tabSize = 4;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private char before[];
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private char after[];

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private boolean hasTabs;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int beforeMax,
      afterMax;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private int lineLast;


   /**
    * Constructor for class Ruler
    *
    * @param dm  No description provided
    */
   public Ruler (DocMan dm)
   {
      docMan = dm;
      lineLast = -1;
   }

   // public methods are synchronized to guard lineLast and the buffers

   /**
    * Sets the fontMetrics attribute of the Ruler object
    *
    * @param fm  The new fontMetrics value
    */
   public synchronized void setFontMetrics (FontMetrics fm)
   {
      if (fm == fontMetrics)
      {
         return;
      }

      fontMetrics = fm;
      lineLast = -1;
   }


   /**
    * Sets the tabSize attribute of the Ruler object
    *
    * @param ts  The new tabSize value
    */
   public synchronized void setTabSize (int ts)
   {
      if (ts == tabSize)
      {
         return;
      }

      tabSize = ts;
      lineLast = -1;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param first  No description provided
    * @param last   No description provided
    */
   public synchronized void invalidate (int first, int last)
   {
      if ( (lineLast >= first) &&  (lineLast <= last))
      {
         lineLast = -1;
      }
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param line_no  No description provided
    */
   private void fillBuffers (int line_no)
   {
      char c;
      int i;
      int
         j;
      int
         tabs;
      int
         max;

      before = docMan.getLine (line_no).toCharArray();

      max = before.length;
      for (j = i = 0; i < max; i++)
      {
         if (before[i] == '\t')
         {
            j++;
         }
      }

      if (j == 0)
      {
         hasTabs = false;
         after = before;
         j = max;
      }
      else
      {
         hasTabs = true;
         after = new char[max +  (j *  (tabSize - 1))];

         for (j = i = 0; i < max; i++)
         {
            c = before[i];
            if (c == '\t')
            {
               tabs = tabSize -  (j % tabSize);
               while (tabs-- > 0)
               {
                  after[j++] = ' ';
               }
            }
            else
            {
               after[j++] = c;
            }
         }
      }

      lineLast = line_no;
      beforeMax = before.length;
      afterMax = j;

   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param line    No description provided
    * @param column  No description provided
    * @return        No description provided
    */
   public synchronized int length (int line, int column)
   {
      int i;
      int j;
      int uColumn;
      int tabs;
      char c;
      boolean readline;

      readline = line != lineLast;

      if (fontMetrics == null)
      {
         return -1;
      }

      if (column == 0)
      {
         return 0;
      }

      if (readline)
      {
         fillBuffers (line);
      }

      if (hasTabs)
      {
         uColumn = 1000000;

         for (i = j = 0; i < beforeMax; i++)
         {
            if (i == column)
            {
               uColumn = j;
               break;
            }

            c = before[i];
            if (c == '\t')
            {
               tabs = tabSize -  (j % tabSize);
               while (tabs-- > 0)
               {
                  j++;
               }
            }
            else
            {
               j++;
            }
         }

         afterMax = j;
         lineLast = line;
      }
      else
      {
         uColumn = column;
      }

      if (uColumn > afterMax)
      {
         uColumn = afterMax;
      }

      return fontMetrics.charsWidth (after, 0, uColumn);
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param line  No description provided
    * @param x     No description provided
    * @return      No description provided
    */
   public synchronized TextPosition position (int line, int x)
   {
      int i;
      int j;
      int pix;
      int temp;
      int diff;
      int odiff;
      int tabs;
      char c;
      boolean readline;

      readline = line != lineLast;

      if (fontMetrics == null)
      {
         return new TextPosition (0, 0, 0);
      }

      if (readline)
      {
         fillBuffers (line);
      }

      pix = temp = 0;
      diff = x;

      for (i = j = 0; i < beforeMax; i++)
      {
         c = before[i];
         if (c == '\t')
         {
            tabs = tabSize -  (j % tabSize);
            while (tabs-- > 0)
            {
               j++;
            }
         }
         else
         {
            j++;
         }

         odiff = diff;
         temp = fontMetrics.charsWidth (after, 0, j);
         diff = Math.abs (x - temp);

         if (diff >= odiff)
         {
            break;
         }

         pix = temp;
      }

      return new TextPosition (line, i, pix);
   }
}

/*
 * $Log: Ruler.java,v $
 * Revision 1.14  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
