/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact address:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.io.*;
import java.util.Properties;

import org.apache.log4j.Logger;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: mksoft $
 * @version   $Revision: 1.17.2.1 $
 */
public class PropMan
{
   /**
    * log4j logging
    */
   private final static transient Logger log = Logger.getLogger (PropMan.class);

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   Properties properties = null;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   private String prop_name = "mpEdit.ini";


   /**
    * Sets the defaults attribute of the PropMan object
    */
   private void setDefaults()
   {
      properties.put ("mpEDIT.font.name", "Courier");
      properties.put ("mpEDIT.font.style", String.valueOf (Font.PLAIN));
      properties.put ("mpEDIT.font.size", "12");
      properties.put ("mpEDIT.tab.size", "4");
      properties.put ("mpEDIT.hilite", String.valueOf (true));
      properties.put ("mpEDIT.hide", String.valueOf (false));
      properties.put ("mpEDIT.hide.level", "0");
   }


   /**
    * Get the properties attribute of the PropMan object
    *
    * @return   The properties value
    */
   public Properties getProperties()
   {
      if (properties == null)
      {
         properties = new Properties();
         setDefaults();

         try
         {
            FileInputStream sf = new FileInputStream (prop_name);
            properties.load (sf);
            sf.close();
         }
         catch (Exception e)
         {
         }
      }

      return properties;
   }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param p  No description provided
    */
   public void writeProperties (Properties p)
   {
      properties = p;

      try
      {
         FileOutputStream od = new FileOutputStream (prop_name);
         properties.store (od, "Settings for mpEdit");
         od.close();
      }

      catch (IOException e)
      {
         if (log.isInfoEnabled())
         {
            log.info ("Warning: properties could not be saved");
         }
      }
   }
}

/*
 * $Log: PropMan.java,v $
 * Revision 1.17.2.1  2005/09/30 18:57:14  mksoft
 * replacing many System.out.println with if (log.isInfoEnabled()) log.info ()
 *
 */
