/*
 * The FUJABA ToolSuite project:
 *
 *   FUJABA is the acronym for 'From Uml to Java And Back Again'
 *   and originally aims to provide an environment for round-trip
 *   engineering using UML as visual programming language. During
 *   the last years, the environment has become a base for several
 *   research activities, e.g. distributed software, database
 *   systems, modelling mechanical and electrical systems and
 *   their simulation. Thus, the environment has become a project,
 *   where this source code is part of. Further details are avail-
 *   able via http://www.fujaba.de
 *
 *      Copyright (C) 1997-2004 Fujaba Development Group
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *   MA 02111-1307, USA or download the license under
 *   http://www.gnu.org/copyleft/lesser.html
 *
 * WARRANTY:
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *   GNU Lesser General Public License for more details.
 *
 * Contact adress:
 *
 *   Fujaba Management Board
 *   Software Engineering Group
 *   University of Paderborn
 *   Warburgerstr. 100
 *   D-33098 Paderborn
 *   Germany
 *
 *   URL  : http://www.fujaba.de
 *   email: info@fujaba.de
 *
 */
package de.uni_paderborn.fujaba.mpEdit;

import java.awt.*;
import java.awt.event.*;
import java.util.ResourceBundle;

import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;


/**
 * No comment provided by developer, please add a comment to improve documentation.
 *
 * @author    $Author: schneider $
 * @version   $Revision: 1.18 $
 */
class PropDialog extends JDialog implements WindowListener,
   ActionListener
{
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   DocMan docMan;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JButton ok,
      cancel;

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField tabField = new JTextField (3);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox fontChoice = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox styleChoice = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JComboBox sizeChoice = new JComboBox();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   ButtonGroup checkGroup = new ButtonGroup();
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JCheckBox syntax;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JCheckBox hiding;
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JTextField hideLevel = new JTextField (3);
   /**
    * No comment provided by developer, please add a comment to improve documentation.
    */
   JRadioButton checkThisDoc,
      checkAllDocs;


   /**
    * Constructor for class PropDialog
    *
    * @param textFrame  No description provided
    * @param strings    No description provided
    * @param dm         No description provided
    * @param title      No description provided
    */
   public PropDialog (TextFrame textFrame, ResourceBundle strings, DocMan dm, String title)
   {
      super (textFrame, title, true);

      docMan = dm;

      getContentPane().setLayout (new GridBagLayout());

      JPanel p = new JPanel();
      p.add (new JLabel (strings.getString ("PromptFont")));
      String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
      fontChoice.setEditable (false);
      for (int i = 0; i < fontNames.length; i++)
      {
         fontChoice.addItem (fontNames[i]);
      }
      fontChoice.setSelectedItem (docMan.getProperty ("mpEDIT.font.name"));
      p.add (fontChoice);
      GridBagConstraints constraints = new GridBagConstraints();
      constraints.insets = new Insets (15, 15, 15, 15);
      constraints.anchor = GridBagConstraints.WEST;
      constraints.weightx = 1;
      constraints.gridy = 0;
      constraints.gridx = 0;
      getContentPane().add (p, constraints);

      p = new JPanel();
      p.add (new JLabel (strings.getString ("PromptStyle")));
      styleChoice.setEditable (false);
      styleChoice.addItem (strings.getString ("ChoicePlain"));
      styleChoice.addItem (strings.getString ("ChoiceBold"));
      styleChoice.addItem (strings.getString ("ChoiceItalic"));
      styleChoice.addItem (strings.getString ("ChoiceBoldItalic"));
      styleChoice.setSelectedItem (docMan.getFontStyle());
      p.add (styleChoice);
      constraints.gridx = 1;
      getContentPane().add (p, constraints);

      p = new JPanel();
      p.add (new JLabel (strings.getString ("PromptSize")));
      sizeChoice.setEditable (false);
      sizeChoice.addItem ("8");
      sizeChoice.addItem ("9");
      sizeChoice.addItem ("10");
      sizeChoice.addItem ("11");
      sizeChoice.addItem ("12");
      sizeChoice.addItem ("14");
      sizeChoice.addItem ("16");
      sizeChoice.addItem ("18");
      sizeChoice.addItem ("24");
      sizeChoice.addItem ("36");
      sizeChoice.addItem ("48");
      sizeChoice.setSelectedItem (docMan.getProperty ("mpEDIT.font.size"));
      p.add (sizeChoice);
      constraints.gridx = 2;
      getContentPane().add (p, constraints);

      p = new JPanel();
      p.add (new JLabel (strings.getString ("PromptTab")));
      tabField.setText (docMan.getProperty ("mpEDIT.tab.size"));
      p.add (tabField);
      constraints.gridy = 1;
      constraints.gridx = 0;
      constraints.gridwidth = 3;
      getContentPane().add (p, constraints);

      p = new JPanel (new GridBagLayout());
      GridBagConstraints myconstraints = new GridBagConstraints();

      hiding = new JCheckBox (strings.getString ("HideSourcecode"));
      hiding.setSelected (Boolean.valueOf (docMan.getProperty ("mpEDIT.hide")).booleanValue());

      hideLevel.setText (docMan.getProperty ("mpEDIT.hide.level"));

      syntax = new JCheckBox (strings.getString ("PromptSyntax"));
      syntax.setSelected (Boolean.valueOf (docMan.getProperty ("mpEDIT.hilite")).booleanValue());
      syntax.addChangeListener (
         new ChangeListener()
         {
            public void stateChanged (ChangeEvent e)
            {
               hiding.setEnabled (syntax.isSelected());
               if (syntax.isSelected())
               {
                  hideLevel.setText (docMan.getProperty ("mpEDIT.hide.level"));
               }
            }
         });

      p.add (syntax, myconstraints);

      myconstraints.gridy = 1;
      p.add (hiding, myconstraints);

      p.add (new JLabel (strings.getString ("HideLevel")), myconstraints);

      p.add (hideLevel, myconstraints);

      constraints.gridy = GridBagConstraints.RELATIVE;
      getContentPane().add (p, constraints);

      p = new JPanel();
      checkThisDoc = new JRadioButton (strings.getString ("CheckThisDoc"));
      checkAllDocs = new JRadioButton (strings.getString ("CheckAllDocs"));
      checkGroup = new ButtonGroup();
      checkGroup.add (checkThisDoc);
      checkGroup.add (checkAllDocs);
      p.add (new JLabel (strings.getString ("PromptLocal")));
      p.add (checkThisDoc);
      p.add (checkAllDocs);
      constraints.gridy = 3;
      getContentPane().add (p, constraints);

      constraints.gridy = 4;
      constraints.gridx = 1;
      constraints.gridwidth = 1;
      constraints.anchor = GridBagConstraints.CENTER;
      ok = new JButton (strings.getString ("ButtonOk"));
      ok.addActionListener (this);
      getContentPane().add (ok, constraints);

      constraints.gridx = 2;
      cancel = new JButton (strings.getString ("ButtonCancel"));
      cancel.addActionListener (this);
      getContentPane().add (cancel, constraints);

      pack();
      Dimension size = getSize();
      //      setSize (size);
      setLocation (textFrame.getPlace (size));

      addWindowListener (this);
   }

   // dispose on 'ok'

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void actionPerformed (ActionEvent event)
   {

      if (event.getSource() == ok)
      {
         boolean all = checkAllDocs.isSelected();

         if (!all)
         {
            docMan.splitProperties();
         }

         docMan.setProperty ("mpEDIT.font.name", (String) fontChoice.getSelectedItem());
         docMan.setFontStyle ((String) styleChoice.getSelectedItem());
         docMan.setProperty ("mpEDIT.font.size", (String) sizeChoice.getSelectedItem());
         docMan.setProperty ("mpEDIT.tab.size", tabField.getText());
         docMan.setProperty ("mpEDIT.hilite", String.valueOf (syntax.isSelected()));
         docMan.setProperty ("mpEDIT.hide", String.valueOf (hiding.isSelected()));
         docMan.setProperty ("mpEDIT.hide.level", hideLevel.getText());

         docMan.updateProperties (all);

         docMan.scan(); //Rebuild all LineInfos in LineMan to remove existing syntax highlighting
      }

      dispose();
   }

   // add the 1.1 WindowListener stuff

   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeiconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowIconified (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowActivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowDeactivated (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowOpened (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosed (WindowEvent event) { }


   /**
    * No comment provided by developer, please add a comment to improve documentation.
    *
    * @param event  No description provided
    */
   public void windowClosing (WindowEvent event)
   {
      dispose();
   }

}

/*
 * $Log: PropDialog.java,v $
 * Revision 1.18  2004/10/20 17:50:01  schneider
 * Introduction of interfaces for class diagram classes
 *
 */
